/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.similarity;

public final class JaroWinkler {
    private JaroWinkler() {
    }

    public static double distance(int[] cps1, int[] cps2) {
        return cps1.length < cps2.length ? JaroWinkler.dst(cps1, cps2) : JaroWinkler.dst(cps2, cps1);
    }

    private static double dst(int[] min, int[] max) {
        int i;
        int mn = min.length;
        int mx = max.length;
        int r = Math.max((mx >> 1) - 1, 0);
        boolean[] o1 = new boolean[mn];
        boolean[] o2 = new boolean[mx];
        int m = 0;
        block0: for (int i2 = 0; i2 < mn; ++i2) {
            int c = min[i2];
            int jl = Math.min(i2 + r + 1, mx);
            for (int j = Math.max(i2 - r, 0); j < jl; ++j) {
                if (o2[j] || c != max[j]) continue;
                o2[j] = true;
                o1[i2] = true;
                ++m;
                continue block0;
            }
        }
        if (m == 0) {
            return 0.0;
        }
        int[] ms1 = new int[m];
        int[] ms2 = new int[m];
        int si = 0;
        for (i = 0; i < mn; ++i) {
            if (!o1[i]) continue;
            ms1[si++] = min[i];
        }
        si = 0;
        for (i = 0; i < mx; ++i) {
            if (!o2[i]) continue;
            ms2[si++] = max[i];
        }
        int t = 0;
        for (int i3 = 0; i3 < m; ++i3) {
            if (ms1[i3] == ms2[i3]) continue;
            ++t;
        }
        int p = 0;
        for (int i4 = 0; i4 < mn && min[i4] == max[i4]; ++i4) {
            ++p;
        }
        double d = m;
        double j = (d / (double)mn + d / (double)mx + (d - (double)(t >> 1)) / d) / 3.0;
        double jw = j < 0.7 ? j : j + Math.min(0.1, 1.0 / (double)mx) * (double)p * (1.0 - j);
        return (double)Math.round(jw * 100.0) / 100.0;
    }
}

