/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.TrieBranch;
import org.basex.query.value.map.TrieLeaf;
import org.basex.query.value.map.TrieUpdate;
import org.basex.util.TokenBuilder;

abstract class TrieNode {
    static final int BITS = 5;
    static final int KIDS = 32;
    private static final int MASK = 31;
    final int size;

    TrieNode(int size) {
        this.size = size;
    }

    abstract TrieNode put(int var1, int var2, TrieUpdate var3) throws QueryException;

    final TrieBranch branch(int hs, int lv, int hash, int sz, TrieUpdate update) throws QueryException {
        int used;
        int b;
        TrieNode[] ch = new TrieNode[32];
        int a = TrieNode.hashKey(hs, lv);
        if (a == (b = TrieNode.hashKey(hash, lv))) {
            ch[a] = this.put(hs, lv + 1, update);
            used = 1 << a;
        } else {
            update.add();
            ch[a] = new TrieLeaf(hs, update.key, update.value);
            ch[b] = this;
            used = 1 << a | 1 << b;
        }
        return new TrieBranch(ch, used, sz + 1);
    }

    abstract TrieNode remove(int var1, int var2, TrieUpdate var3) throws QueryException;

    abstract Value get(int var1, Item var2, int var3) throws QueryException;

    static int hashKey(int hash, int level) {
        return hash >>> level * 5 & 0x1F;
    }

    abstract void add(TokenBuilder var1, String var2);

    public String toString() {
        TokenBuilder tb = new TokenBuilder();
        this.add(tb, "");
        return tb.toString();
    }
}

