/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.format;

import org.basex.query.util.format.FormatParser;
import org.basex.query.util.format.Formatter;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

final class FormatterDE
extends Formatter {
    private static final byte[][] WORDS = Token.tokens("null", "eins", "zwei", "drei", "vier", "f\u00fcnf", "sechs", "sieben", "acht", "neun", "zehn", "elf", "zw\u00f6lf", "dreizehn", "vierzehn", "f\u00fcnfzehn", "sechzehn", "siebzehn", "achtzehn", "neunzehn");
    private static final byte[][] WORDS20 = Token.tokens("", "", "zwanzig", "drei\u00dfig", "vierzig", "f\u00fcnfzig", "sechzig", "siebzig", "achtzig", "neunzig");
    private static final byte[][] WORDS1000000 = Token.tokens("Million", "Milliarde", "Billion", "Billiarde", "Trillion");
    private static final long[] UNITS100 = new long[]{1000000L, 1000000000L, 1000000000000L, 1000000000000000L, 1000000000000000000L};
    private static final byte[][] ORDINALS = Token.tokens("nullt", "erst", "zweit", "dritt", "viert", "f\u00fcnft", "sechst", "siebt", "acht", "neunt", "zehnt", "elft", "zw\u00f6lft", "dreizehnt", "vierzehnt", "f\u00fcnfzehnt", "sechzehnt", "siebzehnt", "achtzehnt", "neunzehnt");
    private static final byte[][][] DAYS = new byte[][][]{Token.tokens("Mo", "Mon", "Montag"), Token.tokens("Di", "Die", "Dienstag"), Token.tokens("Mi", "Mit", "Mittwoch"), Token.tokens("Do", "Don", "Donnerstag"), Token.tokens("Fr", "Fre", "Freitag"), Token.tokens("Sa", "Sam", "Samstag"), Token.tokens("So", "Son", "Sonntag")};
    private static final byte[][] MONTHS = Token.tokens("Januar", "Februar", "M\u00e4rz", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember");
    private static final byte[][] AMPM = Token.tokens("a.m.", "p.m.");
    private static final byte[] UND = Token.token("und");
    private static final byte[] EIN = Token.token("ein");
    private static final byte[] EINE = Token.token("eine");
    private static final byte[] E = Token.cpToken(101);
    private static final byte[] HUNDERT = Token.token("hundert");
    private static final byte[] TAUSEND = Token.token("tausend");
    private static final byte[][] ERAS = Token.tokens("v. Chr.", "n. Chr.");

    FormatterDE() {
    }

    @Override
    public byte[] word(long n, FormatParser.NumeralType numType, byte[] modifier) {
        byte[] suffix = modifier == null || modifier[0] == 37 ? null : Token.delete(modifier, 45);
        TokenBuilder tb = new TokenBuilder();
        FormatterDE.word(tb, n, numType, suffix);
        if (!tb.isEmpty()) {
            tb.set(0, (byte)Token.uc(tb.get(0)));
        }
        return tb.finish();
    }

    @Override
    public byte[] suffix(long n, FormatParser.NumeralType numType) {
        return numType == FormatParser.NumeralType.ORDINAL ? E : Token.EMPTY;
    }

    @Override
    public byte[] month(int n, int min, int max) {
        return FormatterDE.format(MONTHS[n], min, max);
    }

    @Override
    public byte[] day(int n, int min, int max) {
        TokenBuilder tb = new TokenBuilder();
        byte[][] formats = DAYS[n];
        int f = formats.length;
        while (--f > 0 && max < formats[f].length) {
        }
        tb.add(formats[f]);
        while (tb.size() < min) {
            tb.add(32);
        }
        return tb.finish();
    }

    @Override
    public byte[] ampm(boolean am) {
        return AMPM[am ? 0 : 1];
    }

    @Override
    public byte[] calendar() {
        return ERAS[1];
    }

    @Override
    public byte[] era(long year) {
        return ERAS[year <= 0L ? 0 : 1];
    }

    private static void word(TokenBuilder tb, long n, FormatParser.NumeralType numType, byte[] suffix) {
        if (n == 0L && !tb.isEmpty()) {
            if (numType == FormatParser.NumeralType.ORDINAL) {
                tb.add("st").add(suffix == null ? E : suffix);
            }
        } else if (n < 20L) {
            if (numType != FormatParser.NumeralType.ORDINAL) {
                tb.add(WORDS[(int)n]);
            } else {
                tb.add(ORDINALS[(int)n]).add(suffix == null ? E : suffix);
            }
        } else if (n < 100L) {
            int r = (int)(n % 10L);
            if (r != 0) {
                tb.add(r == 1 ? EIN : WORDS[r]).add(UND);
            }
            tb.add(WORDS20[(int)n / 10]);
            if (numType == FormatParser.NumeralType.ORDINAL) {
                tb.add("st").add(suffix == null ? E : suffix);
            }
        } else if (n < 1000L) {
            if (n < 200L) {
                tb.add(EIN);
            } else {
                FormatterDE.word(tb, n / 100L, FormatParser.NumeralType.NUMBERING, null);
            }
            tb.add(HUNDERT);
            FormatterDE.word(tb, n % 100L, numType, suffix);
        } else if (n < 1000000L) {
            long m = n % 100000L;
            if (m >= 1000L && m < 2000L) {
                FormatterDE.word(tb, n / 1000L, FormatParser.NumeralType.NUMBERING, null);
                tb.delete(tb.size() - 1, tb.size());
            } else {
                FormatterDE.word(tb, n / 1000L, FormatParser.NumeralType.NUMBERING, null);
            }
            tb.add(TAUSEND);
            FormatterDE.word(tb, n % 1000L, numType, suffix);
        } else {
            int w = WORDS1000000.length;
            while (--w > 0 && n < UNITS100[w]) {
            }
            long f = UNITS100[w];
            long i = n / f;
            if (i == 1L) {
                tb.add(EINE);
            } else {
                FormatterDE.word(tb, i, FormatParser.NumeralType.NUMBERING, null);
            }
            tb.add(32).add(WORDS1000000[w]);
            long r = n % f;
            if (numType == FormatParser.NumeralType.ORDINAL && r == 0L) {
                tb.add("st").add(suffix == null ? E : suffix);
            } else if (i > 1L) {
                tb.add(w % 2 == 0 ? "en" : "n");
            }
            if (r != 0L) {
                tb.add(32);
                FormatterDE.word(tb, r, numType, suffix);
            }
        }
    }
}

