/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.internal;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ExecutorSingleton {
    private static ExecutorService sExecutorService = ExecutorSingleton.create();

    public static synchronized ExecutorService getExecutor() {
        ExecutorSingleton.checkExecutor();
        return sExecutorService;
    }

    public static synchronized void shutdown() {
        if (sExecutorService != null) {
            sExecutorService.shutdown();
            sExecutorService = null;
        }
    }

    public static synchronized void restart() {
        ExecutorSingleton.shutdown();
        sExecutorService = ExecutorSingleton.create();
    }

    private static void checkExecutor() {
        if (sExecutorService == null) {
            throw new RuntimeException("Executor Singleton not started");
        }
    }

    private static ExecutorService create() {
        return Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    }
}

