/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.format;

import com.android.ide.eclipse.gltrace.format.GLDataTypeSpec;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GLAPISpec {
    private static final String GL_SPECS_FILE = "/entries.in";
    private static final String GLES2_ENTRIES_HEADER_V1 = "# com.android.ide.eclipse.gltrace.glentries, v1";
    private static Map<String, GLAPISpec> sApiSpecs;
    private final String mGLFunction;
    private final GLDataTypeSpec mReturnType;
    private final List<GLDataTypeSpec> mArgs;

    private GLAPISpec(String glFunction, GLDataTypeSpec returnType, List<GLDataTypeSpec> args) {
        this.mGLFunction = glFunction;
        this.mReturnType = returnType;
        this.mArgs = args;
    }

    public String getFunction() {
        return this.mGLFunction;
    }

    public GLDataTypeSpec getReturnValue() {
        return this.mReturnType;
    }

    public List<GLDataTypeSpec> getArgs() {
        return this.mArgs;
    }

    public static Map<String, GLAPISpec> getSpecs() {
        if (sApiSpecs == null) {
            sApiSpecs = GLAPISpec.parseApiSpecs(GLAPISpec.class.getResourceAsStream(GL_SPECS_FILE));
        }
        return sApiSpecs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, GLAPISpec> parseApiSpecs(InputStream specFile) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(specFile));
        HashMap<String, GLAPISpec> specs = new HashMap<String, GLAPISpec>(400);
        try {
            String header = reader.readLine().trim();
            assert (header.equals(GLES2_ENTRIES_HEADER_V1));
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    specFile.close();
                    return specs;
                }
                int commentPos = line.indexOf(35);
                if (commentPos != -1) {
                    line = line.substring(0, commentPos);
                }
                if ((line = line.trim()).length() <= 0) continue;
                GLAPISpec spec = GLAPISpec.parseLine(line);
                specs.put(spec.getFunction(), spec);
            }
        }
        catch (IOException iOException) {}
        return specs;
    }

    static GLAPISpec parseLine(String line) {
        List<String> words = Arrays.asList(line.split(","));
        String retType = words.get(0).trim();
        String func = words.get(1).trim();
        List<String> argDefinitions = words.subList(2, words.size());
        ArrayList<GLDataTypeSpec> glArgs = new ArrayList<GLDataTypeSpec>(argDefinitions.size() / 2);
        for (String argDefn : argDefinitions) {
            int lastSeparator = (argDefn = argDefn.trim()).lastIndexOf(32);
            if (lastSeparator == -1) {
                glArgs.add(new GLDataTypeSpec(argDefn, null));
                continue;
            }
            String type = argDefn.substring(0, lastSeparator);
            String name = argDefn.substring(lastSeparator + 1);
            glArgs.add(new GLDataTypeSpec(type, name));
        }
        return new GLAPISpec(func, new GLDataTypeSpec(retType, null), glArgs);
    }
}

