/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.HtmlReporter;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.Warning;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.SdkUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class MultiProjectHtmlReporter
extends HtmlReporter {
    private static final String INDEX_NAME = "index.html";
    private final File mDir;

    public MultiProjectHtmlReporter(LintCliClient client, File dir) throws IOException {
        super(client, new File(dir, INDEX_NAME));
        this.mDir = dir;
    }

    @Override
    public void write(int errorCount, int warningCount, List<Warning> allIssues) throws IOException {
        HashMap<Project, ArrayList<Warning>> projectToWarnings = new HashMap<Project, ArrayList<Warning>>();
        for (Warning warning : allIssues) {
            ArrayList<Warning> list = (ArrayList<Warning>)projectToWarnings.get(warning.project);
            if (list == null) {
                list = new ArrayList<Warning>();
                projectToWarnings.put(warning.project, list);
            }
            list.add(warning);
        }
        HashSet unique = Sets.newHashSet();
        unique.add(INDEX_NAME.toLowerCase(Locale.US));
        ArrayList projects = Lists.newArrayList();
        for (Project project : projectToWarnings.keySet()) {
            String relative;
            boolean deleted;
            String fileName;
            String lowercase;
            String projectName = project.getName();
            int number = 1;
            while (true) {
                String numberString;
                if (!unique.contains(lowercase = (fileName = String.format("%1$s%2$s.html", projectName, numberString = number > 1 ? Integer.toString(number) : "")).toLowerCase(Locale.US))) break;
                ++number;
            }
            unique.add(lowercase);
            File output = new File(this.mDir, fileName);
            if (output.exists() && !(deleted = output.delete())) {
                this.mClient.log(null, "Could not delete old file %1$s", output);
                continue;
            }
            if (!output.getParentFile().canWrite()) {
                this.mClient.log(null, "Cannot write output file %1$s", output);
                continue;
            }
            HtmlReporter reporter = new HtmlReporter(this.mClient, output);
            reporter.setBundleResources(this.mBundleResources);
            reporter.setSimpleFormat(this.mSimpleFormat);
            reporter.setUrlMap(this.mUrlMap);
            List issues = (List)projectToWarnings.get(project);
            int projectErrorCount = 0;
            int projectWarningCount = 0;
            for (Warning warning : issues) {
                if (warning.severity == Severity.ERROR || warning.severity == Severity.FATAL) {
                    ++projectErrorCount;
                    continue;
                }
                if (warning.severity != Severity.WARNING) continue;
                ++projectWarningCount;
            }
            String prefix = project.getReferenceDir().getPath();
            String path = project.getDir().getPath();
            if (path.startsWith(prefix) && path.length() > prefix.length()) {
                int i = prefix.length();
                if (path.charAt(i) == File.separatorChar) {
                    ++i;
                }
                relative = path.substring(i);
            } else {
                relative = projectName;
            }
            reporter.setTitle(String.format("Lint Report for %1$s", relative));
            reporter.setStripPrefix(relative);
            reporter.write(projectErrorCount, projectWarningCount, issues);
            projects.add(new ProjectEntry(fileName, projectErrorCount, projectWarningCount, relative));
        }
        this.writeOverview(errorCount, warningCount, projects);
        Closeables.closeQuietly((Closeable)this.mWriter);
        if (this.mDisplayEmpty || errorCount > 0 || warningCount > 0) {
            File index = new File(this.mDir, INDEX_NAME);
            String url = SdkUtils.fileToUrlString((File)index.getAbsoluteFile());
            System.out.println(String.format("Wrote overview index to %1$s", url));
        }
    }

    private void writeOverview(int errorCount, int warningCount, List<ProjectEntry> projects) throws IOException {
        this.mWriter.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n<title>" + this.mTitle + "</title>\n");
        this.writeStyleSheet();
        this.mWriter.write("</head>\n<body>\n<h1>" + this.mTitle + "</h1>\n" + "<div class=\"titleSeparator\"></div>\n");
        Collections.sort(projects);
        this.mWriter.write(String.format("Check performed at %1$s.", new Date().toString()));
        this.mWriter.write("<br/>\n");
        this.mWriter.write(String.format("%1$d errors and %2$d warnings found:\n", errorCount, warningCount));
        this.mWriter.write("<br/><br/>\n");
        if (errorCount == 0 && warningCount == 0) {
            this.mWriter.write("Congratulations!");
            return;
        }
        String errorUrl = null;
        String warningUrl = null;
        if (!this.mSimpleFormat) {
            errorUrl = this.addLocalResources(HtmlReporter.getErrorIconUrl());
            warningUrl = this.addLocalResources(HtmlReporter.getWarningIconUrl());
        }
        this.mWriter.write("<table class=\"overview\">\n");
        this.mWriter.write("<tr><th>");
        this.mWriter.write("Project");
        this.mWriter.write("</th><th class=\"countColumn\">");
        if (errorUrl != null) {
            this.mWriter.write("<img border=\"0\" align=\"top\" src=\"");
            this.mWriter.write(errorUrl);
            this.mWriter.write("\" alt=\"Error\" />\n");
        }
        this.mWriter.write("Errors");
        this.mWriter.write("</th><th class=\"countColumn\">");
        if (warningUrl != null) {
            this.mWriter.write("<img border=\"0\" align=\"top\" src=\"");
            this.mWriter.write(warningUrl);
            this.mWriter.write("\" alt=\"Warning\" />\n");
        }
        this.mWriter.write("Warnings");
        this.mWriter.write("</th></tr>\n");
        for (ProjectEntry entry : projects) {
            this.mWriter.write("<tr><td>");
            this.mWriter.write("<a href=\"");
            this.appendEscapedText(entry.fileName);
            this.mWriter.write("\">");
            this.mWriter.write(entry.path);
            this.mWriter.write("</a></td><td class=\"countColumn\">");
            this.mWriter.write(Integer.toString(entry.errorCount));
            this.mWriter.write("</td><td class=\"countColumn\">");
            this.mWriter.write(Integer.toString(entry.warningCount));
            this.mWriter.write("</td></tr>\n");
        }
        this.mWriter.write("</table>\n");
        this.mWriter.write("</body>\n</html>\n");
    }

    private static class ProjectEntry
    implements Comparable<ProjectEntry> {
        public final int errorCount;
        public final int warningCount;
        public final String fileName;
        public final String path;

        public ProjectEntry(String fileName, int errorCount, int warningCount, String path) {
            this.fileName = fileName;
            this.errorCount = errorCount;
            this.warningCount = warningCount;
            this.path = path;
        }

        @Override
        public int compareTo(ProjectEntry other) {
            int delta = other.errorCount - this.errorCount;
            if (delta != 0) {
                return delta;
            }
            delta = other.warningCount - this.warningCount;
            if (delta != 0) {
                return delta;
            }
            return this.path.compareTo(other.path);
        }
    }
}

