/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.ast.Node;
import lombok.ast.Position;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.ecj.EcjTreeConverter;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.CharLiteral;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.DoubleLiteral;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.jdt.internal.compiler.ast.FloatLiteral;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.Literal;
import org.eclipse.jdt.internal.compiler.ast.LongLiteral;
import org.eclipse.jdt.internal.compiler.ast.MagicLiteral;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.NumberLiteral;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.jdt.internal.compiler.impl.ByteConstant;
import org.eclipse.jdt.internal.compiler.impl.CharConstant;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.DoubleConstant;
import org.eclipse.jdt.internal.compiler.impl.FloatConstant;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.impl.LongConstant;
import org.eclipse.jdt.internal.compiler.impl.ShortConstant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class EcjParser
extends JavaParser {
    private static final boolean DEBUG_DUMP_PARSE_ERRORS = false;
    private final LintClient mClient;
    private final Project mProject;
    private Map<File, ICompilationUnit> mSourceUnits;
    private Map<ICompilationUnit, CompilationUnitDeclaration> mCompiled;
    private Parser mParser;

    public EcjParser(@NonNull LintCliClient client, @Nullable Project project) {
        this.mClient = client;
        this.mProject = project;
        this.mParser = this.getParser();
    }

    public static CompilerOptions createCompilerOptions() {
        long languageLevel;
        CompilerOptions options = new CompilerOptions();
        options.complianceLevel = languageLevel = 0x330000L;
        options.sourceLevel = languageLevel;
        options.targetJDK = languageLevel;
        options.originalComplianceLevel = languageLevel;
        options.originalSourceLevel = languageLevel;
        options.inlineJsrBytecode = true;
        options.parseLiteralExpressionsAsConstants = true;
        options.analyseResourceLeaks = false;
        options.docCommentSupport = false;
        options.defaultEncoding = "UTF-8";
        options.suppressOptionalErrors = true;
        options.generateClassFiles = false;
        options.isAnnotationBasedNullAnalysisEnabled = false;
        options.reportUnusedDeclaredThrownExceptionExemptExceptionAndThrowable = false;
        options.reportUnusedDeclaredThrownExceptionIncludeDocCommentReference = false;
        options.reportUnusedDeclaredThrownExceptionWhenOverriding = false;
        options.reportUnusedParameterIncludeDocCommentReference = false;
        options.reportUnusedParameterWhenImplementingAbstract = false;
        options.reportUnusedParameterWhenOverridingConcrete = false;
        options.suppressWarnings = true;
        options.processAnnotations = true;
        options.verbose = false;
        return options;
    }

    public static long getLanguageLevel(int major, int minor) {
        assert (major == 1);
        switch (minor) {
            case 5: {
                return 0x310000L;
            }
            case 6: {
                return 0x320000L;
            }
        }
        return 0x330000L;
    }

    private Parser getParser() {
        if (this.mParser == null) {
            CompilerOptions options = EcjParser.createCompilerOptions();
            ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.exitOnFirstError(), options, new DefaultProblemFactory());
            this.mParser = new Parser(problemReporter, options.parseLiteralExpressionsAsConstants);
            this.mParser.javadocParser.checkDocComment = false;
        }
        return this.mParser;
    }

    @Override
    public void prepareJavaParse(@NonNull List<JavaContext> contexts) {
        if (this.mProject == null || contexts.isEmpty()) {
            return;
        }
        ArrayList sources = Lists.newArrayListWithExpectedSize((int)contexts.size());
        this.mSourceUnits = Maps.newHashMapWithExpectedSize((int)sources.size());
        for (JavaContext context : contexts) {
            String contents = context.getContents();
            if (contents == null) continue;
            File file = context.file;
            CompilationUnit unit = new CompilationUnit(contents.toCharArray(), file.getPath(), "UTF-8");
            sources.add(unit);
            this.mSourceUnits.put(file, unit);
        }
        List<String> classPath = this.computeClassPath(contexts);
        this.mCompiled = Maps.newHashMapWithExpectedSize((int)this.mSourceUnits.size());
        try {
            EcjParser.parse(EcjParser.createCompilerOptions(), sources, classPath, this.mCompiled, this.mClient);
        }
        catch (Throwable t) {
            this.mClient.log(t, "ECJ compiler crashed", new Object[0]);
        }
    }

    public static void parse(CompilerOptions options, @NonNull List<ICompilationUnit> sourceUnits, @NonNull List<String> classPath, @NonNull Map<ICompilationUnit, CompilationUnitDeclaration> outputMap, @Nullable LintClient client) {
        FileSystem environment = new FileSystem(classPath.toArray(new String[classPath.size()]), new String[0], options.defaultEncoding);
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        ICompilerRequestor requestor = new ICompilerRequestor(){

            @Override
            public void acceptResult(CompilationResult result) {
            }
        };
        NonGeneratingCompiler compiler = new NonGeneratingCompiler((INameEnvironment)environment, policy, options, requestor, (IProblemFactory)problemFactory, outputMap);
        try {
            compiler.compile(sourceUnits.toArray(new ICompilationUnit[sourceUnits.size()]));
        }
        catch (Throwable t) {
            if (client != null) {
                CompilationUnitDeclaration currentUnit = compiler.getCurrentUnit();
                if (currentUnit == null || currentUnit.getFileName() == null) {
                    client.log(t, "ECJ compiler crashed", new Object[0]);
                } else {
                    client.log(t, "ECJ compiler crashed processing %1$s", new String(currentUnit.getFileName()));
                }
            }
            t.printStackTrace();
        }
    }

    @NonNull
    private List<String> computeClassPath(@NonNull List<JavaContext> contexts) {
        String androidJar;
        assert (this.mProject != null);
        ArrayList classPath = Lists.newArrayList();
        IAndroidTarget compileTarget = this.mProject.getBuildTarget();
        if (compileTarget != null && (androidJar = compileTarget.getPath(1)) != null) {
            classPath.add(androidJar);
        }
        HashSet libraries = Sets.newHashSet();
        HashSet names = Sets.newHashSet();
        for (File library : this.mProject.getJavaLibraries()) {
            libraries.add(library);
            names.add(EcjParser.getLibraryName(library));
        }
        for (Project project : this.mProject.getAllLibraries()) {
            for (File library : project.getJavaLibraries()) {
                String name = EcjParser.getLibraryName(library);
                if (names.contains(name)) continue;
                libraries.add(library);
                names.add(name);
            }
        }
        for (File file : libraries) {
            classPath.add(file.getPath());
        }
        EnumSet<Scope> scope = contexts.get(0).getScope();
        if (!scope.contains((Object)Scope.ALL_JAVA_FILES)) {
            for (File dir : this.mProject.getJavaClassFolders()) {
                classPath.add(dir.getPath());
            }
        }
        return classPath;
    }

    @NonNull
    private static String getLibraryName(@NonNull File library) {
        String name = library.getName();
        if (name.equals("classes.jar")) {
            String path = library.getPath();
            int index = path.indexOf("exploded-aar");
            if (index != -1) {
                return path.substring(index);
            }
            index = path.indexOf("exploded-bundles");
            if (index != -1) {
                return path.substring(index);
            }
            File parent = library.getParentFile();
            if (parent != null) {
                return parent.getName() + File.separatorChar + name;
            }
        }
        return name;
    }

    @Override
    public Node parseJava(@NonNull JavaContext context) {
        String code = context.getContents();
        if (code == null) {
            return null;
        }
        CompilationUnitDeclaration unit = this.getParsedUnit(context, code);
        try {
            EcjTreeConverter converter = new EcjTreeConverter();
            converter.visit(code, (ASTNode)unit);
            List nodes = converter.getAll();
            if (nodes != null) {
                for (Node node : nodes) {
                    if (!(node instanceof lombok.ast.CompilationUnit)) continue;
                    return node;
                }
            }
            return null;
        }
        catch (Throwable t) {
            this.mClient.log(t, "Failed converting ECJ parse tree to Lombok for file %1$s", context.file.getPath());
            return null;
        }
    }

    @Nullable
    private CompilationUnitDeclaration getParsedUnit(@NonNull JavaContext context, @NonNull String code) {
        CompilationUnitDeclaration unit;
        ICompilationUnit sourceUnit = null;
        if (this.mSourceUnits != null && this.mCompiled != null && (sourceUnit = this.mSourceUnits.get(context.file)) != null && (unit = this.mCompiled.get(sourceUnit)) != null) {
            return unit;
        }
        if (sourceUnit == null) {
            sourceUnit = new CompilationUnit(code.toCharArray(), context.file.getName(), "UTF-8");
        }
        try {
            CompilationResult compilationResult = new CompilationResult(sourceUnit, 0, 0, 0);
            return this.getParser().parse(sourceUnit, compilationResult);
        }
        catch (AbortCompilation e) {
            return null;
        }
    }

    @Override
    @NonNull
    public Location getLocation(@NonNull JavaContext context, @NonNull Node node) {
        Position position = node.getPosition();
        return Location.create(context.file, context.getContents(), position.getStart(), position.getEnd());
    }

    @Override
    @NonNull
    public Location.Handle createLocationHandle(@NonNull JavaContext context, @NonNull Node node) {
        return new LocationHandle(context.file, node);
    }

    @Override
    public void dispose(@NonNull JavaContext context, @NonNull Node compilationUnit) {
        ICompilationUnit sourceUnit;
        if (this.mSourceUnits != null && this.mCompiled != null && (sourceUnit = this.mSourceUnits.get(context.file)) != null) {
            this.mSourceUnits.remove(context.file);
            this.mCompiled.remove(sourceUnit);
        }
    }

    @Nullable
    private static Object getNativeNode(@NonNull Node node) {
        lombok.ast.TypeReference typeReference;
        VariableDeclaration declaration;
        VariableDefinition definition;
        Object nativeNode = node.getNativeNode();
        if (nativeNode != null) {
            return nativeNode;
        }
        Node parent = node.getParent();
        if (parent != null && (nativeNode = parent.getNativeNode()) != null) {
            return nativeNode;
        }
        if (node instanceof VariableDeclaration && (definition = (declaration = (VariableDeclaration)node).astDefinition()) != null && (typeReference = definition.astTypeReference()) != null) {
            return typeReference.getNativeNode();
        }
        return null;
    }

    @Override
    @Nullable
    public JavaParser.ResolvedNode resolve(@NonNull JavaContext context, @NonNull Node node) {
        Object nativeNode = EcjParser.getNativeNode(node);
        if (nativeNode == null) {
            return null;
        }
        if (nativeNode instanceof NameReference) {
            return EcjParser.resolve(((NameReference)nativeNode).binding);
        }
        if (nativeNode instanceof TypeReference) {
            return EcjParser.resolve(((TypeReference)nativeNode).resolvedType);
        }
        if (nativeNode instanceof MessageSend) {
            return EcjParser.resolve(((MessageSend)nativeNode).binding);
        }
        if (nativeNode instanceof AllocationExpression) {
            return EcjParser.resolve(((AllocationExpression)nativeNode).binding);
        }
        if (nativeNode instanceof TypeDeclaration) {
            return EcjParser.resolve(((TypeDeclaration)nativeNode).binding);
        }
        if (nativeNode instanceof ExplicitConstructorCall) {
            return EcjParser.resolve(((ExplicitConstructorCall)nativeNode).binding);
        }
        if (nativeNode instanceof Annotation) {
            return EcjParser.resolve(((Annotation)nativeNode).resolvedType);
        }
        if (nativeNode instanceof AbstractMethodDeclaration) {
            return EcjParser.resolve(((AbstractMethodDeclaration)nativeNode).binding);
        }
        return null;
    }

    private static JavaParser.ResolvedNode resolve(@Nullable Binding binding) {
        if (binding == null || binding instanceof ProblemBinding) {
            return null;
        }
        if (binding instanceof TypeBinding) {
            TypeBinding tb = (TypeBinding)binding;
            return new EcjResolvedClass(tb);
        }
        if (binding instanceof MethodBinding) {
            MethodBinding mb = (MethodBinding)binding;
            if (mb instanceof ProblemMethodBinding) {
                return null;
            }
            if (mb.declaringClass != null) {
                return new EcjResolvedMethod(mb);
            }
        } else if (binding instanceof LocalVariableBinding) {
            LocalVariableBinding lvb = (LocalVariableBinding)binding;
            if (lvb.type != null) {
                return new EcjResolvedVariable(lvb);
            }
        } else if (binding instanceof FieldBinding) {
            FieldBinding fb = (FieldBinding)binding;
            if (fb instanceof ProblemFieldBinding) {
                return null;
            }
            if (fb.type != null && fb.declaringClass != null) {
                return new EcjResolvedField(fb);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public JavaParser.TypeDescriptor getType(@NonNull JavaContext context, @NonNull Node node) {
        Object nativeNode = EcjParser.getNativeNode(node);
        if (nativeNode == null) {
            return null;
        }
        if (nativeNode instanceof MessageSend) {
            nativeNode = ((MessageSend)nativeNode).binding;
        } else if (nativeNode instanceof AllocationExpression) {
            nativeNode = ((AllocationExpression)nativeNode).resolvedType;
        } else if (nativeNode instanceof NameReference) {
            nativeNode = ((NameReference)nativeNode).resolvedType;
        } else if (nativeNode instanceof Expression) {
            if (nativeNode instanceof Literal) {
                if (nativeNode instanceof StringLiteral) {
                    return EcjParser.getTypeDescriptor("java.lang.String");
                }
                if (nativeNode instanceof NumberLiteral) {
                    if (nativeNode instanceof IntLiteral) {
                        return EcjParser.getTypeDescriptor("int");
                    }
                    if (nativeNode instanceof LongLiteral) {
                        return EcjParser.getTypeDescriptor("long");
                    }
                    if (nativeNode instanceof CharLiteral) {
                        return EcjParser.getTypeDescriptor("char");
                    }
                    if (nativeNode instanceof FloatLiteral) {
                        return EcjParser.getTypeDescriptor("float");
                    }
                    if (nativeNode instanceof DoubleLiteral) {
                        return EcjParser.getTypeDescriptor("double");
                    }
                } else if (nativeNode instanceof MagicLiteral) {
                    if (nativeNode instanceof TrueLiteral || nativeNode instanceof FalseLiteral) {
                        return EcjParser.getTypeDescriptor("boolean");
                    }
                    if (nativeNode instanceof NullLiteral) {
                        return EcjParser.getTypeDescriptor("null");
                    }
                }
            }
            nativeNode = ((Expression)nativeNode).resolvedType;
        } else if (nativeNode instanceof TypeDeclaration) {
            nativeNode = ((TypeDeclaration)nativeNode).binding;
        } else if (nativeNode instanceof AbstractMethodDeclaration) {
            nativeNode = ((AbstractMethodDeclaration)nativeNode).binding;
        }
        if (nativeNode instanceof Binding) {
            Binding binding = (Binding)nativeNode;
            if (binding instanceof TypeBinding) {
                TypeBinding tb = (TypeBinding)binding;
                return EcjParser.getTypeDescriptor(tb);
            }
            if (binding instanceof LocalVariableBinding) {
                LocalVariableBinding lvb = (LocalVariableBinding)binding;
                if (lvb.type != null) {
                    return EcjParser.getTypeDescriptor(lvb.type);
                }
            } else if (binding instanceof FieldBinding) {
                FieldBinding fb = (FieldBinding)binding;
                if (fb.type != null) {
                    return EcjParser.getTypeDescriptor(fb.type);
                }
            } else {
                if (binding instanceof MethodBinding) {
                    return EcjParser.getTypeDescriptor(((MethodBinding)binding).returnType);
                }
                if (binding instanceof ProblemBinding) {
                    return null;
                }
            }
        }
        return null;
    }

    @Nullable
    private static JavaParser.TypeDescriptor getTypeDescriptor(@Nullable TypeBinding resolvedType) {
        if (resolvedType == null) {
            return null;
        }
        return new EcjTypeDescriptor(resolvedType.readableName());
    }

    private static JavaParser.TypeDescriptor getTypeDescriptor(String fqn) {
        return new JavaParser.DefaultTypeDescriptor(fqn);
    }

    private static boolean sameChars(String str, char[] chars) {
        int length = str.length();
        if (chars.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (chars[i] == str.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static class EcjResolvedVariable
    extends JavaParser.ResolvedVariable {
        private LocalVariableBinding mBinding;

        private EcjResolvedVariable(LocalVariableBinding binding) {
            this.mBinding = binding;
        }

        @Override
        @NonNull
        public String getName() {
            return new String(this.mBinding.readableName());
        }

        @Override
        public boolean matches(@NonNull String name) {
            return EcjParser.sameChars(name, this.mBinding.readableName());
        }

        @Override
        @NonNull
        public JavaParser.TypeDescriptor getType() {
            JavaParser.TypeDescriptor typeDescriptor = EcjParser.getTypeDescriptor(this.mBinding.type);
            assert (typeDescriptor != null);
            return typeDescriptor;
        }

        @Override
        public int getModifiers() {
            return this.mBinding.modifiers;
        }

        @Override
        public String getSignature() {
            return this.mBinding.toString();
        }
    }

    private static class EcjResolvedField
    extends JavaParser.ResolvedField {
        private FieldBinding mBinding;

        private EcjResolvedField(FieldBinding binding) {
            this.mBinding = binding;
        }

        @Override
        @NonNull
        public String getName() {
            return new String(this.mBinding.readableName());
        }

        @Override
        public boolean matches(@NonNull String name) {
            return EcjParser.sameChars(name, this.mBinding.readableName());
        }

        @Override
        @NonNull
        public JavaParser.TypeDescriptor getType() {
            JavaParser.TypeDescriptor typeDescriptor = EcjParser.getTypeDescriptor(this.mBinding.type);
            assert (typeDescriptor != null);
            return typeDescriptor;
        }

        @Override
        @NonNull
        public JavaParser.ResolvedClass getContainingClass() {
            return new EcjResolvedClass(this.mBinding.declaringClass);
        }

        @Override
        @Nullable
        public Object getValue() {
            Constant constant = this.mBinding.constant();
            if (constant != null) {
                if (constant instanceof StringConstant) {
                    return constant.stringValue();
                }
                if (constant instanceof IntConstant) {
                    return constant.intValue();
                }
                if (constant instanceof BooleanConstant) {
                    return constant.booleanValue();
                }
                if (constant instanceof LongConstant) {
                    return constant.longValue();
                }
                if (constant instanceof DoubleConstant) {
                    return constant.doubleValue();
                }
                if (constant instanceof CharConstant) {
                    return Character.valueOf(constant.charValue());
                }
                if (constant instanceof FloatConstant) {
                    return Float.valueOf(constant.floatValue());
                }
                if (constant instanceof ShortConstant) {
                    return constant.shortValue();
                }
                if (constant instanceof ByteConstant) {
                    return constant.byteValue();
                }
            }
            return null;
        }

        @Override
        public int getModifiers() {
            return this.mBinding.getAccessFlags();
        }

        @Override
        public String getSignature() {
            return this.mBinding.toString();
        }
    }

    private static class EcjResolvedClass
    extends JavaParser.ResolvedClass {
        private TypeBinding mBinding;

        private EcjResolvedClass(TypeBinding binding) {
            this.mBinding = binding;
        }

        @Override
        @NonNull
        public String getName() {
            return new String(this.mBinding.readableName());
        }

        @Override
        public boolean matches(@NonNull String name) {
            return EcjParser.sameChars(name, this.mBinding.readableName());
        }

        @Override
        @Nullable
        public JavaParser.ResolvedClass getSuperClass() {
            ReferenceBinding refBinding;
            ReferenceBinding superClass;
            if (this.mBinding instanceof ReferenceBinding && (superClass = (refBinding = (ReferenceBinding)this.mBinding).superclass()) != null) {
                return new EcjResolvedClass(superClass);
            }
            return null;
        }

        @Override
        @Nullable
        public JavaParser.ResolvedClass getContainingClass() {
            if (this.mBinding instanceof NestedTypeBinding) {
                NestedTypeBinding ntb = (NestedTypeBinding)this.mBinding;
                if (ntb.enclosingType != null) {
                    return new EcjResolvedClass(ntb.enclosingType);
                }
            }
            return null;
        }

        @Override
        public boolean isSubclassOf(@NonNull String name, boolean strict) {
            if (this.mBinding instanceof ReferenceBinding) {
                ReferenceBinding cls = (ReferenceBinding)this.mBinding;
                if (strict) {
                    cls = cls.superclass();
                }
                while (cls != null) {
                    if (EcjParser.sameChars(name, cls.readableName())) {
                        return true;
                    }
                    cls = cls.superclass();
                }
            }
            return false;
        }

        @Override
        @NonNull
        public Iterable<JavaParser.ResolvedMethod> getConstructors() {
            ReferenceBinding cls;
            MethodBinding[] methods;
            if (this.mBinding instanceof ReferenceBinding && (methods = (cls = (ReferenceBinding)this.mBinding).getMethods(TypeConstants.INIT)) != null) {
                int count = methods.length;
                ArrayList result = Lists.newArrayListWithExpectedSize((int)count);
                for (MethodBinding method : methods) {
                    if (!method.isConstructor()) continue;
                    result.add(new EcjResolvedMethod(method));
                }
                return result;
            }
            return Collections.emptyList();
        }

        @Override
        @NonNull
        public Iterable<JavaParser.ResolvedMethod> getMethods(@NonNull String name) {
            ReferenceBinding cls;
            MethodBinding[] methods;
            if (this.mBinding instanceof ReferenceBinding && (methods = (cls = (ReferenceBinding)this.mBinding).getMethods(name.toCharArray())) != null) {
                int count = methods.length;
                ArrayList result = Lists.newArrayListWithExpectedSize((int)count);
                for (MethodBinding method : methods) {
                    if (method.isConstructor()) continue;
                    result.add(new EcjResolvedMethod(method));
                }
                return result;
            }
            return Collections.emptyList();
        }

        @Override
        @Nullable
        public JavaParser.ResolvedField getField(@NonNull String name) {
            ReferenceBinding cls;
            FieldBinding[] fields;
            if (this.mBinding instanceof ReferenceBinding && (fields = (cls = (ReferenceBinding)this.mBinding).fields()) != null) {
                for (FieldBinding field : fields) {
                    if (!EcjParser.sameChars(name, field.name)) continue;
                    return new EcjResolvedField(field);
                }
            }
            return null;
        }

        @Override
        public int getModifiers() {
            if (this.mBinding instanceof ReferenceBinding) {
                ReferenceBinding cls = (ReferenceBinding)this.mBinding;
                return cls.getAccessFlags();
            }
            return 0;
        }

        @Override
        public String getSignature() {
            return this.getName();
        }
    }

    private static class EcjResolvedMethod
    extends JavaParser.ResolvedMethod {
        private MethodBinding mBinding;

        private EcjResolvedMethod(MethodBinding binding) {
            this.mBinding = binding;
            assert (this.mBinding.declaringClass != null);
        }

        @Override
        @NonNull
        public String getName() {
            char[] c = this.isConstructor() ? this.mBinding.declaringClass.readableName() : this.mBinding.selector;
            return new String(c);
        }

        @Override
        public boolean matches(@NonNull String name) {
            char[] c = this.isConstructor() ? this.mBinding.declaringClass.readableName() : this.mBinding.selector;
            return EcjParser.sameChars(name, c);
        }

        @Override
        @NonNull
        public JavaParser.ResolvedClass getContainingClass() {
            return new EcjResolvedClass(this.mBinding.declaringClass);
        }

        @Override
        public int getArgumentCount() {
            return this.mBinding.parameters != null ? this.mBinding.parameters.length : 0;
        }

        @Override
        @NonNull
        public JavaParser.TypeDescriptor getArgumentType(int index) {
            TypeBinding parameterType = this.mBinding.parameters[index];
            JavaParser.TypeDescriptor typeDescriptor = EcjParser.getTypeDescriptor(parameterType);
            assert (typeDescriptor != null);
            return typeDescriptor;
        }

        @Override
        @Nullable
        public JavaParser.TypeDescriptor getReturnType() {
            return this.isConstructor() ? null : EcjParser.getTypeDescriptor(this.mBinding.returnType);
        }

        @Override
        public boolean isConstructor() {
            return this.mBinding.isConstructor();
        }

        @Override
        public int getModifiers() {
            return this.mBinding.getAccessFlags();
        }

        @Override
        public String getSignature() {
            return this.mBinding.toString();
        }
    }

    private static class EcjTypeDescriptor
    extends JavaParser.TypeDescriptor {
        private String mName;
        private char[] mChars;

        private EcjTypeDescriptor(char[] chars) {
            this.mChars = chars;
        }

        @Override
        @NonNull
        public String getName() {
            if (this.mName == null) {
                this.mName = new String(this.mChars);
            }
            return this.mName;
        }

        @Override
        @NonNull
        public String getSignature() {
            return this.getName();
        }

        @Override
        public boolean matchesName(@NonNull String name) {
            return EcjParser.sameChars(name, this.mChars);
        }

        @Override
        public boolean matchesSignature(@NonNull String signature) {
            return this.matchesName(signature);
        }

        public String toString() {
            return this.getSignature();
        }
    }

    private static class NonGeneratingCompiler
    extends Compiler {
        private Map<ICompilationUnit, CompilationUnitDeclaration> mUnits;
        private CompilationUnitDeclaration mCurrentUnit;

        public NonGeneratingCompiler(INameEnvironment environment, IErrorHandlingPolicy policy, CompilerOptions options, ICompilerRequestor requestor, IProblemFactory problemFactory, Map<ICompilationUnit, CompilationUnitDeclaration> units) {
            super(environment, policy, options, requestor, problemFactory, null, null);
            this.mUnits = units;
        }

        @Nullable
        CompilationUnitDeclaration getCurrentUnit() {
            return this.mCurrentUnit;
        }

        @Override
        protected synchronized void addCompilationUnit(ICompilationUnit sourceUnit, CompilationUnitDeclaration parsedUnit) {
            super.addCompilationUnit(sourceUnit, parsedUnit);
            this.mUnits.put(sourceUnit, parsedUnit);
        }

        @Override
        public void process(CompilationUnitDeclaration unit, int unitNumber) {
            this.mCurrentUnit = this.lookupEnvironment.unitBeingCompleted = unit;
            this.parser.getMethodBodies(unit);
            if (unit.scope != null) {
                unit.scope.faultInTypes();
                unit.scope.verifyMethods(this.lookupEnvironment.methodVerifier());
            }
            unit.resolve();
            unit.analyseCode();
            if (this.options.produceReferenceInfo && unit.scope != null) {
                unit.scope.storeDependencyInfo();
            }
            unit.finalizeProblems();
            unit.compilationResult.totalUnitsKnown = this.totalUnits;
            this.lookupEnvironment.unitBeingCompleted = null;
        }
    }

    private static class LocationHandle
    implements Location.Handle {
        private File mFile;
        private Node mNode;
        private Object mClientData;

        public LocationHandle(File file, Node node) {
            this.mFile = file;
            this.mNode = node;
        }

        @Override
        @NonNull
        public Location resolve() {
            Position pos = this.mNode.getPosition();
            return Location.create(this.mFile, null, pos.getStart(), pos.getEnd());
        }

        @Override
        public void setClientData(@Nullable Object clientData) {
            this.mClientData = clientData;
        }

        @Override
        @Nullable
        public Object getClientData() {
            return this.mClientData;
        }
    }
}

