/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.compiler;

import com.google.clearsilver.jsilver.compiler.JSilverCompilationException;
import com.google.clearsilver.jsilver.compiler.JavaSourceWriter;
import com.google.clearsilver.jsilver.compiler.TemplateTranslator;
import com.google.clearsilver.jsilver.data.TypeConverter;
import java.io.PrintWriter;
import java.io.StringWriter;

public abstract class JavaExpression {
    private final Type type;

    public JavaExpression(Type type) {
        this.type = type;
    }

    public JavaExpression cast(Type destType) {
        return this.type != destType ? destType.cast(this) : this;
    }

    public Type getType() {
        return this.type;
    }

    public abstract void write(PrintWriter var1);

    public String toString() {
        StringWriter out = new StringWriter();
        this.write(new PrintWriter(out));
        return out.toString();
    }

    public static JavaExpression call(String method, JavaExpression ... params) {
        return JavaExpression.call(null, method, params);
    }

    public static JavaExpression call(Type type, final String method, final JavaExpression ... params) {
        return new JavaExpression(type){

            public void write(PrintWriter out) {
                JavaSourceWriter.writeJavaSymbol(out, method);
                out.append('(');
                boolean seenAnyParams = false;
                for (JavaExpression param : params) {
                    if (seenAnyParams) {
                        out.append(", ");
                    } else {
                        seenAnyParams = true;
                    }
                    param.write(out);
                }
                out.append(')');
            }
        };
    }

    public static JavaExpression callOn(JavaExpression instance, String method, JavaExpression ... params) {
        return JavaExpression.callOn(Type.VOID, instance, method, params);
    }

    public static JavaExpression callOn(Type type, final JavaExpression instance, final String method, final JavaExpression ... params) {
        return new JavaExpression(type){

            public void write(PrintWriter out) {
                instance.write(out);
                out.append('.');
                2.call(method, params).write(out);
            }
        };
    }

    public static JavaExpression string(String value) {
        return new StringExpression(value);
    }

    public static JavaExpression integer(String value) {
        TypeConverter.parseNumber(value);
        return JavaExpression.literal(Type.INT, value);
    }

    public static JavaExpression integer(int value) {
        return JavaExpression.literal(Type.INT, String.valueOf(value));
    }

    public static JavaExpression bool(boolean value) {
        return JavaExpression.literal(Type.BOOLEAN, value ? "true" : "false");
    }

    public static JavaExpression symbol(final String value) {
        return new JavaExpression(Type.UNKNOWN){

            public void write(PrintWriter out) {
                JavaSourceWriter.writeJavaSymbol(out, value);
            }
        };
    }

    public static JavaExpression symbol(Type type, final String value) {
        return new JavaExpression(type){

            public void write(PrintWriter out) {
                JavaSourceWriter.writeJavaSymbol(out, value);
            }
        };
    }

    public static JavaExpression macro(String value) {
        return JavaExpression.symbol(Type.MACRO, value);
    }

    public static JavaExpression assign(Type type, final String name, final JavaExpression value) {
        return new JavaExpression(type){

            public void write(PrintWriter out) {
                JavaSourceWriter.writeJavaSymbol(out, name);
                out.append(" = ");
                value.write(out);
            }
        };
    }

    public static JavaExpression declare(final Type type, final String name, final JavaExpression value) {
        return new JavaExpression(type){

            public void write(PrintWriter out) {
                JavaSourceWriter.writeJavaSymbol(out, type.symbol);
                out.append(' ');
                6.assign(type, name, value).write(out);
            }
        };
    }

    public static JavaExpression infix(Type type, final String operator, final JavaExpression left, final JavaExpression right) {
        return new JavaExpression(type){

            public void write(PrintWriter out) {
                out.append("(");
                left.write(out);
                out.append(" ").append(operator).append(" ");
                right.write(out);
                out.append(")");
            }
        };
    }

    public static JavaExpression prefix(Type type, final String operator, final JavaExpression expression) {
        return new JavaExpression(type){

            public void write(PrintWriter out) {
                out.append("(").append(operator);
                expression.write(out);
                out.append(")");
            }
        };
    }

    public static JavaExpression inlineIf(Type type, final JavaExpression query, final JavaExpression trueExp, final JavaExpression falseExp) {
        if (query.getType() != Type.BOOLEAN) {
            throw new IllegalArgumentException("Expect BOOLEAN expression");
        }
        return new JavaExpression(type){

            public void write(PrintWriter out) {
                out.append("(");
                query.write(out);
                out.append(" ? ");
                trueExp.write(out);
                out.append(" : ");
                falseExp.write(out);
                out.append(")");
            }
        };
    }

    public static JavaExpression increment(Type type, final JavaExpression accumulator, final JavaExpression incr) {
        return new JavaExpression(type){

            public void write(PrintWriter out) {
                accumulator.write(out);
                out.append(" += ");
                incr.write(out);
            }
        };
    }

    public static JavaExpression literal(Type type, final String value) {
        return new JavaExpression(type){

            public void write(PrintWriter out) {
                out.append(value);
            }
        };
    }

    public static JavaExpression callFindVariable(JavaExpression expression, boolean create) {
        if (expression.getType() != Type.VAR_NAME) {
            throw new IllegalArgumentException("Expect VAR_NAME expression");
        }
        return JavaExpression.callOn(Type.DATA, TemplateTranslator.DATA_CONTEXT, "findVariable", expression, JavaExpression.bool(create));
    }

    public static class BooleanLiteralExpression
    extends JavaExpression {
        private final boolean value;
        public static final BooleanLiteralExpression FALSE = new BooleanLiteralExpression(false);
        public static final BooleanLiteralExpression TRUE = new BooleanLiteralExpression(true);

        private BooleanLiteralExpression(boolean value) {
            super(Type.BOOLEAN);
            this.value = value;
        }

        public boolean getValue() {
            return this.value;
        }

        public void write(PrintWriter out) {
            out.append(String.valueOf(this.value));
        }
    }

    public static class StringExpression
    extends JavaExpression {
        private final String value;

        public StringExpression(String value) {
            super(Type.STRING);
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void write(PrintWriter out) {
            char[] chars;
            out.append('\"');
            block9: for (char c : chars = this.value.toCharArray()) {
                switch (c) {
                    case '\n': {
                        out.append("\\n");
                        continue block9;
                    }
                    case '\r': {
                        out.append("\\r");
                        continue block9;
                    }
                    case '\t': {
                        out.append("\\t");
                        continue block9;
                    }
                    case '\\': {
                        out.append("\\\\");
                        continue block9;
                    }
                    case '\"': {
                        out.append("\\\"");
                        continue block9;
                    }
                    case '\b': {
                        out.append("\\b");
                        continue block9;
                    }
                    case '\f': {
                        out.append("\\f");
                        continue block9;
                    }
                    default: {
                        out.append(c);
                    }
                }
            }
            out.append('\"');
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        STRING("String"){

            protected JavaExpression cast(JavaExpression expression) {
                if (expression.getType() == VAR_NAME) {
                    expression = expression.cast(DATA);
                }
                return JavaExpression.call(STRING, "asString", expression);
            }
        }
        ,
        INT("int"){

            protected JavaExpression cast(JavaExpression expression) {
                if (expression.getType() == VAR_NAME) {
                    expression = expression.cast(DATA);
                }
                return JavaExpression.call(INT, "asInt", expression);
            }
        }
        ,
        BOOLEAN("boolean"){

            protected JavaExpression cast(JavaExpression expression) {
                if (expression.getType() == VAR_NAME) {
                    expression = expression.cast(DATA);
                }
                return JavaExpression.call(BOOLEAN, "asBoolean", expression);
            }
        }
        ,
        VALUE("Value"){

            protected JavaExpression cast(JavaExpression expression) {
                if (expression.getType() == VAR_NAME) {
                    return JavaExpression.call(VALUE, "asVariableValue", expression, TemplateTranslator.DATA_CONTEXT);
                }
                return JavaExpression.call(VALUE, "asValue", expression);
            }
        }
        ,
        DATA("Data"){

            protected JavaExpression cast(JavaExpression expression) {
                if (expression.getType() == VAR_NAME) {
                    return JavaExpression.callFindVariable(expression, false);
                }
                throw new JSilverCompilationException("Cannot cast to 'Data' for expression:\n" + expression.toString());
            }
        }
        ,
        VAR_NAME("String"){

            protected JavaExpression cast(JavaExpression expression) {
                final JavaExpression stringExpr = expression.cast(STRING);
                return new JavaExpression(VAR_NAME){

                    public void write(PrintWriter out) {
                        stringExpr.write(out);
                    }
                };
            }
        }
        ,
        DATA_CONTEXT("DataContext"){

            protected JavaExpression cast(JavaExpression expression) {
                throw new JSilverCompilationException("Cannot cast to 'DataContext' for expression:\n" + expression.toString());
            }
        }
        ,
        MACRO("Macro"){

            protected JavaExpression cast(JavaExpression expression) {
                throw new JSilverCompilationException("Cannot cast to 'Macro' for expression:\n" + expression.toString());
            }
        }
        ,
        VOID("Void"){

            protected JavaExpression cast(final JavaExpression expression) {
                return new JavaExpression(VOID){

                    public void write(PrintWriter out) {
                        expression.write(out);
                    }
                };
            }
        };

        public static final Type UNKNOWN;
        public final String symbol;

        protected abstract JavaExpression cast(JavaExpression var1);

        private Type(String symbol) {
            this.symbol = symbol;
        }

        static {
            UNKNOWN = null;
        }
    }
}

