/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.impl.dom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.ui.css.core.dom.CSSProperty;
import org.eclipse.e4.ui.css.core.dom.CSSPropertyList;
import org.eclipse.e4.ui.css.core.exceptions.DOMExceptionImpl;
import org.eclipse.e4.ui.css.core.impl.dom.AbstractCSSNode;
import org.eclipse.e4.ui.css.core.impl.dom.CSSPropertyImpl;
import org.eclipse.e4.ui.css.core.impl.dom.CSSPropertyListImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSStyleDeclarationImpl
extends AbstractCSSNode
implements CSSStyleDeclaration,
Serializable {
    private boolean readOnly;
    private CSSRule parentRule;
    private List<CSSProperty> properties = new ArrayList<CSSProperty>();

    public CSSStyleDeclarationImpl(CSSRule parentRule) {
        this.parentRule = parentRule;
    }

    public String getCssText() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.properties.size()) {
            CSSProperty property = this.properties.get(i);
            sb.append(property.getName()).append(": ");
            sb.append(property.getValue().getCssText());
            sb.append(";");
            if (i < this.properties.size() - 1) {
                sb.append("\n");
            }
            ++i;
        }
        return sb.toString();
    }

    public int getLength() {
        return this.properties.size();
    }

    public CSSRule getParentRule() {
        return this.parentRule;
    }

    public CSSValue getPropertyCSSValue(String propertyName) {
        CSSProperty property = this.findCSSProperty(propertyName);
        return property == null ? null : property.getValue();
    }

    public String getPropertyPriority(String propertyName) {
        CSSProperty property = this.findCSSProperty(propertyName);
        return property != null && property.isImportant() ? CSSPropertyImpl.IMPORTANT_IDENTIFIER : "";
    }

    public String getPropertyValue(String propertyName) {
        CSSProperty property = this.findCSSProperty(propertyName);
        return property == null ? "" : property.getValue().toString();
    }

    public String item(int index) {
        return this.properties.get(index).getName();
    }

    public String removeProperty(String propertyName) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, 20);
        }
        int i = 0;
        while (i < this.properties.size()) {
            CSSProperty property = this.properties.get(i);
            if (CSSPropertyImpl.sameName(property, propertyName)) {
                this.properties.remove(i);
                return property.getValue().toString();
            }
            ++i;
        }
        return "";
    }

    public void setCssText(String cssText) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, 20);
        }
        throw new UnsupportedOperationException("NOT YET IMPLEMENTED");
    }

    public void setProperty(String propertyName, String value, String priority) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, 20);
        }
        throw new UnsupportedOperationException("NOT YET IMPLEMENTED");
    }

    public void addProperty(CSSProperty property) {
        this.properties.add(property);
    }

    public CSSPropertyList getCSSPropertyList() {
        CSSPropertyListImpl propertyList = new CSSPropertyListImpl();
        for (CSSProperty property : this.properties) {
            propertyList.add(property);
        }
        return propertyList;
    }

    protected void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    private CSSProperty findCSSProperty(String propertyName) {
        for (CSSProperty property : this.properties) {
            if (!CSSPropertyImpl.sameName(property, propertyName)) continue;
            return property;
        }
        return null;
    }
}

