/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.ui;

import com.android.hierarchyviewerlib.HierarchyViewerDirector;
import com.android.hierarchyviewerlib.models.TreeViewModel;
import com.android.hierarchyviewerlib.ui.util.DrawableViewNode;
import java.util.ArrayList;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class LayoutViewer
extends Canvas
implements TreeViewModel.ITreeChangeListener {
    private TreeViewModel mModel;
    private DrawableViewNode mTree;
    private DrawableViewNode mSelectedNode;
    private Transform mTransform;
    private Transform mInverse;
    private double mScale;
    private boolean mShowExtras = false;
    private boolean mOnBlack = true;
    private DisposeListener mDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            LayoutViewer.this.mModel.removeTreeChangeListener(LayoutViewer.this);
            LayoutViewer.this.mTransform.dispose();
            LayoutViewer.this.mInverse.dispose();
            if (LayoutViewer.this.mSelectedNode != null) {
                ((LayoutViewer)LayoutViewer.this).mSelectedNode.viewNode.dereferenceImage();
            }
        }
    };
    private Listener mResizeListener = new Listener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(Event e) {
            2 var2_2 = this;
            synchronized (var2_2) {
                LayoutViewer.this.setTransform();
            }
        }
    };
    private MouseListener mMouseListener = new MouseListener(){

        public void mouseDoubleClick(MouseEvent e) {
            if (LayoutViewer.this.mSelectedNode != null) {
                HierarchyViewerDirector.getDirector().showCapture(LayoutViewer.this.getShell(), ((LayoutViewer)LayoutViewer.this).mSelectedNode.viewNode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseDown(MouseEvent e) {
            boolean selectionChanged = false;
            DrawableViewNode newSelection = null;
            LayoutViewer layoutViewer = LayoutViewer.this;
            synchronized (layoutViewer) {
                if (LayoutViewer.this.mTree != null) {
                    float[] pt = new float[]{e.x, e.y};
                    LayoutViewer.this.mInverse.transform(pt);
                    newSelection = LayoutViewer.this.updateSelection(LayoutViewer.this.mTree, pt[0], pt[1], 0, 0, 0, 0, ((LayoutViewer)LayoutViewer.this).mTree.viewNode.width, ((LayoutViewer)LayoutViewer.this).mTree.viewNode.height);
                    if (LayoutViewer.this.mSelectedNode != newSelection) {
                        selectionChanged = true;
                    }
                }
            }
            if (selectionChanged) {
                LayoutViewer.this.mModel.setSelection(newSelection);
            }
        }

        public void mouseUp(MouseEvent e) {
        }
    };
    private PaintListener mPaintListener = new PaintListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintControl(PaintEvent e) {
            LayoutViewer layoutViewer = LayoutViewer.this;
            synchronized (layoutViewer) {
                if (LayoutViewer.this.mOnBlack) {
                    e.gc.setBackground(Display.getDefault().getSystemColor(2));
                } else {
                    e.gc.setBackground(Display.getDefault().getSystemColor(1));
                }
                e.gc.fillRectangle(0, 0, LayoutViewer.this.getBounds().width, LayoutViewer.this.getBounds().height);
                if (LayoutViewer.this.mTree != null) {
                    e.gc.setLineWidth((int)Math.ceil(0.3 / LayoutViewer.this.mScale));
                    e.gc.setTransform(LayoutViewer.this.mTransform);
                    if (LayoutViewer.this.mOnBlack) {
                        e.gc.setForeground(Display.getDefault().getSystemColor(1));
                    } else {
                        e.gc.setForeground(Display.getDefault().getSystemColor(2));
                    }
                    Rectangle parentClipping = e.gc.getClipping();
                    e.gc.setClipping(0, 0, ((LayoutViewer)LayoutViewer.this).mTree.viewNode.width + (int)Math.ceil(0.3 / LayoutViewer.this.mScale), ((LayoutViewer)LayoutViewer.this).mTree.viewNode.height + (int)Math.ceil(0.3 / LayoutViewer.this.mScale));
                    LayoutViewer.this.paintRecursive(e.gc, LayoutViewer.this.mTree, 0, 0, true);
                    if (LayoutViewer.this.mSelectedNode != null) {
                        e.gc.setClipping(parentClipping);
                        ArrayList<DrawableViewNode.Point> rightLeftDistances = new ArrayList<DrawableViewNode.Point>();
                        int left = 0;
                        int top = 0;
                        DrawableViewNode currentNode = LayoutViewer.this.mSelectedNode;
                        while (currentNode != LayoutViewer.this.mTree) {
                            left += currentNode.viewNode.left;
                            top += currentNode.viewNode.top;
                            currentNode = currentNode.parent;
                            rightLeftDistances.add(new DrawableViewNode.Point(left -= currentNode.viewNode.scrollX, top -= currentNode.viewNode.scrollY));
                        }
                        e.gc.setForeground(Display.getDefault().getSystemColor(4));
                        currentNode = ((LayoutViewer)LayoutViewer.this).mSelectedNode.parent;
                        int N = rightLeftDistances.size();
                        for (int i = 0; i < N; ++i) {
                            e.gc.drawRectangle((int)((double)left - ((DrawableViewNode.Point)rightLeftDistances.get((int)i)).x), (int)((double)top - ((DrawableViewNode.Point)rightLeftDistances.get((int)i)).y), currentNode.viewNode.width, currentNode.viewNode.height);
                            currentNode = currentNode.parent;
                        }
                        if (LayoutViewer.this.mShowExtras && ((LayoutViewer)LayoutViewer.this).mSelectedNode.viewNode.image != null) {
                            e.gc.drawImage(((LayoutViewer)LayoutViewer.this).mSelectedNode.viewNode.image, left, top);
                            if (LayoutViewer.this.mOnBlack) {
                                e.gc.setForeground(Display.getDefault().getSystemColor(1));
                            } else {
                                e.gc.setForeground(Display.getDefault().getSystemColor(2));
                            }
                            LayoutViewer.this.paintRecursive(e.gc, LayoutViewer.this.mSelectedNode, left, top, true);
                        }
                        e.gc.setForeground(Display.getDefault().getSystemColor(3));
                        e.gc.setLineWidth((int)Math.ceil(2.0 / LayoutViewer.this.mScale));
                        e.gc.drawRectangle(left, top, ((LayoutViewer)LayoutViewer.this).mSelectedNode.viewNode.width, ((LayoutViewer)LayoutViewer.this).mSelectedNode.viewNode.height);
                    }
                }
            }
        }
    };

    public LayoutViewer(Composite parent) {
        super(parent, 0);
        this.mModel = TreeViewModel.getModel();
        this.mModel.addTreeChangeListener(this);
        this.addDisposeListener(this.mDisposeListener);
        this.addPaintListener(this.mPaintListener);
        this.addListener(11, this.mResizeListener);
        this.addMouseListener(this.mMouseListener);
        this.mTransform = new Transform((Device)Display.getDefault());
        this.mInverse = new Transform((Device)Display.getDefault());
        this.treeChanged();
    }

    public void setShowExtras(boolean show) {
        this.mShowExtras = show;
        this.doRedraw();
    }

    public void setOnBlack(boolean value) {
        this.mOnBlack = value;
        this.doRedraw();
    }

    public boolean getOnBlack() {
        return this.mOnBlack;
    }

    private DrawableViewNode updateSelection(DrawableViewNode node, float x, float y, int left, int top, int clipX, int clipY, int clipWidth, int clipHeight) {
        if (!node.treeDrawn) {
            return null;
        }
        int x1 = Math.max(left, clipX);
        int x2 = Math.min(left + node.viewNode.width, clipX + clipWidth);
        int y1 = Math.max(top, clipY);
        int y2 = Math.min(top + node.viewNode.height, clipY + clipHeight);
        clipX = x1;
        clipY = y1;
        clipWidth = x2 - x1;
        clipHeight = y2 - y1;
        if (x < (float)clipX || x > (float)(clipX + clipWidth) || y < (float)clipY || y > (float)(clipY + clipHeight)) {
            return null;
        }
        int N = node.children.size();
        for (int i = N - 1; i >= 0; --i) {
            DrawableViewNode child = node.children.get(i);
            DrawableViewNode ret = this.updateSelection(child, x, y, left + child.viewNode.left - node.viewNode.scrollX, top + child.viewNode.top - node.viewNode.scrollY, clipX, clipY, clipWidth, clipHeight);
            if (ret == null) continue;
            return ret;
        }
        return node;
    }

    private void paintRecursive(GC gc, DrawableViewNode node, int left, int top, boolean root) {
        if (!node.treeDrawn) {
            return;
        }
        if (!root) {
            left += node.viewNode.left;
            top += node.viewNode.top;
        }
        Rectangle parentClipping = gc.getClipping();
        int x1 = Math.max(parentClipping.x, left);
        int x2 = Math.min(parentClipping.x + parentClipping.width, left + node.viewNode.width + (int)Math.ceil(0.3 / this.mScale));
        int y1 = Math.max(parentClipping.y, top);
        int y2 = Math.min(parentClipping.y + parentClipping.height, top + node.viewNode.height + (int)Math.ceil(0.3 / this.mScale));
        if (x2 <= x1 || y2 <= y1) {
            return;
        }
        gc.setClipping(x1, y1, x2 - x1, y2 - y1);
        int N = node.children.size();
        for (int i = 0; i < N; ++i) {
            this.paintRecursive(gc, node.children.get(i), left - node.viewNode.scrollX, top - node.viewNode.scrollY, false);
        }
        gc.setClipping(parentClipping);
        if (!node.viewNode.willNotDraw) {
            gc.drawRectangle(left, top, node.viewNode.width, node.viewNode.height);
        }
    }

    private void doRedraw() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                LayoutViewer.this.redraw();
            }
        });
    }

    private void setTransform() {
        if (this.mTree != null) {
            Rectangle bounds = this.getBounds();
            int leftRightPadding = bounds.width <= 30 ? 0 : 5;
            int topBottomPadding = bounds.height <= 30 ? 0 : 5;
            this.mScale = Math.min(1.0 * (double)(bounds.width - leftRightPadding * 2) / (double)this.mTree.viewNode.width, 1.0 * (double)(bounds.height - topBottomPadding * 2) / (double)this.mTree.viewNode.height);
            int scaledWidth = (int)Math.ceil((double)this.mTree.viewNode.width * this.mScale);
            int scaledHeight = (int)Math.ceil((double)this.mTree.viewNode.height * this.mScale);
            this.mTransform.identity();
            this.mInverse.identity();
            this.mTransform.translate((float)(bounds.width - scaledWidth) / 2.0f, (float)(bounds.height - scaledHeight) / 2.0f);
            this.mInverse.translate((float)(bounds.width - scaledWidth) / 2.0f, (float)(bounds.height - scaledHeight) / 2.0f);
            this.mTransform.scale((float)this.mScale, (float)this.mScale);
            this.mInverse.scale((float)this.mScale, (float)this.mScale);
            if (bounds.width != 0 && bounds.height != 0) {
                this.mInverse.invert();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectionChanged() {
        LayoutViewer layoutViewer = this;
        synchronized (layoutViewer) {
            if (this.mSelectedNode != null) {
                this.mSelectedNode.viewNode.dereferenceImage();
            }
            this.mSelectedNode = this.mModel.getSelection();
            if (this.mSelectedNode != null) {
                this.mSelectedNode.viewNode.referenceImage();
            }
        }
        this.doRedraw();
    }

    @Override
    public void treeChanged() {
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                6 var1_1 = this;
                synchronized (var1_1) {
                    if (LayoutViewer.this.mSelectedNode != null) {
                        ((LayoutViewer)LayoutViewer.this).mSelectedNode.viewNode.dereferenceImage();
                    }
                    LayoutViewer.this.mTree = LayoutViewer.this.mModel.getTree();
                    LayoutViewer.this.mSelectedNode = LayoutViewer.this.mModel.getSelection();
                    if (LayoutViewer.this.mSelectedNode != null) {
                        ((LayoutViewer)LayoutViewer.this).mSelectedNode.viewNode.referenceImage();
                    }
                    LayoutViewer.this.setTransform();
                }
            }
        });
        this.doRedraw();
    }

    @Override
    public void viewportChanged() {
    }

    @Override
    public void zoomChanged() {
    }
}

