/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.annotations.NonNull;
import com.android.annotations.concurrency.Immutable;
import com.android.manifmerger.KeyResolver;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlElement;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

@Immutable
public class Selector {
    public static final String SELECTOR_LOCAL_NAME = "selector";
    @NonNull
    private final String mPackageName;

    public Selector(@NonNull String packageName) {
        this.mPackageName = Preconditions.checkNotNull(packageName);
    }

    boolean appliesTo(XmlElement element) {
        Optional<XmlAttribute> packageName = element.getDocument().getPackage();
        return packageName.isPresent() && this.mPackageName.equals(packageName.get().getValue());
    }

    boolean isResolvable(KeyResolver<String> resolver) {
        return resolver.resolve(this.mPackageName) != null;
    }

    public String toString() {
        return this.mPackageName;
    }
}

