/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.internal.project.ProjectPropertiesWorkingCopy;
import com.android.sdklib.repository.FullRevision;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.DeweyDecimal;

final class TaskHelper {
    private static Map<String, String> DEFAULT_ATTR_VALUES = new HashMap<String, String>();

    TaskHelper() {
    }

    static String getDefault(String name) {
        return DEFAULT_ATTR_VALUES.get(name);
    }

    static File getSdkLocation(Project antProject) {
        String sdkOsPath = antProject.getProperty("sdk.dir");
        if (sdkOsPath == null || sdkOsPath.length() == 0) {
            throw new BuildException("SDK Location is not set.");
        }
        File sdk = new File(sdkOsPath);
        if (!sdk.isDirectory()) {
            throw new BuildException(String.format("SDK Location '%s' is not valid.", sdkOsPath));
        }
        return sdk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static DeweyDecimal getToolsRevision(File sdkFile) {
        Properties p = new Properties();
        try {
            File toolsFolder = new File(sdkFile, "tools");
            File sourceProp = new File(toolsFolder, "source.properties");
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(sourceProp);
                p.load(fis);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ignore) {}
                }
            }
            String value = p.getProperty("Pkg.Revision");
            if (value != null) {
                FullRevision rev = FullRevision.parseRevision(value);
                return new DeweyDecimal(rev.toIntArray(false));
            }
        }
        catch (NumberFormatException e) {
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    static String checkSinglePath(String attribute, Path path) {
        String[] paths = path.list();
        if (paths.length != 1) {
            throw new BuildException(String.format("Value for '%1$s' is not valid. It must resolve to a single path", attribute));
        }
        return paths[0];
    }

    @NonNull
    static ProjectProperties getProperties(@NonNull String projectPath) {
        ProjectProperties.PropertyType[] types = ProjectProperties.PropertyType.getOrderedTypes();
        ProjectProperties properties = null;
        for (int i = 0; i < types.length; ++i) {
            properties = ProjectProperties.load(projectPath, types[i]);
            if (properties == null) continue;
            ProjectPropertiesWorkingCopy workingCopy = properties.makeWorkingCopy();
            for (int k = i + 1; k < types.length; ++k) {
                workingCopy.merge(types[k]);
            }
            properties = workingCopy.makeReadOnlyCopy();
            return properties;
        }
        return ProjectProperties.createEmpty(projectPath, ProjectProperties.PropertyType.PROJECT);
    }

    static {
        DEFAULT_ATTR_VALUES.put("source.dir", "src");
        DEFAULT_ATTR_VALUES.put("out.dir", "bin");
    }
}

