/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.local;

import com.android.annotations.NonNull;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.UpdateResult;
import com.android.sdklib.repository.remote.RemotePkgInfo;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.TreeSet;

public abstract class Update {
    public static UpdateResult computeUpdates(@NonNull LocalPkgInfo[] localPkgs, @NonNull Multimap<PkgType, RemotePkgInfo> remotePkgs) {
        UpdateResult result = new UpdateResult();
        TreeSet updates = Sets.newTreeSet();
        for (LocalPkgInfo local : localPkgs) {
            RemotePkgInfo update = Update.findUpdate(local, remotePkgs, result);
            if (update == null) continue;
            updates.add(update);
        }
        block1: for (RemotePkgInfo remote : remotePkgs.values()) {
            if (updates.contains(remote)) continue;
            IPkgDesc remoteDesc = remote.getDesc();
            for (LocalPkgInfo local : localPkgs) {
                IPkgDesc localDesc = local.getDesc();
                if (remoteDesc.compareTo(localDesc) == 0 || remoteDesc.isUpdateFor(localDesc)) continue block1;
            }
            result.addNewPkgs(remote);
        }
        return result;
    }

    private static RemotePkgInfo findUpdate(@NonNull LocalPkgInfo local, @NonNull Multimap<PkgType, RemotePkgInfo> remotePkgs, @NonNull UpdateResult result) {
        RemotePkgInfo currUpdatePkg = null;
        IPkgDesc currUpdateDesc = null;
        IPkgDesc localDesc = local.getDesc();
        for (RemotePkgInfo remote : remotePkgs.get((Object)localDesc.getType())) {
            IPkgDesc remoteDesc = remote.getDesc();
            if ((currUpdateDesc != null || !remoteDesc.isUpdateFor(localDesc)) && (currUpdateDesc == null || !remoteDesc.isUpdateFor(currUpdateDesc))) continue;
            currUpdatePkg = remote;
            currUpdateDesc = remoteDesc;
        }
        local.setUpdate(currUpdatePkg);
        if (currUpdatePkg != null) {
            result.addUpdatedPkgs(local);
        }
        return currUpdatePkg;
    }
}

