/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.build;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.build.FileGatherer;
import com.android.sdklib.build.SourceSearcher;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RenderScriptProcessor {
    private static final Abi[] ABIS = new Abi[]{new Abi("armeabi-v7a", "armv7-none-linux-gnueabi", BuildToolInfo.PathId.LD_ARM, "-dynamic-linker", "/system/bin/linker", "-X", "-m", "armelf_linux_eabi"), new Abi("mips", "mipsel-unknown-linux", BuildToolInfo.PathId.LD_MIPS, "-EL"), new Abi("x86", "i686-unknown-linux", BuildToolInfo.PathId.LD_X86, "-m", "elf_i386")};
    public static final String RS_DEPS = "rsDeps";
    @NonNull
    private final List<File> mInputs;
    @NonNull
    private final List<File> mImportFolders;
    @NonNull
    private final File mBuildFolder;
    @NonNull
    private final File mSourceOutputDir;
    @NonNull
    private final File mResOutputDir;
    @NonNull
    private final File mObjOutputDir;
    @NonNull
    private final File mLibOutputDir;
    @NonNull
    private final BuildToolInfo mBuildToolInfo;
    private final int mTargetApi;
    private final boolean mDebugBuild;
    private final int mOptimLevel;
    private final boolean mSupportMode;
    private final File mRsLib;
    private final Map<String, File> mLibClCore = Maps.newHashMap();

    public RenderScriptProcessor(@NonNull List<File> inputs, @NonNull List<File> importFolders, @NonNull File buildFolder, @NonNull File sourceOutputDir, @NonNull File resOutputDir, @NonNull File objOutputDir, @NonNull File libOutputDir, @NonNull BuildToolInfo buildToolInfo, int targetApi, boolean debugBuild, int optimLevel, boolean supportMode) {
        this.mInputs = inputs;
        this.mImportFolders = importFolders;
        this.mBuildFolder = buildFolder;
        this.mSourceOutputDir = sourceOutputDir;
        this.mResOutputDir = resOutputDir;
        this.mObjOutputDir = objOutputDir;
        this.mLibOutputDir = libOutputDir;
        this.mBuildToolInfo = buildToolInfo;
        this.mTargetApi = targetApi;
        this.mDebugBuild = debugBuild;
        this.mOptimLevel = optimLevel;
        this.mSupportMode = supportMode;
        if (supportMode) {
            File rs = new File(this.mBuildToolInfo.getLocation(), "renderscript");
            this.mRsLib = new File(rs, "lib");
            File bcFolder = new File(this.mRsLib, "bc");
            for (Abi abi : ABIS) {
                this.mLibClCore.put(abi.mDevice, new File(bcFolder, abi.mDevice + File.separatorChar + "libclcore.bc"));
            }
        } else {
            this.mRsLib = null;
        }
    }

    public void cleanOldOutput(@Nullable Collection<File> oldOutputs) {
        if (oldOutputs != null) {
            for (File file : oldOutputs) {
                file.delete();
            }
        }
        RenderScriptProcessor.deleteFolder(this.mObjOutputDir);
        RenderScriptProcessor.deleteFolder(this.mLibOutputDir);
    }

    public static File getSupportJar(String buildToolsFolder) {
        return new File(buildToolsFolder, "renderscript/lib/renderscript-v8.jar");
    }

    public static File getSupportNativeLibFolder(String buildToolsFolder) {
        File rs = new File(buildToolsFolder, "renderscript");
        File lib = new File(rs, "lib");
        return new File(lib, "packaged");
    }

    public void build(@NonNull CommandLineLauncher launcher) throws IOException, InterruptedException {
        HashMap env = Maps.newHashMap();
        if (SdkConstants.CURRENT_PLATFORM == 3) {
            env.put("DYLD_LIBRARY_PATH", this.mBuildToolInfo.getLocation().getAbsolutePath());
        } else if (SdkConstants.CURRENT_PLATFORM == 1) {
            env.put("LD_LIBRARY_PATH", this.mBuildToolInfo.getLocation().getAbsolutePath());
        }
        this.doMainCompilation(launcher, env);
        if (this.mSupportMode) {
            this.createSupportFiles(launcher, env);
        }
    }

    private void doMainCompilation(@NonNull CommandLineLauncher launcher, @NonNull Map<String, String> env) throws IOException, InterruptedException {
        if (this.mInputs.isEmpty()) {
            return;
        }
        String renderscript = this.mBuildToolInfo.getPath(BuildToolInfo.PathId.LLVM_RS_CC);
        if (renderscript == null || !new File(renderscript).isFile()) {
            throw new IllegalStateException((Object)((Object)BuildToolInfo.PathId.LLVM_RS_CC) + " is missing");
        }
        String rsPath = this.mBuildToolInfo.getPath(BuildToolInfo.PathId.ANDROID_RS);
        String rsClangPath = this.mBuildToolInfo.getPath(BuildToolInfo.PathId.ANDROID_RS_CLANG);
        File rawFolder = new File(this.mResOutputDir, "raw");
        ArrayList command = Lists.newArrayListWithExpectedSize((int)25);
        command.add("-O");
        command.add(Integer.toString(this.mOptimLevel));
        command.add("-I");
        command.add(rsPath);
        command.add("-I");
        command.add(rsClangPath);
        for (File importPath : this.mImportFolders) {
            if (!importPath.isDirectory()) continue;
            command.add("-I");
            command.add(importPath.getAbsolutePath());
        }
        command.add("-d");
        command.add(new File(this.mBuildFolder, RS_DEPS).getAbsolutePath());
        command.add("-MD");
        if (this.mSupportMode) {
            command.add("-rs-package-name=android.support.v8.renderscript");
        }
        command.add("-p");
        command.add(this.mSourceOutputDir.getAbsolutePath());
        command.add("-o");
        command.add(rawFolder.getAbsolutePath());
        command.add("-target-api");
        int targetApi = this.mTargetApi < 11 ? 11 : this.mTargetApi;
        targetApi = this.mSupportMode && targetApi < 18 ? 18 : targetApi;
        command.add(Integer.toString(targetApi));
        for (File sourceFile : this.mInputs) {
            command.add(sourceFile.getAbsolutePath());
        }
        launcher.launch(new File(renderscript), command, env);
    }

    private void createSupportFiles(@NonNull CommandLineLauncher launcher, @NonNull Map<String, String> env) throws IOException, InterruptedException {
        File rawFolder = new File(this.mResOutputDir, "raw");
        SourceSearcher searcher = new SourceSearcher(Collections.singletonList(rawFolder), "bc");
        FileGatherer fileGatherer = new FileGatherer();
        searcher.search(fileGatherer);
        for (File bcFile : fileGatherer.getFiles()) {
            String name = bcFile.getName();
            String objName = name.replaceAll("\\.bc", ".o");
            String soName = "librs." + name.replaceAll("\\.bc", ".so");
            for (Abi abi : ABIS) {
                File objFile = this.createSupportObjFile(bcFile, abi, objName, launcher, env);
                this.createSupportLibFile(objFile, abi, soName, launcher, env);
            }
        }
    }

    private File createSupportObjFile(@NonNull File bcFile, @NonNull Abi abi, @NonNull String objName, @NonNull CommandLineLauncher launcher, @NonNull Map<String, String> env) throws IOException, InterruptedException {
        File abiFolder = new File(this.mObjOutputDir, abi.mDevice);
        if (!abiFolder.isDirectory() && !abiFolder.mkdirs()) {
            throw new IOException("Unable to create dir " + abiFolder.getAbsolutePath());
        }
        File exe = new File(this.mBuildToolInfo.getPath(BuildToolInfo.PathId.BCC_COMPAT));
        ArrayList args = Lists.newArrayListWithExpectedSize((int)10);
        args.add("-O" + Integer.toString(this.mOptimLevel));
        File outFile = new File(abiFolder, objName);
        args.add("-o");
        args.add(outFile.getAbsolutePath());
        args.add("-fPIC");
        args.add("-shared");
        args.add("-rt-path");
        args.add(this.mLibClCore.get(abi.mDevice).getAbsolutePath());
        args.add("-mtriple");
        args.add(abi.mToolchain);
        args.add(bcFile.getAbsolutePath());
        launcher.launch(exe, args, env);
        return outFile;
    }

    private void createSupportLibFile(@NonNull File objFile, @NonNull Abi abi, @NonNull String soName, @NonNull CommandLineLauncher launcher, @NonNull Map<String, String> env) throws IOException, InterruptedException {
        File abiFolder = new File(this.mLibOutputDir, abi.mDevice);
        if (!abiFolder.isDirectory() && !abiFolder.mkdirs()) {
            throw new IOException("Unable to create dir " + abiFolder.getAbsolutePath());
        }
        File intermediatesFolder = new File(this.mRsLib, "intermediates");
        File intermediatesAbiFolder = new File(intermediatesFolder, abi.mDevice);
        File packagedFolder = new File(this.mRsLib, "packaged");
        File packagedAbiFolder = new File(packagedFolder, abi.mDevice);
        ArrayList args = Lists.newArrayListWithExpectedSize((int)25);
        args.add("--eh-frame-hdr");
        Collections.addAll(args, abi.mLinkerArgs);
        args.add("-shared");
        args.add("-Bsymbolic");
        args.add("-z");
        args.add("noexecstack");
        args.add("-z");
        args.add("relro");
        args.add("-z");
        args.add("now");
        File outFile = new File(abiFolder, soName);
        args.add("-o");
        args.add(outFile.getAbsolutePath());
        args.add("-L" + intermediatesAbiFolder.getAbsolutePath());
        args.add("-L" + packagedAbiFolder.getAbsolutePath());
        args.add("-soname");
        args.add(soName);
        args.add(objFile.getAbsolutePath());
        args.add(new File(intermediatesAbiFolder, "libcompiler_rt.a").getAbsolutePath());
        args.add("-lRSSupport");
        args.add("-lm");
        args.add("-lc");
        File exe = new File(this.mBuildToolInfo.getPath(abi.mLinker));
        launcher.launch(exe, args, env);
    }

    protected static void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (file.isDirectory()) {
                    RenderScriptProcessor.deleteFolder(file);
                    continue;
                }
                file.delete();
            }
        }
        folder.delete();
    }

    public static interface CommandLineLauncher {
        public void launch(@NonNull File var1, @NonNull List<String> var2, @NonNull Map<String, String> var3) throws IOException, InterruptedException;
    }

    private static final class Abi {
        @NonNull
        private final String mDevice;
        @NonNull
        private final String mToolchain;
        @NonNull
        private final BuildToolInfo.PathId mLinker;
        @NonNull
        private final String[] mLinkerArgs;

        Abi(@NonNull String device, @NonNull String toolchain, @NonNull BuildToolInfo.PathId linker, String ... linkerArgs) {
            this.mDevice = device;
            this.mToolchain = toolchain;
            this.mLinker = linker;
            this.mLinkerArgs = linkerArgs;
        }
    }
}

