/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ddms.views;

import com.android.ddmlib.logcat.LogCatMessage;
import com.android.ddmuilib.SelectionDependentPanel;
import com.android.ddmuilib.logcat.ILogCatMessageSelectionListener;
import com.android.ddmuilib.logcat.LogCatPanel;
import com.android.ddmuilib.logcat.LogCatStackTraceParser;
import com.android.ide.eclipse.ddms.DdmsPlugin;
import com.android.ide.eclipse.ddms.JavaSourceRevealer;
import com.android.ide.eclipse.ddms.i18n.Messages;
import com.android.ide.eclipse.ddms.views.SelectionDependentViewPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;

public class LogCatView
extends SelectionDependentViewPart {
    public static final String ID = "com.android.ide.eclipse.ddms.views.LogCatView";
    public static final boolean DEFAULT_SWITCH_PERSPECTIVE = true;
    public static final String DEFAULT_PERSPECTIVE_ID = "org.eclipse.jdt.ui.JavaPerspective";
    private LogCatPanel mLogCatPanel;
    private LogCatStackTraceParser mStackTraceParser = new LogCatStackTraceParser();
    private Clipboard mClipboard;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        IPreferenceStore prefStore = DdmsPlugin.getDefault().getPreferenceStore();
        this.mLogCatPanel = new LogCatPanel(prefStore);
        this.mLogCatPanel.createPanel(parent);
        this.setSelectionDependentPanel((SelectionDependentPanel)this.mLogCatPanel);
        this.mLogCatPanel.addLogCatMessageSelectionListener(new ILogCatMessageSelectionListener(){

            public void messageDoubleClicked(LogCatMessage m) {
                LogCatView.this.onDoubleClick(m);
            }
        });
        this.mClipboard = new Clipboard(parent.getDisplay());
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)new Action(Messages.LogCatView_Copy){

            public void run() {
                LogCatView.this.mLogCatPanel.copySelectionToClipboard(LogCatView.this.mClipboard);
            }
        });
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)new Action(Messages.LogCatView_Select_All){

            public void run() {
                LogCatView.this.mLogCatPanel.selectAll();
            }
        });
        actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)new Action("Find"){

            public void run() {
                LogCatView.this.mLogCatPanel.showFindDialog();
            }
        });
    }

    public void setFocus() {
    }

    private void onDoubleClick(LogCatMessage m) {
        String msg = m.getMessage();
        if (!this.mStackTraceParser.isValidExceptionTrace(msg)) {
            return;
        }
        IPreferenceStore store = DdmsPlugin.getDefault().getPreferenceStore();
        String perspectiveId = null;
        if (store.getBoolean("com.android.ide.eclipse.ddms.switchPerspective")) {
            perspectiveId = store.getString("com.android.ide.eclipse.ddms.perspectiveId");
        }
        String fileName = this.mStackTraceParser.getFileName(msg);
        int lineNumber = this.mStackTraceParser.getLineNumber(msg);
        String methodName = this.mStackTraceParser.getMethodName(msg);
        JavaSourceRevealer.revealMethod(methodName, fileName, lineNumber, perspectiveId);
    }

    public void selectTransientAppFilter(String appName) {
        this.mLogCatPanel.selectTransientAppFilter(appName);
    }
}

