/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ddms.preferences;

import com.android.ddmlib.Log;
import com.android.ide.eclipse.base.InstallDetails;
import com.android.ide.eclipse.ddms.DdmsPlugin;
import com.android.ide.eclipse.ddms.i18n.Messages;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class LogCatPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor mSwitchPerspective;
    private ComboFieldEditor mWhichPerspective;
    private IntegerFieldEditor mMaxMessages;
    private BooleanFieldEditor mAutoMonitorLogcat;
    private ComboFieldEditor mAutoMonitorLogcatLevel;
    private BooleanFieldEditor mAutoScrollLock;

    public LogCatPreferencePage() {
        super(1);
        this.setPreferenceStore(DdmsPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        FontFieldEditor ffe = new FontFieldEditor("logcat.view.font", Messages.LogCatPreferencePage_Display_Font, this.getFieldEditorParent());
        this.addField((FieldEditor)ffe);
        this.mMaxMessages = new IntegerFieldEditor("logcat.messagelist.max.size", Messages.LogCatPreferencePage_MaxMessages, this.getFieldEditorParent());
        this.addField((FieldEditor)this.mMaxMessages);
        this.mAutoScrollLock = new BooleanFieldEditor("logcat.view.auto-scroll-lock", "Automatically enable/disable scroll lock based on the scrollbar position", this.getFieldEditorParent());
        this.addField((FieldEditor)this.mAutoScrollLock);
        this.createHorizontalSeparator();
        if (InstallDetails.isAdtInstalled()) {
            this.createAdtSpecificFieldEditors();
        }
    }

    private void createHorizontalSeparator() {
        Label l = new Label(this.getFieldEditorParent(), 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        l.setLayoutData((Object)gd);
    }

    private void createAdtSpecificFieldEditors() {
        this.mSwitchPerspective = new BooleanFieldEditor("com.android.ide.eclipse.ddms.switchPerspective", Messages.LogCatPreferencePage_Switch_Perspective, this.getFieldEditorParent());
        this.addField((FieldEditor)this.mSwitchPerspective);
        IPerspectiveDescriptor[] perspectiveDescriptors = PlatformUI.getWorkbench().getPerspectiveRegistry().getPerspectives();
        String[][] perspectives = new String[0][0];
        if (perspectiveDescriptors.length > 0) {
            perspectives = new String[perspectiveDescriptors.length][2];
            int i = 0;
            while (i < perspectiveDescriptors.length) {
                IPerspectiveDescriptor perspective = perspectiveDescriptors[i];
                perspectives[i][0] = perspective.getLabel();
                perspectives[i][1] = perspective.getId();
                ++i;
            }
        }
        this.mWhichPerspective = new ComboFieldEditor("com.android.ide.eclipse.ddms.perspectiveId", Messages.LogCatPreferencePage_Switch_To, perspectives, this.getFieldEditorParent());
        this.mWhichPerspective.setEnabled(this.getPreferenceStore().getBoolean("com.android.ide.eclipse.ddms.switchPerspective"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.mWhichPerspective);
        this.createHorizontalSeparator();
        this.mAutoMonitorLogcat = new BooleanFieldEditor("ddms.logcat.automonitor", Messages.LogCatPreferencePage_AutoMonitorLogcat, this.getFieldEditorParent());
        this.addField((FieldEditor)this.mAutoMonitorLogcat);
        this.mAutoMonitorLogcatLevel = new ComboFieldEditor("ddms.logcat.auotmonitor.level", Messages.LogCatPreferencePage_SessionFilterLogLevel, (String[][])new String[][]{{Log.LogLevel.VERBOSE.toString(), Log.LogLevel.VERBOSE.getStringValue()}, {Log.LogLevel.DEBUG.toString(), Log.LogLevel.DEBUG.getStringValue()}, {Log.LogLevel.INFO.toString(), Log.LogLevel.INFO.getStringValue()}, {Log.LogLevel.WARN.toString(), Log.LogLevel.WARN.getStringValue()}, {Log.LogLevel.ERROR.toString(), Log.LogLevel.ERROR.getStringValue()}, {Log.LogLevel.ASSERT.toString(), Log.LogLevel.ASSERT.getStringValue()}}, this.getFieldEditorParent());
        this.mAutoMonitorLogcatLevel.setEnabled(this.getPreferenceStore().getBoolean("ddms.logcat.automonitor"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.mAutoMonitorLogcatLevel);
    }

    public void init(IWorkbench workbench) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource().equals(this.mSwitchPerspective)) {
            this.mWhichPerspective.setEnabled(this.mSwitchPerspective.getBooleanValue(), this.getFieldEditorParent());
        } else if (event.getSource().equals(this.mAutoMonitorLogcat)) {
            this.mAutoMonitorLogcatLevel.setEnabled(this.mAutoMonitorLogcat.getBooleanValue(), this.getFieldEditorParent());
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.mWhichPerspective.setEnabled(this.mSwitchPerspective.getBooleanValue(), this.getFieldEditorParent());
        this.mMaxMessages.setStringValue(Integer.toString(5000));
        this.mAutoMonitorLogcatLevel.setEnabled(this.mAutoMonitorLogcat.getBooleanValue(), this.getFieldEditorParent());
    }
}

