/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;

public class TableItem
extends Item {
    Table parent;
    String[] strings;
    Image[] images;
    boolean checked;
    boolean grayed;
    boolean cached;
    Color foreground;
    Color background;
    Color[] cellForeground;
    Color[] cellBackground;
    Font font;
    Font[] cellFont;
    int width = -1;

    public TableItem(Table table, int n) {
        this(table, n, TableItem.checkNull(table).getItemCount(), true);
    }

    public TableItem(Table table, int n, int n2) {
        this(table, n, n2, true);
    }

    TableItem(Table table, int n, int n2, boolean bl) {
        super(table, n);
        this.parent = table;
        if (bl) {
            table.createItem(this, n2);
        }
    }

    static Table checkNull(Table table) {
        if (table == null) {
            SWT.error(4);
        }
        return table;
    }

    int calculateWidth(int n, GC gC) {
        Image image;
        if (n == 0 && this.width != -1) {
            return this.width;
        }
        int n2 = 0;
        Image image2 = n == 0 ? this.image : (image = this.images == null ? null : this.images[n]);
        String string = n == 0 ? this.text : (this.strings == null ? "" : this.strings[n]);
        Font font = null;
        if (this.cellFont != null) {
            font = this.cellFont[n];
        }
        if (font == null) {
            font = this.font;
        }
        if (font == null) {
            font = this.parent.getFont();
        }
        gC.setFont(font);
        if (image != null) {
            n2 += image.getBounds().width + this.parent.getGap();
        }
        if (string != null && string.length() > 0) {
            n2 += gC.stringExtent((String)string).x;
        }
        boolean bl = true;
        if ((this.parent.style & 0x10000000) != 0) {
            bl = this.cached;
        }
        if (bl && this.parent.hooks(41)) {
            Event event = new Event();
            event.item = this;
            event.index = n;
            event.gc = gC;
            short[] sArray = new short[1];
            OS.GetDataBrowserTableViewRowHeight(this.parent.handle, sArray);
            event.width = n2;
            event.height = sArray[0];
            this.parent.sendEvent(41, event);
            if (sArray[0] < event.height) {
                OS.SetDataBrowserTableViewRowHeight(this.parent.handle, (short)event.height);
                this.redrawWidget(this.parent.handle, false);
            }
            n2 = event.width;
        }
        if (n == 0) {
            this.width = n2;
        }
        return n2;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        this.text = "";
        this.image = null;
        this.strings = null;
        this.images = null;
        this.cached = false;
        this.grayed = false;
        this.checked = false;
        this.background = null;
        this.foreground = null;
        this.cellBackground = null;
        this.cellForeground = null;
        this.font = null;
        this.cellFont = null;
        this.width = -1;
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.background != null ? this.background : this.parent.getBackground();
    }

    public Color getBackground(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.columnCount);
        if (n < 0 || n > n2 - 1) {
            return this.getBackground();
        }
        if (this.cellBackground == null || this.cellBackground[n] == null) {
            return this.getBackground();
        }
        return this.cellBackground[n];
    }

    public Rectangle getBounds() {
        Object object;
        int n;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        Rect rect = new Rect();
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n3 = this.parent.getId(n2);
        int n4 = n = this.parent.columnCount == 0 ? this.parent.column_id : this.parent.columns[0].id;
        if (OS.GetDataBrowserItemPartBounds(this.parent.handle, n3, n, 0x2D2D2D2D, rect) != 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n5 = rect.left;
        short s = rect.top;
        int n6 = 0;
        if (this.image != null) {
            object = this.image.getBounds();
            n5 += ((Rectangle)object).width + this.parent.getGap();
        }
        object = new GC(this.parent);
        Point point = ((GC)object).stringExtent(this.text);
        ((Resource)object).dispose();
        n6 += point.x;
        if (this.parent.columnCount > 0) {
            n6 = Math.min(n6, rect.right - n5);
        }
        int n7 = rect.bottom - rect.top;
        return new Rectangle(n5, s, n6, n7);
    }

    public Rectangle getBounds(int n) {
        int n2;
        int n3;
        short s;
        short s2;
        int n4;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        this.parent.checkItems(true);
        if (n != 0 && (n < 0 || n >= this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rect rect = new Rect();
        int n5 = this.parent.indexOf(this);
        if (n5 == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n6 = this.parent.getId(n5);
        int n7 = n4 = this.parent.columnCount == 0 ? this.parent.column_id : this.parent.columns[n].id;
        if (OS.GetDataBrowserItemPartBounds(this.parent.handle, n6, n4, 0, rect) != 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (OS.VERSION >= 4160) {
            if (this.parent.getLinesVisible()) {
                rect.left = (short)(rect.left + 1);
                rect.top = (short)(rect.top + 1);
            }
            s2 = rect.left;
            s = rect.top;
            n3 = rect.right - rect.left;
            n2 = rect.bottom - rect.top;
        } else {
            Rect rect2 = new Rect();
            if (OS.GetDataBrowserItemPartBounds(this.parent.handle, n6, n4, 0x2D2D2D2D, rect2) != 0) {
                return new Rectangle(0, 0, 0, 0);
            }
            s2 = rect2.left;
            s = rect2.top;
            n3 = rect.right - rect2.left + 1;
            n2 = rect2.bottom - rect2.top + 1;
        }
        return new Rectangle(s2, s, n3, n2);
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.checked;
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.font != null ? this.font : this.parent.getFont();
    }

    public Font getFont(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.columnCount);
        if (n < 0 || n > n2 - 1) {
            return this.getFont();
        }
        if (this.cellFont == null || this.cellFont[n] == null) {
            return this.getFont();
        }
        return this.cellFont[n];
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.foreground != null ? this.foreground : this.parent.getForeground();
    }

    public Color getForeground(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.columnCount);
        if (n < 0 || n > n2 - 1) {
            return this.getForeground();
        }
        if (this.cellForeground == null || this.cellForeground[n] == null) {
            return this.getForeground();
        }
        return this.cellForeground[n];
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getImage();
    }

    public Image getImage(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (n == 0) {
            return this.getImage();
        }
        if (this.images != null && n >= 0 && n < this.images.length) {
            return this.images[n];
        }
        return null;
    }

    public Rectangle getImageBounds(int n) {
        Rectangle rectangle;
        int n2;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        this.parent.checkItems(true);
        if (n != 0 && (n < 0 || n >= this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rect rect = new Rect();
        int n3 = this.parent.indexOf(this);
        if (n3 == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n4 = this.parent.getId(n3);
        int n5 = n2 = this.parent.columnCount == 0 ? this.parent.column_id : this.parent.columns[n].id;
        if (OS.GetDataBrowserItemPartBounds(this.parent.handle, n4, n2, 0x2D2D2D2D, rect) != 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        short s = rect.left;
        short s2 = rect.top;
        int n6 = 0;
        if (n == 0 && this.image != null) {
            rectangle = this.image.getBounds();
            n6 += rectangle.width;
        }
        if (n != 0 && this.images != null && this.images[n] != null) {
            rectangle = this.images[n].getBounds();
            n6 += rectangle.width;
        }
        int n7 = rect.bottom - rect.top + 1;
        return new Rectangle(s, s2, n6, n7);
    }

    public int getImageIndent() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return 0;
    }

    String getNameText() {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return "*virtual*";
        }
        return super.getNameText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getText();
    }

    public String getText(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (n == 0) {
            return this.getText();
        }
        if (this.strings != null && n >= 0 && n < this.strings.length) {
            String string = this.strings[n];
            return string != null ? string : "";
        }
        return "";
    }

    public Rectangle getTextBounds(int n) {
        int n2;
        int n3;
        short s;
        int n4;
        int n5;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        this.parent.checkItems(true);
        if (n != 0 && (n < 0 || n >= this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rect rect = new Rect();
        int n6 = this.parent.indexOf(this);
        if (n6 == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n7 = this.parent.getId(n6);
        int n8 = n5 = this.parent.columnCount == 0 ? this.parent.column_id : this.parent.columns[n].id;
        if (OS.GetDataBrowserItemPartBounds(this.parent.handle, n7, n5, 0, rect) != 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n9 = 0;
        int n10 = this.parent.getInsetWidth() / 2;
        Image image = this.getImage(n);
        if (image != null) {
            Rectangle rectangle = image.getBounds();
            n9 = rectangle.width + this.parent.getGap();
        }
        if (OS.VERSION >= 4160) {
            if (this.parent.getLinesVisible()) {
                rect.left = (short)(rect.left + 1);
                rect.top = (short)(rect.top + 1);
            }
            n4 = rect.left + n9 + n10;
            s = rect.top;
            n3 = Math.max(0, rect.right - rect.left - n9 - n10 * 2);
            n2 = rect.bottom - rect.top;
        } else {
            Rect rect2 = new Rect();
            if (OS.GetDataBrowserItemPartBounds(this.parent.handle, n7, n5, 0x2D2D2D2D, rect2) != 0) {
                return new Rectangle(0, 0, 0, 0);
            }
            n4 = rect2.left + n9 + n10;
            s = rect2.top;
            n3 = Math.max(0, rect.right - rect2.left + 1 - n9 - n10 * 2);
            n2 = rect2.bottom - rect2.top + 1;
        }
        return new Rectangle(n4, s, n3, n2);
    }

    void redraw(int n) {
        if (this.parent.currentItem == this) {
            return;
        }
        if (!this.getDrawing() && n != 1024) {
            return;
        }
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return;
        }
        int[] nArray = new int[]{this.parent.getId(n2)};
        OS.UpdateDataBrowserItems(this.parent.handle, 0, nArray.length, nArray, 0, n);
        if (n == 1024) {
            Rect rect = new Rect();
            if (OS.GetDataBrowserItemPartBounds(this.parent.handle, this.parent.getId(n2), n, 0, rect) == 0) {
                short s = rect.left;
                int n3 = rect.top - 1;
                int n4 = rect.right - rect.left;
                int n5 = 1;
                this.redrawWidget(this.parent.handle, s, n3, n4, n5, false);
            }
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
        this.parent.checkItems(true);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.strings = null;
        this.images = null;
        this.foreground = null;
        this.background = null;
        this.font = null;
        this.cellForeground = null;
        this.cellBackground = null;
        this.cellFont = null;
    }

    public void setBackground(Color color) {
        Color color2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if ((color2 = this.background) == color) {
            return;
        }
        this.background = color;
        if (color2 != null && color2.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(0);
    }

    public void setBackground(int n, Color color) {
        Color color2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n2 = Math.max(1, this.parent.columnCount);
        if (n < 0 || n > n2 - 1) {
            return;
        }
        if (this.cellBackground == null) {
            if (color == null) {
                return;
            }
            this.cellBackground = new Color[n2];
        }
        if ((color2 = this.cellBackground[n]) == color) {
            return;
        }
        this.cellBackground[n] = color;
        if (color2 != null && color2.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(0);
    }

    public void setChecked(boolean bl) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.checked == bl) {
            return;
        }
        this.setChecked(bl, false);
    }

    void setChecked(boolean bl, boolean bl2) {
        this.checked = bl;
        this.cached = true;
        this.redraw(1024);
        if (bl2) {
            Event event = new Event();
            event.item = this;
            event.detail = 32;
            this.parent.postEvent(13, event);
        }
    }

    public void setFont(Font font) {
        Font font2;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((font2 = this.font) == font) {
            return;
        }
        this.font = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        this.cached = true;
        this.redraw(0);
    }

    public void setFont(int n, Font font) {
        Font font2;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int n2 = Math.max(1, this.parent.columnCount);
        if (n < 0 || n > n2 - 1) {
            return;
        }
        if (this.cellFont == null) {
            if (font == null) {
                return;
            }
            this.cellFont = new Font[n2];
        }
        if ((font2 = this.cellFont[n]) == font) {
            return;
        }
        this.cellFont[n] = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        this.cached = true;
        this.redraw(0);
    }

    public void setForeground(Color color) {
        Color color2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if ((color2 = this.foreground) == color) {
            return;
        }
        this.foreground = color;
        if (color2 != null && color2.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(0);
    }

    public void setForeground(int n, Color color) {
        Color color2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n2 = Math.max(1, this.parent.columnCount);
        if (n < 0 || n > n2 - 1) {
            return;
        }
        if (this.cellForeground == null) {
            if (color == null) {
                return;
            }
            this.cellForeground = new Color[n2];
        }
        if ((color2 = this.cellForeground[n]) == color) {
            return;
        }
        this.cellForeground[n] = color;
        if (color2 != null && color2.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(0);
    }

    public void setGrayed(boolean bl) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.grayed == bl) {
            return;
        }
        this.grayed = bl;
        this.cached = true;
        this.redraw(1024);
    }

    public void setImage(Image[] imageArray) {
        this.checkWidget();
        if (imageArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < imageArray.length) {
            this.setImage(n, imageArray[n]);
            ++n;
        }
    }

    public void setImage(int n, Image image) {
        int n2;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((n2 = this.parent.indexOf(this)) == -1) {
            return;
        }
        if (this.parent.imageBounds == null && image != null) {
            this.parent.setItemHeight(image);
        }
        if (n == 0) {
            if (image != null && image.type == 1 && image.equals(this.image)) {
                return;
            }
            this.width = -1;
            super.setImage(image);
        }
        int n3 = Math.max(1, this.parent.columnCount);
        if (n >= 0 && n < n3) {
            if (this.images == null) {
                this.images = new Image[n3];
            }
            if (image != null && image.type == 1 && image.equals(this.images[n])) {
                return;
            }
            this.images[n] = image;
        }
        this.cached = true;
        if (n == 0) {
            this.parent.setScrollWidth(this);
        }
        this.redraw(0);
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImageIndent(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        this.cached = true;
    }

    public void setText(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string != null) {
                this.setText(n, string);
            }
            ++n;
        }
    }

    public void setText(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n == 0) {
            if (string.equals(this.text)) {
                return;
            }
            this.width = -1;
            super.setText(string);
        }
        int n2 = Math.max(1, this.parent.columnCount);
        if (n >= 0 && n < n2) {
            if (this.strings == null) {
                this.strings = new String[n2];
            }
            if (string.equals(this.strings[n])) {
                return;
            }
            this.strings[n] = string;
        }
        this.cached = true;
        if (n == 0) {
            this.parent.setScrollWidth(this);
        }
        this.redraw(0);
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }
}

