/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.data;

import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.data.DelegatedData;
import com.google.clearsilver.jsilver.data.TypeConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedData
extends DelegatedData {
    public static final Logger logger = Logger.getLogger(ChainedData.class.getName());
    public static final boolean DEBUG_MULTIPLE_ASSIGNMENTS = false;
    Data[] dataList;

    public ChainedData(Data data) {
        super(data);
        this.dataList = new Data[]{data};
    }

    public ChainedData(Data ... dataList) {
        super(ChainedData.getFirstData(dataList));
        this.dataList = dataList;
    }

    public ChainedData(List<Data> dataList) {
        super(ChainedData.getFirstData(dataList));
        this.dataList = dataList.toArray(new Data[dataList.size()]);
    }

    @Override
    protected DelegatedData newInstance(Data newDelegate) {
        return newDelegate == null ? null : new ChainedData(newDelegate);
    }

    private static Data getFirstData(Data[] dataList) {
        if (dataList.length == 0) {
            throw new IllegalArgumentException("Must pass in at least one Data object to ChainedData.");
        }
        Data first = dataList[0];
        if (first == null) {
            throw new IllegalArgumentException("ChainedData does not accept null Data objects.");
        }
        return first;
    }

    private static Data getFirstData(List<Data> dataList) {
        if (dataList.size() == 0) {
            throw new IllegalArgumentException("Must pass in at least one Data object to ChainedData.");
        }
        Data first = dataList.get(0);
        if (first == null) {
            throw new IllegalArgumentException("ChainedData does not accept null Data objects.");
        }
        return first;
    }

    @Override
    public Data getChild(String path) {
        ArrayList children = null;
        Data first = null;
        for (Data d : this.dataList) {
            Data child = d.getChild(path);
            if (child == null) continue;
            return child;
        }
        if (children == null) {
            return first;
        }
        logger.info("Found " + children.size() + " matches for path " + path);
        return first;
    }

    @Override
    public Data createChild(String path) {
        Data child = this.getChild(path);
        if (child != null) {
            return child;
        }
        return this.dataList[0].createChild(path);
    }

    @Override
    public String getValue(String path, String defaultValue) {
        Data child = this.getChild(path);
        if (child != null && child.getValue() != null) {
            return child.getValue();
        }
        return defaultValue;
    }

    @Override
    public int getIntValue(String path, int defaultValue) {
        Data child = this.getChild(path);
        if (child != null) {
            String value = child.getValue();
            try {
                return value == null ? defaultValue : TypeConverter.parseNumber(value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    @Override
    public String getValue(String path) {
        Data child = this.getChild(path);
        if (child != null) {
            return child.getValue();
        }
        return null;
    }

    @Override
    public int getIntValue(String path) {
        Data child = this.getChild(path);
        if (child != null) {
            return child.getIntValue();
        }
        return 0;
    }

    @Override
    public boolean getBooleanValue(String path) {
        Data child = this.getChild(path);
        if (child != null) {
            return child.getBooleanValue();
        }
        return false;
    }

    @Override
    public void toString(StringBuilder out, int indent) {
        for (Data d : this.dataList) {
            d.toString(out, indent);
        }
    }

    @Override
    public void write(Appendable out, int indent) throws IOException {
        for (Data d : this.dataList) {
            d.write(out, indent);
        }
    }

    @Override
    public void optimize() {
        for (Data d : this.dataList) {
            d.optimize();
        }
    }
}

