/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.adaptor;

import com.google.clearsilver.jsilver.JSilver;
import com.google.clearsilver.jsilver.JSilverOptions;
import com.google.clearsilver.jsilver.adaptor.JCs;
import com.google.clearsilver.jsilver.adaptor.JHdf;
import com.google.clearsilver.jsilver.adaptor.LoadPathToFileCache;
import com.google.clearsilver.jsilver.data.DataFactory;
import com.google.clearsilver.jsilver.data.DefaultData;
import com.google.clearsilver.jsilver.data.HDFDataFactory;
import org.clearsilver.ClearsilverFactory;
import org.clearsilver.DelegatedHdf;
import org.clearsilver.HDF;

public class JSilverFactory
implements ClearsilverFactory {
    private static final JSilverOptions DEFAULT_OPTIONS = new JSilverOptions();
    private final boolean unwrapDelegatedHdfs;
    private final JSilver jSilver;
    private final JSilverOptions options;
    private final DataFactory dataFactory;
    private final LoadPathToFileCache loadPathCache;

    public JSilverFactory() {
        this(DEFAULT_OPTIONS);
    }

    public JSilverFactory(JSilverOptions options) {
        this(options, true);
    }

    public JSilverFactory(JSilverOptions options, boolean unwrapDelegatedHdfs) {
        this(new JSilver(null, options), unwrapDelegatedHdfs);
    }

    public JSilverFactory(JSilver jSilver, boolean unwrapDelegatedHdfs) {
        this.unwrapDelegatedHdfs = unwrapDelegatedHdfs;
        this.jSilver = jSilver;
        this.options = jSilver.getOptions();
        this.loadPathCache = this.options.getLoadPathCacheSize() == 0 ? null : new LoadPathToFileCache(this.options.getLoadPathCacheSize());
        this.dataFactory = new HDFDataFactory(this.options.getIgnoreAttributes(), this.options.getStringInternStrategy());
    }

    public JCs newCs(HDF hdf) {
        if (this.unwrapDelegatedHdfs) {
            hdf = DelegatedHdf.getFullyUnwrappedHdf(hdf);
        }
        return new JCs(JHdf.cast(hdf), this.jSilver, this.loadPathCache);
    }

    public JCs newCs(HDF hdf, HDF globalHdf) {
        if (this.unwrapDelegatedHdfs) {
            hdf = DelegatedHdf.getFullyUnwrappedHdf(hdf);
            globalHdf = DelegatedHdf.getFullyUnwrappedHdf(globalHdf);
        }
        JCs cs = new JCs(JHdf.cast(hdf), this.jSilver, this.loadPathCache);
        cs.setGlobalHDF(globalHdf);
        return cs;
    }

    public JHdf newHdf() {
        return new JHdf(new DefaultData(), this.dataFactory, this.loadPathCache, this.options);
    }
}

