/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.Value;

public class CleanupDetector
extends Detector
implements Detector.ClassScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(CleanupDetector.class, Scope.CLASS_FILE_SCOPE);
    public static final Issue RECYCLE_RESOURCE = Issue.create("Recycle", "Missing `recycle()` calls", "Looks for missing `recycle()` calls on resources", "Many resources, such as TypedArrays, VelocityTrackers, etc., should be recycled (with a `recycle()` call) after use. This lint check looks for missing `recycle()` calls.", Category.PERFORMANCE, 7, Severity.WARNING, IMPLEMENTATION);
    public static final Issue COMMIT_FRAGMENT = Issue.create("CommitTransaction", "Missing `commit()` calls", "Looks for missing `commit()` calls on `FragmentTransactions`", "After creating a `FragmentTransaction`, you typically need to commit it as well", Category.CORRECTNESS, 7, Severity.WARNING, IMPLEMENTATION);
    private static final String RECYCLE = "recycle";
    private static final String OBTAIN = "obtain";
    private static final String SHOW = "show";
    private static final String OBTAIN_NO_HISTORY = "obtainNoHistory";
    private static final String OBTAIN_ATTRIBUTES = "obtainAttributes";
    private static final String OBTAIN_TYPED_ARRAY = "obtainTypedArray";
    private static final String OBTAIN_STYLED_ATTRIBUTES = "obtainStyledAttributes";
    private static final String BEGIN_TRANSACTION = "beginTransaction";
    private static final String COMMIT = "commit";
    private static final String COMMIT_ALLOWING_LOSS = "commitAllowingStateLoss";
    private static final String VELOCITY_TRACKER_CLS = "android/view/VelocityTracker";
    private static final String TYPED_ARRAY_CLS = "android/content/res/TypedArray";
    private static final String CONTEXT_CLS = "android/content/Context";
    private static final String MOTION_EVENT_CLS = "android/view/MotionEvent";
    private static final String RESOURCES_CLS = "android/content/res/Resources";
    private static final String PARCEL_CLS = "android/os/Parcel";
    private static final String FRAGMENT_MANAGER_CLS = "android/app/FragmentManager";
    private static final String FRAGMENT_MANAGER_V4_CLS = "android/support/v4/app/FragmentManager";
    private static final String FRAGMENT_TRANSACTION_CLS = "android/app/FragmentTransaction";
    private static final String FRAGMENT_TRANSACTION_V4_CLS = "android/support/v4/app/FragmentTransaction";
    private static final String DIALOG_FRAGMENT_SHOW_DESC = "(Landroid/app/FragmentTransaction;Ljava/lang/String;)I";
    private static final String DIALOG_FRAGMENT_SHOW_V4_DESC = "(Landroid/support/v4/app/FragmentTransaction;Ljava/lang/String;)I";
    private static final String TYPED_ARRAY_SIG = "Landroid/content/res/TypedArray;";
    private boolean mObtainsTypedArray;
    private boolean mRecyclesTypedArray;
    private boolean mObtainsTracker;
    private boolean mRecyclesTracker;
    private boolean mObtainsMotionEvent;
    private boolean mRecyclesMotionEvent;
    private boolean mObtainsParcel;
    private boolean mRecyclesParcel;
    private boolean mObtainsTransaction;
    private boolean mCommitsTransaction;

    @Override
    public void afterCheckProject(@NonNull Context context) {
        int phase = context.getDriver().getPhase();
        if (phase == 1 && (this.mObtainsTypedArray && !this.mRecyclesTypedArray || this.mObtainsTracker && !this.mRecyclesTracker || this.mObtainsParcel && !this.mRecyclesParcel || this.mObtainsMotionEvent && !this.mRecyclesMotionEvent || this.mObtainsTransaction && !this.mCommitsTransaction)) {
            context.getDriver().requestRepeat(this, Scope.CLASS_FILE_SCOPE);
        }
    }

    @Override
    @Nullable
    public List<String> getApplicableCallNames() {
        return Arrays.asList(RECYCLE, OBTAIN_STYLED_ATTRIBUTES, OBTAIN, OBTAIN_ATTRIBUTES, OBTAIN_TYPED_ARRAY, OBTAIN_NO_HISTORY, BEGIN_TRANSACTION, COMMIT, COMMIT_ALLOWING_LOSS, SHOW);
    }

    @Override
    public void checkCall(@NonNull ClassContext context, @NonNull ClassNode classNode, @NonNull MethodNode method, @NonNull MethodInsnNode call) {
        String name = call.name;
        String owner = call.owner;
        String desc = call.desc;
        int phase = context.getDriver().getPhase();
        if (SHOW.equals(name)) {
            if (desc.equals(DIALOG_FRAGMENT_SHOW_DESC) || desc.equals(DIALOG_FRAGMENT_SHOW_V4_DESC)) {
                this.mCommitsTransaction = true;
            }
        } else if (RECYCLE.equals(name) && desc.equals("()V")) {
            if (owner.equals(TYPED_ARRAY_CLS)) {
                this.mRecyclesTypedArray = true;
            } else if (owner.equals(VELOCITY_TRACKER_CLS)) {
                this.mRecyclesTracker = true;
            } else if (owner.equals(MOTION_EVENT_CLS)) {
                this.mRecyclesMotionEvent = true;
            } else if (owner.equals(PARCEL_CLS)) {
                this.mRecyclesParcel = true;
            }
        } else if ((COMMIT.equals(name) || COMMIT_ALLOWING_LOSS.equals(name)) && desc.equals("()I")) {
            if (owner.equals(FRAGMENT_TRANSACTION_CLS) || owner.equals(FRAGMENT_TRANSACTION_V4_CLS)) {
                this.mCommitsTransaction = true;
            }
        } else if (owner.equals(MOTION_EVENT_CLS)) {
            if (OBTAIN.equals(name) || OBTAIN_NO_HISTORY.equals(name)) {
                this.mObtainsMotionEvent = true;
                if (phase == 2 && !this.mRecyclesMotionEvent) {
                    context.report(RECYCLE_RESOURCE, method, (AbstractInsnNode)call, context.getLocation((AbstractInsnNode)call), CleanupDetector.getErrorMessage(MOTION_EVENT_CLS), null);
                } else if (phase == 1 && CleanupDetector.checkMethodFlow(context, classNode, method, call, MOTION_EVENT_CLS)) {
                    this.mRecyclesMotionEvent = true;
                }
            }
        } else if (OBTAIN.equals(name)) {
            if (owner.equals(VELOCITY_TRACKER_CLS)) {
                this.mObtainsTracker = true;
                if (phase == 2 && !this.mRecyclesTracker) {
                    context.report(RECYCLE_RESOURCE, method, (AbstractInsnNode)call, context.getLocation((AbstractInsnNode)call), CleanupDetector.getErrorMessage(VELOCITY_TRACKER_CLS), null);
                }
            } else if (owner.equals(PARCEL_CLS)) {
                this.mObtainsParcel = true;
                if (phase == 2 && !this.mRecyclesParcel) {
                    context.report(RECYCLE_RESOURCE, method, (AbstractInsnNode)call, context.getLocation((AbstractInsnNode)call), CleanupDetector.getErrorMessage(PARCEL_CLS), null);
                } else if (phase == 1 && CleanupDetector.checkMethodFlow(context, classNode, method, call, PARCEL_CLS)) {
                    this.mRecyclesParcel = true;
                }
            }
        } else if (OBTAIN_STYLED_ATTRIBUTES.equals(name) || OBTAIN_ATTRIBUTES.equals(name) || OBTAIN_TYPED_ARRAY.equals(name)) {
            if ((owner.equals(CONTEXT_CLS) || owner.equals(RESOURCES_CLS)) && desc.endsWith(TYPED_ARRAY_SIG)) {
                this.mObtainsTypedArray = true;
                if (phase == 2 && !this.mRecyclesTypedArray) {
                    context.report(RECYCLE_RESOURCE, method, (AbstractInsnNode)call, context.getLocation((AbstractInsnNode)call), CleanupDetector.getErrorMessage(TYPED_ARRAY_CLS), null);
                } else if (phase == 1 && CleanupDetector.checkMethodFlow(context, classNode, method, call, TYPED_ARRAY_CLS)) {
                    this.mRecyclesTypedArray = true;
                }
            }
        } else if (BEGIN_TRANSACTION.equals(name) && (owner.equals(FRAGMENT_MANAGER_CLS) || owner.equals(FRAGMENT_MANAGER_V4_CLS))) {
            this.mObtainsTransaction = true;
            if (phase == 2 && !this.mCommitsTransaction) {
                context.report(COMMIT_FRAGMENT, method, (AbstractInsnNode)call, context.getLocation((AbstractInsnNode)call), CleanupDetector.getErrorMessage(owner.equals(FRAGMENT_MANAGER_CLS) ? FRAGMENT_TRANSACTION_CLS : FRAGMENT_TRANSACTION_V4_CLS), null);
            } else if (phase == 1 && CleanupDetector.checkMethodFlow(context, classNode, method, call, owner.equals(FRAGMENT_MANAGER_CLS) ? FRAGMENT_TRANSACTION_CLS : FRAGMENT_TRANSACTION_V4_CLS)) {
                this.mCommitsTransaction = true;
            }
        }
    }

    private static String getErrorMessage(String owner) {
        if (FRAGMENT_TRANSACTION_CLS.equals(owner) || FRAGMENT_TRANSACTION_V4_CLS.equals(owner)) {
            return "This transaction should be completed with a commit() call";
        }
        String className = owner.substring(owner.lastIndexOf(47) + 1);
        return String.format("This %1$s should be recycled after use with #recycle()", className);
    }

    private static boolean checkMethodFlow(ClassContext context, ClassNode classNode, MethodNode method, MethodInsnNode call, String recycleOwner) {
        CleanupTracker interpreter = new CleanupTracker(context, method, call, recycleOwner);
        ResourceAnalyzer analyzer = new ResourceAnalyzer(interpreter);
        interpreter.setAnalyzer(analyzer);
        try {
            analyzer.analyze(classNode.name, method);
            if (!interpreter.isCleanedUp() && !interpreter.isEscaped()) {
                Location location = context.getLocation((AbstractInsnNode)call);
                String message = CleanupDetector.getErrorMessage(recycleOwner);
                Issue issue = call.owner.equals(FRAGMENT_MANAGER_CLS) ? COMMIT_FRAGMENT : RECYCLE_RESOURCE;
                context.report(issue, method, (AbstractInsnNode)call, location, message, null);
                return true;
            }
        }
        catch (AnalyzerException e) {
            context.log(e, null, new Object[0]);
        }
        return false;
    }

    static boolean hasReturnType(String owner, String desc) {
        int ownerLen;
        int descLen = desc.length();
        if (descLen < (ownerLen = owner.length()) + 3) {
            return false;
        }
        if (desc.charAt(descLen - 1) != ';') {
            return false;
        }
        int typeBegin = descLen - 2 - ownerLen;
        if (desc.charAt(typeBegin - 1) != ')' || desc.charAt(typeBegin) != 'L') {
            return false;
        }
        return desc.regionMatches(typeBegin + 1, owner, 0, ownerLen);
    }

    private static class ResourceAnalyzer
    extends Analyzer {
        private Frame mCurrent;
        private Frame mFrame1;
        private Frame mFrame2;

        public ResourceAnalyzer(Interpreter interpreter) {
            super(interpreter);
        }

        Frame getCurrentFrame() {
            return this.mCurrent;
        }

        @Override
        protected void init(String owner, MethodNode m) throws AnalyzerException {
            this.mCurrent = this.mFrame2;
            super.init(owner, m);
        }

        @Override
        protected Frame newFrame(int nLocals, int nStack) {
            Frame newFrame = super.newFrame(nLocals, nStack);
            this.mFrame2 = this.mFrame1;
            this.mFrame1 = newFrame;
            return newFrame;
        }
    }

    private static class CleanupTracker
    extends Interpreter {
        private static final Value INSTANCE = BasicValue.INT_VALUE;
        private static final Value RECYCLED = BasicValue.FLOAT_VALUE;
        private static final Value UNKNOWN = BasicValue.UNINITIALIZED_VALUE;
        private final ClassContext mContext;
        private final MethodNode mMethod;
        private final MethodInsnNode mObtainNode;
        private boolean mIsCleanedUp;
        private boolean mEscapes;
        private final String mRecycleOwner;
        private ResourceAnalyzer mAnalyzer;

        public CleanupTracker(@NonNull ClassContext context, @NonNull MethodNode method, @NonNull MethodInsnNode obtainNode, @NonNull String recycleOwner) {
            super(262144);
            this.mContext = context;
            this.mMethod = method;
            this.mObtainNode = obtainNode;
            this.mRecycleOwner = recycleOwner;
        }

        void setAnalyzer(ResourceAnalyzer analyzer) {
            this.mAnalyzer = analyzer;
        }

        public boolean isCleanedUp() {
            return this.mIsCleanedUp;
        }

        public boolean isEscaped() {
            return this.mEscapes;
        }

        @Override
        public Value newOperation(AbstractInsnNode node) throws AnalyzerException {
            return UNKNOWN;
        }

        @Override
        public Value newValue(Type type) {
            if (type != null && type.getSort() == 0) {
                return null;
            }
            return UNKNOWN;
        }

        @Override
        public Value copyOperation(AbstractInsnNode node, Value value) throws AnalyzerException {
            return value;
        }

        @Override
        public Value binaryOperation(AbstractInsnNode node, Value value1, Value value2) throws AnalyzerException {
            if (node.getOpcode() == 181 && value2 == INSTANCE) {
                this.mEscapes = true;
            }
            return this.merge(value1, value2);
        }

        @Override
        public Value naryOperation(AbstractInsnNode node, List values) throws AnalyzerException {
            if (node == this.mObtainNode) {
                return INSTANCE;
            }
            MethodInsnNode call = null;
            if (node.getType() == 5) {
                call = (MethodInsnNode)node;
                if (node.getOpcode() == 182) {
                    if (call.name.equals(CleanupDetector.RECYCLE) && call.owner.equals(this.mRecycleOwner)) {
                        if (values != null && values.size() == 1 && values.get(0) == INSTANCE) {
                            this.mIsCleanedUp = true;
                            Frame frame = this.mAnalyzer.getCurrentFrame();
                            if (frame != null) {
                                int localSize = frame.getLocals();
                                for (int i = 0; i < localSize; ++i) {
                                    Value local = frame.getLocal(i);
                                    if (local != INSTANCE) continue;
                                    frame.setLocal(i, RECYCLED);
                                }
                                int stackSize = frame.getStackSize();
                                if (stackSize == 1 && frame.getStack(0) == INSTANCE) {
                                    frame.pop();
                                    frame.push(RECYCLED);
                                }
                            }
                            return RECYCLED;
                        }
                    } else if ((call.name.equals(CleanupDetector.COMMIT) || call.name.equals(CleanupDetector.COMMIT_ALLOWING_LOSS)) && call.owner.equals(this.mRecycleOwner)) {
                        if (values != null && values.size() == 1 && values.get(0) == INSTANCE) {
                            this.mIsCleanedUp = true;
                            return INSTANCE;
                        }
                    } else if (call.name.equals(CleanupDetector.SHOW) && (call.desc.equals(CleanupDetector.DIALOG_FRAGMENT_SHOW_DESC) || call.desc.equals(CleanupDetector.DIALOG_FRAGMENT_SHOW_V4_DESC))) {
                        if (values != null && values.size() == 3 && values.get(1) == INSTANCE) {
                            this.mIsCleanedUp = true;
                            return INSTANCE;
                        }
                    } else if (call.owner.equals(this.mRecycleOwner) && CleanupDetector.hasReturnType(this.mRecycleOwner, call.desc)) {
                        return INSTANCE;
                    }
                }
            }
            if (values != null && values.size() >= 1) {
                int start = node.getOpcode() == 184 ? 0 : 1;
                int n = values.size();
                for (int i = 0; i < n; ++i) {
                    Object v = values.get(i);
                    if (v == INSTANCE && i >= start) {
                        if (node.getOpcode() == 184) {
                            assert (call != null);
                            if (call.name.equals(CleanupDetector.OBTAIN) && call.owner.equals(CleanupDetector.MOTION_EVENT_CLS)) {
                                return UNKNOWN;
                            }
                        }
                        this.mEscapes = true;
                        continue;
                    }
                    if (v != RECYCLED || call == null) continue;
                    Location location = this.mContext.getLocation((AbstractInsnNode)call);
                    String message = String.format("This %1$s has already been recycled", this.mRecycleOwner.substring(this.mRecycleOwner.lastIndexOf(47) + 1));
                    this.mContext.report(RECYCLE_RESOURCE, this.mMethod, (AbstractInsnNode)call, location, message, null);
                }
            }
            return UNKNOWN;
        }

        @Override
        public Value unaryOperation(AbstractInsnNode node, Value value) throws AnalyzerException {
            return value;
        }

        @Override
        public Value ternaryOperation(AbstractInsnNode node, Value value1, Value value2, Value value3) throws AnalyzerException {
            if (value1 == RECYCLED || value2 == RECYCLED || value3 == RECYCLED) {
                return RECYCLED;
            }
            if (value1 == INSTANCE || value2 == INSTANCE || value3 == INSTANCE) {
                return INSTANCE;
            }
            return UNKNOWN;
        }

        @Override
        public void returnOperation(AbstractInsnNode node, Value value1, Value value2) throws AnalyzerException {
            if (value1 == INSTANCE || value2 == INSTANCE) {
                this.mEscapes = true;
            }
        }

        @Override
        public Value merge(Value value1, Value value2) {
            if (value1 == RECYCLED || value2 == RECYCLED) {
                return RECYCLED;
            }
            if (value1 == INSTANCE || value2 == INSTANCE) {
                return INSTANCE;
            }
            return UNKNOWN;
        }
    }
}

