/*
 * Decompiled with CFR 0.152.
 */
package com.android.chimpchat;

import com.android.chimpchat.adb.AdbBackend;
import com.android.chimpchat.core.IChimpBackend;
import com.android.chimpchat.core.IChimpDevice;
import java.util.Map;
import java.util.TreeMap;

public class ChimpChat {
    private final IChimpBackend mBackend;
    private static String sAdbLocation;
    private static boolean sNoInitAdb;

    private ChimpChat(IChimpBackend backend) {
        this.mBackend = backend;
    }

    public static ChimpChat getInstance(Map<String, String> options) {
        sAdbLocation = options.get("adbLocation");
        sNoInitAdb = Boolean.valueOf(options.get("noInitAdb"));
        IChimpBackend backend = ChimpChat.createBackendByName(options.get("backend"));
        if (backend == null) {
            return null;
        }
        ChimpChat chimpchat = new ChimpChat(backend);
        return chimpchat;
    }

    public static ChimpChat getInstance() {
        TreeMap<String, String> options = new TreeMap<String, String>();
        options.put("backend", "adb");
        return ChimpChat.getInstance(options);
    }

    private static IChimpBackend createBackendByName(String backendName) {
        if ("adb".equals(backendName)) {
            return new AdbBackend(sAdbLocation, sNoInitAdb);
        }
        return null;
    }

    public IChimpDevice waitForConnection(long timeoutMs, String deviceId) {
        return this.mBackend.waitForConnection(timeoutMs, deviceId);
    }

    public IChimpDevice waitForConnection() {
        return this.mBackend.waitForConnection(Integer.MAX_VALUE, ".*");
    }

    public void shutdown() {
        this.mBackend.shutdown();
    }
}

