/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.widgets;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;

public class ImageCanvas
extends Canvas {
    private static final int SCROLLBAR_INCREMENT = 20;
    private Point mOrigin = new Point(0, 0);
    private ScrollBar mHorizontalScrollBar = this.getHorizontalBar();
    private ScrollBar mVerticalScrollBar = this.getVerticalBar();
    private Image mImage;
    private boolean mFitToCanvas = true;

    public ImageCanvas(Composite composite) {
        super(composite, 262912);
        this.setScrollBarIncrements();
        this.setScrollBarPageIncrements(this.getClientArea());
        this.updateScrollBars();
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.getSource() == ImageCanvas.this.mHorizontalScrollBar) {
                    ImageCanvas.this.scrollHorizontally();
                } else {
                    ImageCanvas.this.scrollVertically();
                }
            }
        };
        this.mHorizontalScrollBar.addSelectionListener((SelectionListener)selectionAdapter);
        this.mVerticalScrollBar.addSelectionListener((SelectionListener)selectionAdapter);
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                ImageCanvas.this.setScrollBarPageIncrements(ImageCanvas.this.getClientArea());
                ImageCanvas.this.updateScrollBars();
            }
        });
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                ImageCanvas.this.paintCanvas(event.gc);
            }
        });
    }

    public void setFitToCanvas(boolean bl) {
        this.mFitToCanvas = bl;
        this.updateScrollBars();
        this.redraw();
    }

    public void setImage(Image image) {
        if (this.mImage != null) {
            this.mImage.dispose();
        }
        this.mImage = image;
        this.mOrigin = new Point(0, 0);
        this.updateScrollBars();
        this.redraw();
    }

    private void updateScrollBars() {
        int n;
        int n2;
        Rectangle rectangle = this.getClientArea();
        if (this.mImage != null & !this.mFitToCanvas) {
            n2 = this.mImage.getBounds().width;
            n = this.mImage.getBounds().height;
        } else {
            n2 = rectangle.width;
            n = rectangle.height;
        }
        this.mHorizontalScrollBar.setMaximum(n2);
        this.mVerticalScrollBar.setMaximum(n);
        this.mHorizontalScrollBar.setThumb(Math.min(n2, rectangle.width));
        this.mVerticalScrollBar.setThumb(Math.min(n, rectangle.height));
        int n3 = n2 - rectangle.width;
        int n4 = n - rectangle.height;
        int n5 = this.mHorizontalScrollBar.getSelection();
        int n6 = this.mVerticalScrollBar.getSelection();
        if (n5 >= n3) {
            if (n3 <= 0) {
                n5 = 0;
            }
            this.mOrigin.x = -n5;
        }
        if (n6 >= n4) {
            if (n4 <= 0) {
                n6 = 0;
            }
            this.mOrigin.y = -n6;
        }
        this.redraw();
    }

    private void setScrollBarPageIncrements(Rectangle rectangle) {
        this.mHorizontalScrollBar.setPageIncrement(rectangle.width);
        this.mVerticalScrollBar.setPageIncrement(rectangle.height);
    }

    private void setScrollBarIncrements() {
        this.mHorizontalScrollBar.setIncrement(20);
        this.mVerticalScrollBar.setIncrement(20);
    }

    private void scrollHorizontally() {
        if (this.mImage == null) {
            return;
        }
        int n = this.mHorizontalScrollBar.getSelection();
        int n2 = -n - this.mOrigin.x;
        Rectangle rectangle = this.mImage.getBounds();
        this.scroll(n2, 0, 0, 0, rectangle.width, rectangle.height, false);
        this.mOrigin.x = -n;
    }

    private void scrollVertically() {
        if (this.mImage == null) {
            return;
        }
        int n = this.mVerticalScrollBar.getSelection();
        int n2 = -n - this.mOrigin.y;
        Rectangle rectangle = this.mImage.getBounds();
        this.scroll(0, n2, 0, 0, rectangle.width, rectangle.height, false);
        this.mOrigin.y = -n;
    }

    private void paintCanvas(GC gC) {
        gC.fillRectangle(this.getClientArea());
        if (this.mImage == null) {
            return;
        }
        Rectangle rectangle = this.mImage.getBounds();
        Rectangle rectangle2 = this.getClientArea();
        if (this.mFitToCanvas && rectangle.width > 0 && rectangle.height > 0) {
            double d = (double)rectangle2.width / (double)rectangle.width;
            double d2 = (double)rectangle2.height / (double)rectangle.height;
            if (d < d2) {
                gC.drawImage(this.mImage, 0, 0, rectangle.width, rectangle.height, 0, 0, rectangle2.width, (int)((double)rectangle.height * d));
                this.drawBorder(gC, 0, 0, rectangle2.width, (int)((double)rectangle.height * d));
            } else {
                gC.drawImage(this.mImage, 0, 0, rectangle.width, rectangle.height, 0, 0, (int)((double)rectangle.width * d2), rectangle2.height);
                this.drawBorder(gC, 0, 0, (int)((double)rectangle.width * d2), rectangle2.height);
            }
        } else {
            gC.drawImage(this.mImage, this.mOrigin.x, this.mOrigin.y);
            this.drawBorder(gC, this.mOrigin.x, this.mOrigin.y, rectangle.width, rectangle.height);
        }
    }

    private void drawBorder(GC gC, int n, int n2, int n3, int n4) {
        Color color = gC.getForeground();
        gC.setForeground(Display.getDefault().getSystemColor(18));
        gC.drawRectangle(n, n2, n3, n4);
        gC.setForeground(color);
    }

    public void dispose() {
        if (this.mImage != null && !this.mImage.isDisposed()) {
            this.mImage.dispose();
        }
    }

    public void exportImageTo(File file) {
        if (this.mImage == null || file == null) {
            return;
        }
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{this.mImage.getImageData()};
        try {
            imageLoader.save(file.getAbsolutePath(), 5);
        }
        catch (Exception exception) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"Save Image", (String)"Error saving image", (IStatus)new Status(4, "com.android.ide.eclipse.gldebugger", exception.toString()));
        }
    }
}

