/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.editors;

import com.android.ide.eclipse.gltrace.GlTracePlugin;
import com.android.ide.eclipse.gltrace.editors.GLCallGroups;
import com.android.ide.eclipse.gltrace.editors.GLFunctionTraceViewer;
import com.android.ide.eclipse.gltrace.editors.StateContentProvider;
import com.android.ide.eclipse.gltrace.editors.StateLabelProvider;
import com.android.ide.eclipse.gltrace.model.GLCall;
import com.android.ide.eclipse.gltrace.model.GLTrace;
import com.android.ide.eclipse.gltrace.state.GLState;
import com.android.ide.eclipse.gltrace.state.IGLProperty;
import com.android.ide.eclipse.gltrace.state.StatePrettyPrinter;
import com.android.ide.eclipse.gltrace.state.transforms.IStateTransform;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;

public class StateViewPage
extends Page
implements ISelectionListener,
ISelectionProvider {
    public static final String ID = "com.android.ide.eclipse.gltrace.views.GLState";
    private static String sLastUsedPath;
    private static final ILock sGlStateLock;
    private GLTrace mTrace;
    private List<GLCall> mGLCalls;
    private IGLProperty mState;
    private int mCurrentStateIndex;
    private String[] TREE_PROPERTIES = new String[]{"Name", "Value"};
    private TreeViewer mTreeViewer;
    private StateLabelProvider mLabelProvider;

    static {
        sGlStateLock = Job.getJobManager().newLock();
    }

    public StateViewPage(GLTrace gLTrace) {
        this.setInput(gLTrace);
    }

    public void setInput(GLTrace gLTrace) {
        this.mTrace = gLTrace;
        this.mGLCalls = gLTrace != null ? gLTrace.getGLCalls() : null;
        this.mState = GLState.createDefaultState();
        this.mCurrentStateIndex = -1;
        if (this.mTreeViewer != null) {
            this.mTreeViewer.setInput((Object)this.mState);
            this.mTreeViewer.refresh();
        }
    }

    public void createControl(Composite composite) {
        Tree tree = new Tree(composite, 0x10000300);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tree);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        tree.setLayoutData((Object)new GridData(1808));
        TreeColumn treeColumn = new TreeColumn(tree, 16384);
        treeColumn.setText(this.TREE_PROPERTIES[0]);
        treeColumn.setWidth(200);
        TreeColumn treeColumn2 = new TreeColumn(tree, 16384);
        treeColumn2.setText(this.TREE_PROPERTIES[1]);
        treeColumn2.setWidth(200);
        this.mTreeViewer = new TreeViewer(tree);
        this.mTreeViewer.setContentProvider((IContentProvider)new StateContentProvider());
        this.mLabelProvider = new StateLabelProvider();
        this.mTreeViewer.setLabelProvider((IBaseLabelProvider)this.mLabelProvider);
        this.mTreeViewer.setInput((Object)this.mState);
        this.mTreeViewer.refresh();
        IToolBarManager iToolBarManager = this.getSite().getActionBars().getToolBarManager();
        iToolBarManager.add((IAction)new Action("Save to File", PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_SAVEAS_EDIT")){

            public void run() {
                StateViewPage.this.saveCurrentState();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCurrentState() {
        String string;
        Shell shell = this.mTreeViewer.getTree().getShell();
        FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setFilterExtensions(new String[]{"*.txt"});
        if (sLastUsedPath != null) {
            fileDialog.setFilterPath(sLastUsedPath);
        }
        if ((string = fileDialog.open()) == null) {
            return;
        }
        File file = new File(string);
        sLastUsedPath = file.getParent();
        StatePrettyPrinter statePrettyPrinter = new StatePrettyPrinter();
        ILock iLock = sGlStateLock;
        synchronized (iLock) {
            this.mState.prettyPrint(statePrettyPrinter);
        }
        try {
            Files.write((CharSequence)statePrettyPrinter.toString(), (File)file, (Charset)Charsets.UTF_8);
        }
        catch (IOException iOException) {
            ErrorDialog.openError((Shell)shell, (String)"Export GL State", (String)"Unexpected error while writing GL state to file.", (IStatus)new Status(4, "com.android.ide.eclipse.gldebugger", iOException.toString()));
        }
    }

    public void init(IPageSite iPageSite) {
        super.init(iPageSite);
        iPageSite.getPage().addSelectionListener((ISelectionListener)this);
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (!(iWorkbenchPart instanceof GLFunctionTraceViewer)) {
            return;
        }
        if (((GLFunctionTraceViewer)iWorkbenchPart).getTrace() != this.mTrace) {
            return;
        }
        if (!(iSelection instanceof TreeSelection)) {
            return;
        }
        GLCall gLCall = null;
        Object object = ((TreeSelection)iSelection).getFirstElement();
        if (object instanceof GLCallGroups.GLCallNode) {
            gLCall = ((GLCallGroups.GLCallNode)object).getCall();
        }
        if (gLCall == null) {
            return;
        }
        final int n = gLCall.getIndex();
        Job job = new Job("Updating GL State"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                Set set = null;
                try {
                    try {
                        sGlStateLock.acquire();
                        set = StateViewPage.this.updateState(StateViewPage.this.mCurrentStateIndex, n);
                        StateViewPage.this.mCurrentStateIndex = n;
                    }
                    catch (Exception exception) {
                        GlTracePlugin.getDefault().logMessage("Unexpected error while updating GL State.");
                        GlTracePlugin.getDefault().logMessage(exception.getMessage());
                        Status status = new Status(4, "com.android.ide.eclipse.gldebugger", "Unexpected error while updating GL State.", (Throwable)exception);
                        sGlStateLock.release();
                        return status;
                    }
                }
                finally {
                    sGlStateLock.release();
                }
                StateViewPage.this.mLabelProvider.setChangedProperties(set);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!StateViewPage.this.mTreeViewer.getTree().isDisposed()) {
                            StateViewPage.this.mTreeViewer.refresh();
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.schedule();
    }

    public Control getControl() {
        if (this.mTreeViewer == null) {
            return null;
        }
        return this.mTreeViewer.getControl();
    }

    public void setFocus() {
    }

    private Set<IGLProperty> updateState(int n, int n2) {
        assert (n >= -1 && n < this.mGLCalls.size());
        assert (n2 >= 0 && n2 < this.mGLCalls.size());
        if (n < n2) {
            return this.applyTransformations(n, n2);
        }
        if (n > n2) {
            return this.revertTransformations(n, n2);
        }
        return Collections.emptySet();
    }

    private Set<IGLProperty> applyTransformations(int n, int n2) {
        int n3 = 3 * (n2 - n) + 10;
        HashSet<IGLProperty> hashSet = new HashSet<IGLProperty>(n3);
        int n4 = n + 1;
        while (n4 <= n2) {
            GLCall gLCall = this.mGLCalls.get(n4);
            for (IStateTransform iStateTransform : gLCall.getStateTransformations()) {
                try {
                    iStateTransform.apply(this.mState);
                    IGLProperty iGLProperty = iStateTransform.getChangedProperty(this.mState);
                    if (iGLProperty == null) continue;
                    hashSet.addAll(this.getHierarchy(iGLProperty));
                }
                catch (Exception exception) {
                    GlTracePlugin.getDefault().logMessage("Error applying transformations for " + gLCall);
                    GlTracePlugin.getDefault().logMessage(exception.toString());
                }
            }
            ++n4;
        }
        return hashSet;
    }

    private Set<IGLProperty> revertTransformations(int n, int n2) {
        int n3 = 3 * (n - n2) + 10;
        HashSet<IGLProperty> hashSet = new HashSet<IGLProperty>(n3);
        int n4 = n;
        while (n4 > n2) {
            List<IStateTransform> list = this.mGLCalls.get(n4).getStateTransformations();
            int n5 = list.size() - 1;
            while (n5 >= 0) {
                IStateTransform iStateTransform = list.get(n5);
                iStateTransform.revert(this.mState);
                IGLProperty iGLProperty = iStateTransform.getChangedProperty(this.mState);
                if (iGLProperty != null) {
                    hashSet.addAll(this.getHierarchy(iGLProperty));
                }
                --n5;
            }
            --n4;
        }
        return hashSet;
    }

    private List<IGLProperty> getHierarchy(IGLProperty iGLProperty) {
        ArrayList<IGLProperty> arrayList = new ArrayList<IGLProperty>(5);
        arrayList.add(iGLProperty);
        IGLProperty iGLProperty2 = iGLProperty;
        while ((iGLProperty2 = iGLProperty2.getParent()) != null) {
            arrayList.add(iGLProperty2);
        }
        return arrayList;
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.mTreeViewer.addSelectionChangedListener(iSelectionChangedListener);
    }

    public ISelection getSelection() {
        return this.mTreeViewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.mTreeViewer.removeSelectionChangedListener(iSelectionChangedListener);
    }

    public void setSelection(ISelection iSelection) {
        this.mTreeViewer.setSelection(iSelection);
    }
}

