/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.widgets;

import com.android.SdkConstants;
import com.android.annotations.Nullable;
import com.android.prefs.AndroidLocation;
import com.android.resources.Density;
import com.android.resources.ScreenSize;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SdkManager;
import com.android.sdklib.devices.Camera;
import com.android.sdklib.devices.CameraLocation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.Software;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.internal.avd.HardwareProperties;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import com.android.sdkuilib.internal.widgets.MessageBoxLog;
import com.android.sdkuilib.ui.GridDialog;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import com.google.common.base.Joiner;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AvdCreationDialog
extends GridDialog {
    private AvdManager mAvdManager;
    private ImageFactory mImageFactory;
    private ILogger mSdkLog;
    private AvdInfo mAvdInfo;
    private boolean mHaveSystemImage;
    private final TreeMap<String, IAndroidTarget> mCurrentTargets = new TreeMap();
    private Button mOkButton;
    private Text mAvdName;
    private Combo mDevice;
    private Combo mTarget;
    private Combo mAbi;
    private Button mKeyboard;
    private Button mSkin;
    private Combo mFrontCamera;
    private Combo mBackCamera;
    private Button mSnapshot;
    private Button mGpuEmulation;
    private Text mRam;
    private Text mVmHeap;
    private Text mDataPartition;
    private Combo mDataPartitionSize;
    private Button mSdCardSizeRadio;
    private Text mSdCardSize;
    private Combo mSdCardSizeCombo;
    private Button mSdCardFileRadio;
    private Text mSdCardFile;
    private Button mBrowseSdCard;
    private Button mForceCreation;
    private Composite mStatusComposite;
    private Label mStatusIcon;
    private Label mStatusLabel;
    private Device mInitWithDevice;
    private AvdInfo mCreatedAvd;
    private final VerifyListener mDigitVerifier = new VerifyListener(){

        public void verifyText(VerifyEvent event) {
            int count = event.text.length();
            for (int i = 0; i < count; ++i) {
                char c = event.text.charAt(i);
                if (c >= '0' && c <= '9') continue;
                event.doit = false;
                return;
            }
        }
    };
    private static final String NEXUS = "Nexus";
    private static final String GENERIC = "Generic";
    private static Pattern PATTERN = Pattern.compile("(\\d+\\.?\\d*)in (.+?)( \\(.*Nexus.*\\))?");

    public AvdCreationDialog(Shell shell, AvdManager avdManager, ImageFactory imageFactory, ILogger log, AvdInfo editAvdInfo) {
        super(shell, 2, false);
        this.mAvdManager = avdManager;
        this.mImageFactory = imageFactory;
        this.mSdkLog = log;
        this.mAvdInfo = editAvdInfo;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public AvdInfo getCreatedAvd() {
        return this.mCreatedAvd;
    }

    @Override
    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getShell().setText(this.mAvdInfo == null ? "Create new Android Virtual Device (AVD)" : "Edit Android Virtual Device (AVD)");
        this.mOkButton = this.getButton(0);
        if (this.mAvdInfo != null) {
            this.fillExistingAvdInfo(this.mAvdInfo);
        } else if (this.mInitWithDevice != null) {
            this.fillInitialDeviceInfo(this.mInitWithDevice);
        }
        this.validatePage();
        return control;
    }

    @Override
    public void createDialogContent(Composite parent) {
        ValidateListener validateListener = new ValidateListener();
        Label label = new Label(parent, 0);
        label.setText("AVD Name:");
        String tooltip = "The name of the Android Virtual Device";
        label.setToolTipText(tooltip);
        this.mAvdName = new Text(parent, 2048);
        this.mAvdName.setLayoutData((Object)new GridData(768));
        this.mAvdName.addModifyListener((ModifyListener)new CreateNameModifyListener());
        label = new Label(parent, 0);
        label.setText("Device:");
        tooltip = "The device this AVD will be based on";
        this.mDevice = new Combo(parent, 12);
        this.mDevice.setLayoutData((Object)new GridData(768));
        this.initializeDevices();
        this.mDevice.addSelectionListener((SelectionListener)new DeviceSelectionListener());
        label = new Label(parent, 0);
        label.setText("Target:");
        tooltip = "The target API of the AVD";
        label.setToolTipText(tooltip);
        this.mTarget = new Combo(parent, 12);
        this.mTarget.setLayoutData((Object)new GridData(768));
        this.mTarget.setToolTipText(tooltip);
        this.mTarget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvdCreationDialog.this.reloadAbiTypeCombo();
                AvdCreationDialog.this.validatePage();
            }
        });
        this.reloadTargetCombo();
        label = new Label(parent, 0);
        label.setText("CPU/ABI:");
        tooltip = "The CPU/ABI of the virtual device";
        label.setToolTipText(tooltip);
        this.mAbi = new Combo(parent, 12);
        this.mAbi.setLayoutData((Object)new GridData(768));
        this.mAbi.setToolTipText(tooltip);
        this.mAbi.addSelectionListener((SelectionListener)validateListener);
        label = new Label(parent, 0);
        label.setText("Keyboard:");
        this.mKeyboard = new Button(parent, 32);
        this.mKeyboard.setSelection(true);
        this.mKeyboard.setLayoutData((Object)new GridData(768));
        this.mKeyboard.setText("Hardware keyboard present");
        label = new Label(parent, 0);
        label.setText("Skin:");
        this.mSkin = new Button(parent, 32);
        this.mSkin.setSelection(true);
        this.mSkin.setLayoutData((Object)new GridData(768));
        this.mSkin.setText("Display a skin with hardware controls");
        label = new Label(parent, 0);
        label.setText("Front Camera:");
        tooltip = "";
        label.setToolTipText(tooltip);
        this.mFrontCamera = new Combo(parent, 12);
        this.mFrontCamera.setLayoutData((Object)new GridData(768));
        this.mFrontCamera.add("None");
        this.mFrontCamera.add("Emulated");
        this.mFrontCamera.add("Webcam0");
        this.mFrontCamera.select(0);
        label = new Label(parent, 0);
        label.setText("Back Camera:");
        tooltip = "";
        label.setToolTipText(tooltip);
        this.mBackCamera = new Combo(parent, 12);
        this.mBackCamera.setLayoutData((Object)new GridData(768));
        this.mBackCamera.add("None");
        this.mBackCamera.add("Emulated");
        this.mBackCamera.add("Webcam0");
        this.mBackCamera.select(0);
        this.toggleCameras();
        label = new Label(parent, 0);
        label.setText("Memory Options:");
        Group memoryGroup = new Group(parent, 2048);
        memoryGroup.setLayoutData((Object)new GridData(768));
        memoryGroup.setLayout((Layout)new GridLayout(4, false));
        label = new Label((Composite)memoryGroup, 0);
        label.setText("RAM:");
        tooltip = "The amount of RAM the emulated device should have in MiB";
        label.setToolTipText(tooltip);
        this.mRam = new Text((Composite)memoryGroup, 2048);
        this.mRam.addVerifyListener(this.mDigitVerifier);
        this.mRam.addModifyListener((ModifyListener)validateListener);
        this.mRam.setLayoutData((Object)new GridData(768));
        label = new Label((Composite)memoryGroup, 0);
        label.setText("VM Heap:");
        tooltip = "The amount of memory, in MiB, available to typical Android applications";
        label.setToolTipText(tooltip);
        this.mVmHeap = new Text((Composite)memoryGroup, 2048);
        this.mVmHeap.addVerifyListener(this.mDigitVerifier);
        this.mVmHeap.addModifyListener((ModifyListener)validateListener);
        this.mVmHeap.setLayoutData((Object)new GridData(768));
        this.mVmHeap.setToolTipText(tooltip);
        label = new Label(parent, 0);
        label.setText("Internal Storage:");
        tooltip = "The size of the data partition on the device.";
        Group storageGroup = new Group(parent, 0);
        storageGroup.setLayoutData((Object)new GridData(768));
        storageGroup.setLayout((Layout)new GridLayout(2, false));
        this.mDataPartition = new Text((Composite)storageGroup, 2048);
        this.mDataPartition.setText("200");
        this.mDataPartition.addVerifyListener(this.mDigitVerifier);
        this.mDataPartition.addModifyListener((ModifyListener)validateListener);
        this.mDataPartition.setLayoutData((Object)new GridData(768));
        this.mDataPartitionSize = new Combo((Composite)storageGroup, 12);
        this.mDataPartitionSize.add("MiB");
        this.mDataPartitionSize.add("GiB");
        this.mDataPartitionSize.select(0);
        this.mDataPartitionSize.addModifyListener((ModifyListener)validateListener);
        label = new Label(parent, 0);
        label.setText("SD Card:");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        Group sdCardGroup = new Group(parent, 0);
        sdCardGroup.setLayoutData((Object)new GridData(768));
        sdCardGroup.setLayout((Layout)new GridLayout(3, false));
        this.mSdCardSizeRadio = new Button((Composite)sdCardGroup, 16);
        this.mSdCardSizeRadio.setText("Size:");
        this.mSdCardSizeRadio.setToolTipText("Create a new SD Card file");
        this.mSdCardSizeRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                boolean sizeMode = AvdCreationDialog.this.mSdCardSizeRadio.getSelection();
                AvdCreationDialog.this.enableSdCardWidgets(sizeMode);
                AvdCreationDialog.this.validatePage();
            }
        });
        this.mSdCardSize = new Text((Composite)sdCardGroup, 2048);
        this.mSdCardSize.setLayoutData((Object)new GridData(768));
        this.mSdCardSize.addVerifyListener(this.mDigitVerifier);
        this.mSdCardSize.addModifyListener((ModifyListener)validateListener);
        this.mSdCardSize.setToolTipText("Size of the new SD Card file (must be at least 9 MiB)");
        this.mSdCardSizeCombo = new Combo((Composite)sdCardGroup, 12);
        this.mSdCardSizeCombo.add("KiB");
        this.mSdCardSizeCombo.add("MiB");
        this.mSdCardSizeCombo.add("GiB");
        this.mSdCardSizeCombo.select(1);
        this.mSdCardSizeCombo.addSelectionListener((SelectionListener)validateListener);
        this.mSdCardFileRadio = new Button((Composite)sdCardGroup, 16);
        this.mSdCardFileRadio.setText("File:");
        this.mSdCardFileRadio.setToolTipText("Use an existing file for the SD Card");
        this.mSdCardFile = new Text((Composite)sdCardGroup, 2048);
        this.mSdCardFile.setLayoutData((Object)new GridData(768));
        this.mSdCardFile.addModifyListener((ModifyListener)validateListener);
        this.mSdCardFile.setToolTipText("File to use for the SD Card");
        this.mBrowseSdCard = new Button((Composite)sdCardGroup, 8);
        this.mBrowseSdCard.setText("Browse...");
        this.mBrowseSdCard.setToolTipText("Select the file to use for the SD Card");
        this.mBrowseSdCard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AvdCreationDialog.this.onBrowseSdCard();
                AvdCreationDialog.this.validatePage();
            }
        });
        this.mSdCardSizeRadio.setSelection(true);
        this.enableSdCardWidgets(true);
        label = new Label(parent, 0);
        label.setText("Emulation Options:");
        Group optionsGroup = new Group(parent, 0);
        optionsGroup.setLayoutData((Object)new GridData(768));
        optionsGroup.setLayout((Layout)new GridLayout(2, true));
        this.mSnapshot = new Button((Composite)optionsGroup, 32);
        this.mSnapshot.setText("Snapshot");
        this.mSnapshot.setToolTipText("Emulator's state will be persisted between emulator executions");
        this.mSnapshot.addSelectionListener((SelectionListener)validateListener);
        this.mGpuEmulation = new Button((Composite)optionsGroup, 32);
        this.mGpuEmulation.setText("Use Host GPU");
        this.mGpuEmulation.setToolTipText("Enable hardware OpenGLES emulation");
        this.mGpuEmulation.addSelectionListener((SelectionListener)validateListener);
        this.mForceCreation = new Button(parent, 32);
        this.mForceCreation.setText("Override the existing AVD with the same name");
        this.mForceCreation.setToolTipText("There's already an AVD with the same name. Check this to delete it and replace it by the new AVD.");
        this.mForceCreation.setLayoutData((Object)new GridData(1, 2, true, false, 2, 1));
        this.mForceCreation.setEnabled(false);
        this.mForceCreation.addSelectionListener((SelectionListener)validateListener);
        label = new Label(parent, 258);
        label.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        this.mStatusComposite = new Composite(parent, 0);
        this.mStatusComposite.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        GridLayout gl = new GridLayout(2, false);
        this.mStatusComposite.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.mStatusIcon = new Label(this.mStatusComposite, 0);
        this.mStatusIcon.setLayoutData((Object)new GridData(1, 1, false, false));
        this.mStatusLabel = new Label(this.mStatusComposite, 64);
        GridData gridData = new GridData(4, 4, true, false, 1, 1);
        gridData.heightHint = 50;
        this.mStatusLabel.setLayoutData((Object)gridData);
        this.mStatusLabel.setText("");
    }

    @Nullable
    private Device getSelectedDevice() {
        int index;
        Device[] devices = (Device[])this.mDevice.getData();
        if (devices != null && (index = this.mDevice.getSelectionIndex()) != -1 && index < devices.length) {
            return devices[index];
        }
        return null;
    }

    private void selectDevice(String manufacturer, String name) {
        Device[] devices = (Device[])this.mDevice.getData();
        if (devices != null) {
            int n = devices.length;
            for (int i = 0; i < n; ++i) {
                Device device = devices[i];
                if (!device.getManufacturer().equals(manufacturer) || !device.getName().equals(name)) continue;
                this.mDevice.select(i);
                break;
            }
        }
    }

    private void selectDevice(Device device) {
        Device[] devices = (Device[])this.mDevice.getData();
        if (devices != null) {
            int n = devices.length;
            for (int i = 0; i < n; ++i) {
                if (!devices[i].equals(device)) continue;
                this.mDevice.select(i);
                break;
            }
        }
    }

    private void initializeDevices() {
        assert (this.mDevice != null);
        SdkManager sdkManager = this.mAvdManager.getSdkManager();
        String location = sdkManager.getLocation();
        if (sdkManager != null && location != null) {
            DeviceManager deviceManager = DeviceManager.createInstance(location, this.mSdkLog);
            List<Device> deviceList = deviceManager.getDevices(7);
            ArrayList<Device> nexus = new ArrayList<Device>(deviceList.size());
            ArrayList<Device> other = new ArrayList<Device>(deviceList.size());
            for (Device device : deviceList) {
                if (AvdCreationDialog.isNexus(device) && !AvdCreationDialog.isGeneric(device)) {
                    nexus.add(device);
                    continue;
                }
                other.add(device);
            }
            Collections.reverse(other);
            Collections.sort(nexus, new Comparator<Device>(){

                @Override
                public int compare(Device device1, Device device2) {
                    return AvdCreationDialog.nexusRank(device2) - AvdCreationDialog.nexusRank(device1);
                }
            });
            ArrayList<Device> all = nexus;
            all.addAll(other);
            Device[] devices = all.toArray(new Device[all.size()]);
            String[] labels = new String[devices.length];
            int n = devices.length;
            for (int i = 0; i < n; ++i) {
                Device device = devices[i];
                labels[i] = AvdCreationDialog.isNexus(device) && !AvdCreationDialog.isGeneric(device) ? AvdCreationDialog.getNexusLabel(device) : AvdCreationDialog.getGenericLabel(device);
            }
            this.mDevice.setData((Object)devices);
            this.mDevice.setItems(labels);
        }
    }

    public void selectInitialDevice(Device device) {
        this.mInitWithDevice = device;
    }

    private void fillDeviceProperties(Device device) {
        Hardware hw = device.getDefaultHardware();
        Long ram = hw.getRam().getSizeAsUnit(Storage.Unit.MiB);
        this.mRam.setText(Long.toString(ram));
        Screen s = hw.getScreen();
        ScreenSize size = s.getSize();
        Density density = s.getPixelDensity();
        int vmHeapSize = 32;
        if (size.equals((Object)ScreenSize.XLARGE)) {
            switch (density) {
                case LOW: 
                case MEDIUM: {
                    vmHeapSize = 32;
                    break;
                }
                case TV: 
                case HIGH: {
                    vmHeapSize = 64;
                    break;
                }
                case XHIGH: 
                case XXHIGH: {
                    vmHeapSize = 128;
                    break;
                }
            }
        } else {
            switch (density) {
                case LOW: 
                case MEDIUM: {
                    vmHeapSize = 16;
                    break;
                }
                case TV: 
                case HIGH: {
                    vmHeapSize = 32;
                    break;
                }
                case XHIGH: 
                case XXHIGH: {
                    vmHeapSize = 64;
                    break;
                }
            }
        }
        this.mVmHeap.setText(Integer.toString(vmHeapSize));
        List<Software> allSoftware = device.getAllSoftware();
        if (allSoftware != null && !allSoftware.isEmpty()) {
            Software first = allSoftware.get(0);
            int min = first.getMinSdkLevel();
            int max = first.getMaxSdkLevel();
            for (int i = 1; i < allSoftware.size(); ++i) {
                min = Math.min(min, first.getMinSdkLevel());
                max = Math.max(max, first.getMaxSdkLevel());
            }
            if (this.mCurrentTargets != null) {
                int bestApiLevel = Integer.MAX_VALUE;
                IAndroidTarget bestTarget = null;
                for (IAndroidTarget target : this.mCurrentTargets.values()) {
                    int apiLevel;
                    if (!target.isPlatform() || (apiLevel = target.getVersion().getApiLevel()) < min || apiLevel > max || bestTarget != null && apiLevel >= bestApiLevel) continue;
                    bestTarget = target;
                    bestApiLevel = apiLevel;
                }
                if (bestTarget != null) {
                    this.selectTarget(bestTarget);
                    this.reloadAbiTypeCombo();
                }
            }
        }
    }

    private void toggleCameras() {
        this.mFrontCamera.setEnabled(false);
        this.mBackCamera.setEnabled(false);
        Device d = this.getSelectedDevice();
        if (d != null) {
            for (Camera c : d.getDefaultHardware().getCameras()) {
                if (CameraLocation.FRONT.equals((Object)c.getLocation())) {
                    this.mFrontCamera.setEnabled(true);
                }
                if (!CameraLocation.BACK.equals((Object)c.getLocation())) continue;
                this.mBackCamera.setEnabled(true);
            }
        }
    }

    private void reloadTargetCombo() {
        String selected = null;
        int index = this.mTarget.getSelectionIndex();
        if (index >= 0) {
            selected = this.mTarget.getItem(index);
        }
        this.mCurrentTargets.clear();
        this.mTarget.removeAll();
        boolean found = false;
        index = -1;
        ArrayList<IAndroidTarget> targetData = new ArrayList<IAndroidTarget>();
        SdkManager sdkManager = this.mAvdManager.getSdkManager();
        if (sdkManager != null) {
            for (IAndroidTarget target : sdkManager.getTargets()) {
                String name = target.isPlatform() ? String.format("%s - API Level %s", target.getName(), target.getVersion().getApiString()) : String.format("%s (%s) - API Level %s", target.getName(), target.getVendor(), target.getVersion().getApiString());
                this.mCurrentTargets.put(name, target);
                this.mTarget.add(name);
                targetData.add(target);
                if (found) continue;
                ++index;
                found = name.equals(selected);
            }
        }
        this.mTarget.setEnabled(this.mCurrentTargets.size() > 0);
        this.mTarget.setData((Object)targetData.toArray(new IAndroidTarget[targetData.size()]));
        if (found) {
            this.mTarget.select(index);
        }
    }

    private void selectTarget(IAndroidTarget target) {
        IAndroidTarget[] targets = (IAndroidTarget[])this.mTarget.getData();
        if (targets != null) {
            for (int i = 0; i < targets.length; ++i) {
                if (target != targets[i]) continue;
                this.mTarget.select(i);
                break;
            }
        }
    }

    @Deprecated
    private IAndroidTarget getSelectedTarget() {
        IAndroidTarget[] targets = (IAndroidTarget[])this.mTarget.getData();
        int index = this.mTarget.getSelectionIndex();
        if (targets != null && index != -1 && index < targets.length) {
            return targets[index];
        }
        return null;
    }

    private void reloadAbiTypeCombo() {
        String selected = null;
        boolean found = false;
        int index = this.mTarget.getSelectionIndex();
        if (index >= 0) {
            String targetName = this.mTarget.getItem(index);
            IAndroidTarget target = this.mCurrentTargets.get(targetName);
            ISystemImage[] systemImages = this.getSystemImages(target);
            this.mAbi.setEnabled(systemImages.length > 1);
            index = this.mAbi.getSelectionIndex();
            if (index >= 0 && this.mAbi.getItemCount() > 1) {
                selected = this.mAbi.getItem(index);
            }
            this.mAbi.removeAll();
            for (int i = 0; i < systemImages.length; ++i) {
                String prettyAbiType = AvdInfo.getPrettyAbiType(systemImages[i].getAbiType());
                this.mAbi.add(prettyAbiType);
                if (found || !(found = prettyAbiType.equals(selected))) continue;
                this.mAbi.select(i);
            }
            boolean bl = this.mHaveSystemImage = systemImages.length > 0;
            if (!this.mHaveSystemImage) {
                this.mAbi.add("No system images installed for this target.");
                this.mAbi.select(0);
            } else if (systemImages.length == 1) {
                this.mAbi.select(0);
            }
        }
    }

    private void enableSdCardWidgets(boolean sizeMode) {
        this.mSdCardSize.setEnabled(sizeMode);
        this.mSdCardSizeCombo.setEnabled(sizeMode);
        this.mSdCardFile.setEnabled(!sizeMode);
        this.mBrowseSdCard.setEnabled(!sizeMode);
    }

    private void onBrowseSdCard() {
        FileDialog dlg = new FileDialog(this.getContents().getShell(), 4096);
        dlg.setText("Choose SD Card image file.");
        String fileName = dlg.open();
        if (fileName != null) {
            this.mSdCardFile.setText(fileName);
        }
    }

    @Override
    public void okPressed() {
        if (this.createAvd()) {
            super.okPressed();
        }
    }

    private void validatePage() {
        String abiType;
        ISystemImage[] sis;
        String error = null;
        ArrayList<String> warnings = new ArrayList<String>();
        boolean valid = true;
        if (this.mAvdName.getText().isEmpty()) {
            error = "AVD Name cannot be empty";
            this.setPageValid(false, error, null);
            return;
        }
        String avdName = this.mAvdName.getText();
        if (!AvdManager.RE_AVD_NAME.matcher(avdName).matches()) {
            error = String.format("AVD name '%1$s' contains invalid characters.\nAllowed characters are: %2$s", avdName, "a-z A-Z 0-9 . _ -");
            this.setPageValid(false, error, null);
            return;
        }
        if (this.mDevice.getSelectionIndex() < 0) {
            error = "No device selected";
            this.setPageValid(false, error, null);
            return;
        }
        if (this.mTarget.getSelectionIndex() < 0 || !this.mHaveSystemImage || this.mAbi.getSelectionIndex() < 0) {
            error = "No target selected";
            this.setPageValid(false, error, null);
            return;
        }
        String targetName = this.mTarget.getItem(this.mTarget.getSelectionIndex());
        IAndroidTarget target = this.mCurrentTargets.get(targetName);
        if (target != null && !target.isPlatform() && (sis = target.getSystemImages()) != null && sis.length > 0 && (abiType = this.getSelectedAbiType(target)) != null && !abiType.isEmpty() && target.getParent().getSystemImage(abiType) == null) {
            warnings.add(String.format("This AVD may not work unless you install the %1$s system image for %2$s (%3$s) first.", abiType, target.getParent().getName(), target.getParent().getVersion().toString()));
        }
        if (this.mRam.getText().isEmpty()) {
            error = "Mising RAM value";
            this.setPageValid(false, error, null);
            return;
        }
        if (this.mVmHeap.getText().isEmpty()) {
            error = "Mising VM Heap value";
            this.setPageValid(false, error, null);
            return;
        }
        if (this.mDataPartition.getText().isEmpty() || this.mDataPartitionSize.getSelectionIndex() < 0) {
            error = "Invalid Data partition size.";
            this.setPageValid(false, error, null);
            return;
        }
        if (this.mSdCardSizeRadio.getSelection()) {
            if (!this.mSdCardSize.getText().isEmpty() && this.mSdCardSizeCombo.getSelectionIndex() >= 0) {
                try {
                    long sdSize = Long.parseLong(this.mSdCardSize.getText());
                    int sizeIndex = this.mSdCardSizeCombo.getSelectionIndex();
                    if (sizeIndex >= 0) {
                        sdSize <<= 10 * (1 + sizeIndex);
                    }
                    if (sdSize < 0x900000L || sdSize > 0xFFC0000000L) {
                        valid = false;
                        error = "SD Card size is invalid. Range is 9 MiB..1023 GiB.";
                    }
                }
                catch (NumberFormatException e) {
                    valid = false;
                    error = " SD Card size must be a valid integer between 9 MiB and 1023 GiB";
                }
            }
        } else if (this.mSdCardFile.getText().isEmpty() || !new File(this.mSdCardFile.getText()).isFile()) {
            valid = false;
            error = "SD Card path isn't valid.";
        }
        if (!valid) {
            this.setPageValid(valid, error, null);
            return;
        }
        if (this.mForceCreation.isEnabled() && !this.mForceCreation.getSelection()) {
            valid = false;
            error = String.format("The AVD name '%s' is already used.\nCheck \"Override the existing AVD\" to delete the existing one.", this.mAvdName.getText());
        }
        if (this.mAvdInfo != null && !this.mAvdInfo.getName().equals(this.mAvdName.getText())) {
            warnings.add(String.format("The AVD '%1$s' will be duplicated into '%2$s'.", this.mAvdInfo.getName(), this.mAvdName.getText()));
        }
        if (SdkConstants.CURRENT_PLATFORM == 2) {
            long ramSize = 0L;
            try {
                ramSize = Long.parseLong(this.mRam.getText());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (ramSize > 768L) {
                warnings.add("On Windows, emulating RAM greater than 768M may fail depending on the system load. Try progressively smaller values of RAM if the emulator fails to launch.");
            }
        }
        if (this.mGpuEmulation.getSelection() && this.mSnapshot.getSelection()) {
            valid = false;
            error = "GPU Emulation and Snapshot cannot be used simultaneously";
        }
        String warning = Joiner.on((char)'\n').join(warnings);
        this.setPageValid(valid, error, warning);
    }

    private void setPageValid(boolean valid, String error, String warning) {
        this.mOkButton.setEnabled(valid);
        if (error != null && !error.isEmpty()) {
            this.mStatusIcon.setImage(this.mImageFactory.getImageByName("reject_icon16.png"));
            this.mStatusLabel.setText(error);
        } else if (warning != null && !warning.isEmpty()) {
            this.mStatusIcon.setImage(this.mImageFactory.getImageByName("warning_icon16.png"));
            this.mStatusLabel.setText(warning);
        } else {
            this.mStatusIcon.setImage(null);
            this.mStatusLabel.setText(" \n ");
        }
        this.mStatusComposite.pack(true);
        this.getShell().layout(true, true);
    }

    private boolean createAvd() {
        boolean success;
        AvdInfo avdInfo;
        String suffix;
        String avdName = this.mAvdName.getText();
        if (avdName == null || avdName.isEmpty()) {
            return false;
        }
        String targetName = this.mTarget.getItem(this.mTarget.getSelectionIndex());
        IAndroidTarget target = this.mCurrentTargets.get(targetName);
        if (target == null) {
            return false;
        }
        String abiType = this.getSelectedAbiType(target);
        String sdName = null;
        if (this.mSdCardSizeRadio.getSelection()) {
            String value = this.mSdCardSize.getText().trim();
            if (value.length() > 0) {
                sdName = value;
                switch (this.mSdCardSizeCombo.getSelectionIndex()) {
                    case 0: {
                        sdName = sdName + "K";
                        break;
                    }
                    case 1: {
                        sdName = sdName + "M";
                        break;
                    }
                    case 2: {
                        sdName = sdName + "G";
                        break;
                    }
                    default: {
                        assert (false);
                        {
                            break;
                        }
                    }
                }
            }
        } else {
            sdName = this.mSdCardFile.getText().trim();
        }
        Device device = this.getSelectedDevice();
        if (device == null) {
            return false;
        }
        Screen s = device.getDefaultHardware().getScreen();
        String skinName = s.getXDimension() + "x" + s.getYDimension();
        ILogger log = this.mSdkLog;
        if (log == null || log instanceof MessageBoxLog) {
            log = new MessageBoxLog(String.format("Result of creating AVD '%s':", avdName), this.getContents().getDisplay(), false);
        }
        Map<String, String> hwProps = DeviceManager.getHardwareProperties(device);
        if (this.mGpuEmulation.getSelection()) {
            hwProps.put("hw.gpu.enabled", "yes");
        }
        File avdFolder = null;
        try {
            avdFolder = AvdInfo.getDefaultAvdFolder(this.mAvdManager, avdName);
        }
        catch (AndroidLocation.AndroidLocationException e) {
            return false;
        }
        hwProps.put("hw.ramSize", this.mRam.getText());
        hwProps.put("vm.heapSize", this.mVmHeap.getText());
        switch (this.mDataPartitionSize.getSelectionIndex()) {
            case 0: {
                suffix = "M";
                break;
            }
            case 1: {
                suffix = "G";
                break;
            }
            default: {
                suffix = "K";
            }
        }
        hwProps.put("disk.dataPartition.size", this.mDataPartition.getText() + suffix);
        hwProps.put("hw.keyboard", this.mKeyboard.getSelection() ? "yes" : "no");
        hwProps.put("skin.dynamic", this.mSkin.getSelection() ? "yes" : "no");
        if (this.mFrontCamera.isEnabled()) {
            hwProps.put("hw.camera.front", this.mFrontCamera.getText().toLowerCase());
        }
        if (this.mBackCamera.isEnabled()) {
            hwProps.put("hw.camera.back", this.mBackCamera.getText().toLowerCase());
        }
        if (sdName != null) {
            hwProps.put("hw.sdCard", "yes");
        }
        this.mCreatedAvd = avdInfo = this.mAvdManager.createAvd(avdFolder, avdName, target, abiType, skinName, sdName, hwProps, this.mSnapshot.getSelection(), this.mForceCreation.getSelection(), this.mAvdInfo != null, log);
        boolean bl = success = avdInfo != null;
        if (log instanceof MessageBoxLog) {
            ((MessageBoxLog)log).displayResult(success);
        }
        return success;
    }

    private String getSelectedAbiType(IAndroidTarget target) {
        int abiIndex;
        String abiType = "armeabi";
        ISystemImage[] systemImages = this.getSystemImages(target);
        if (systemImages.length > 0 && (abiIndex = this.mAbi.getSelectionIndex()) >= 0) {
            String prettyname = this.mAbi.getItem(abiIndex);
            int firstIndex = prettyname.indexOf("(");
            int lastIndex = prettyname.indexOf(")");
            abiType = prettyname.substring(firstIndex + 1, lastIndex);
        }
        return abiType;
    }

    private void fillExistingAvdInfo(AvdInfo avd) {
        Map<String, String> props;
        this.mAvdName.setText(avd.getName());
        this.selectDevice(avd.getDeviceManufacturer(), avd.getDeviceName());
        this.toggleCameras();
        IAndroidTarget target = avd.getTarget();
        if (target != null && !this.mCurrentTargets.isEmpty()) {
            int n = this.mTarget.getItemCount();
            for (int i = 0; i < n; ++i) {
                if (!target.equals(this.mCurrentTargets.get(this.mTarget.getItem(i)))) continue;
                this.mTarget.select(i);
                this.reloadAbiTypeCombo();
                break;
            }
        }
        ISystemImage[] systemImages = this.getSystemImages(target);
        if (target != null && systemImages.length > 0) {
            this.mAbi.setEnabled(systemImages.length > 1);
            String abiType = AvdInfo.getPrettyAbiType(avd.getAbiType());
            int n = this.mAbi.getItemCount();
            for (int i = 0; i < n; ++i) {
                if (!abiType.equals(this.mAbi.getItem(i))) continue;
                this.mAbi.select(i);
                break;
            }
        }
        if ((props = avd.getProperties()) != null) {
            String[] values;
            long sdcardSize;
            String cameraBack;
            String dataPartitionSize;
            String vmHeapSize;
            String ramSize;
            String gpuEmulation;
            String snapshots = props.get("snapshot.present");
            if (snapshots != null && snapshots.length() > 0) {
                this.mSnapshot.setSelection(snapshots.equals("true"));
            }
            this.mGpuEmulation.setSelection((gpuEmulation = props.get("hw.gpu.enabled")) != null && gpuEmulation.equals(HardwareProperties.BOOLEAN_VALUES[0]));
            String sdcard = props.get("sdcard.path");
            if (sdcard != null && sdcard.length() > 0) {
                this.enableSdCardWidgets(false);
                this.mSdCardSizeRadio.setSelection(false);
                this.mSdCardFileRadio.setSelection(true);
                this.mSdCardFile.setText(sdcard);
            }
            if ((ramSize = props.get("hw.ramSize")) != null) {
                this.mRam.setText(ramSize);
            }
            if ((vmHeapSize = props.get("vm.heapSize")) != null) {
                this.mVmHeap.setText(vmHeapSize);
            }
            if ((dataPartitionSize = props.get("disk.dataPartition.size")) != null) {
                this.mDataPartition.setText(dataPartitionSize.substring(0, dataPartitionSize.length() - 1));
                switch (dataPartitionSize.charAt(dataPartitionSize.length() - 1)) {
                    case 'M': {
                        this.mDataPartitionSize.select(0);
                        break;
                    }
                    case 'G': {
                        this.mDataPartitionSize.select(1);
                        break;
                    }
                    default: {
                        this.mDataPartitionSize.select(-1);
                    }
                }
            }
            this.mKeyboard.setSelection("yes".equalsIgnoreCase(props.get("hw.keyboard")));
            this.mSkin.setSelection("yes".equalsIgnoreCase(props.get("skin.dynamic")));
            String cameraFront = props.get("hw.camera.front");
            if (cameraFront != null) {
                String[] items = this.mFrontCamera.getItems();
                for (int i = 0; i < items.length; ++i) {
                    if (!items[i].toLowerCase().equals(cameraFront)) continue;
                    this.mFrontCamera.select(i);
                    break;
                }
            }
            if ((cameraBack = props.get("hw.camera.back")) != null) {
                String[] items = this.mBackCamera.getItems();
                for (int i = 0; i < items.length; ++i) {
                    if (!items[i].toLowerCase().equals(cameraBack)) continue;
                    this.mBackCamera.select(i);
                    break;
                }
            }
            if ((sdcard = props.get("sdcard.size")) != null && sdcard.length() > 0 && (sdcardSize = AvdManager.parseSdcardSize(sdcard, values = new String[2])) != -2L) {
                this.enableSdCardWidgets(true);
                this.mSdCardFileRadio.setSelection(false);
                this.mSdCardSizeRadio.setSelection(true);
                this.mSdCardSize.setText(values[0]);
                String suffix = values[1];
                int n = this.mSdCardSizeCombo.getItemCount();
                for (int i = 0; i < n; ++i) {
                    if (!this.mSdCardSizeCombo.getItem(i).startsWith(suffix)) continue;
                    this.mSdCardSizeCombo.select(i);
                }
            }
        }
    }

    private void fillInitialDeviceInfo(Device device) {
        String name = device.getManufacturer();
        name = !name.equals(GENERIC) && !name.equals("User") && device.getName().indexOf(name) == -1 ? " by " + name : "";
        name = "AVD for " + device.getName() + name;
        name = name.replaceAll("[^0-9a-zA-Z_-]+", " ").trim().replaceAll("[ _]+", "_");
        this.mAvdName.setText(name);
        this.selectDevice(device);
        this.toggleCameras();
        if (this.mTarget.getItemCount() == 1) {
            this.mTarget.select(0);
            this.reloadAbiTypeCombo();
        }
        this.fillDeviceProperties(device);
    }

    private ISystemImage[] getSystemImages(IAndroidTarget target) {
        if (target != null) {
            ISystemImage[] images = target.getSystemImages();
            if (!(images != null && images.length != 0 || target.isPlatform())) {
                images = target.getParent().getSystemImages();
            }
            if (images != null) {
                return images;
            }
        }
        return new ISystemImage[0];
    }

    private static int nexusRank(Device device) {
        String name = device.getName();
        if (name.endsWith(" One")) {
            return 1;
        }
        if (name.endsWith(" S")) {
            return 2;
        }
        if (name.startsWith("Galaxy")) {
            return 3;
        }
        if (name.endsWith(" 7")) {
            return 4;
        }
        if (name.endsWith(" 10")) {
            return 5;
        }
        if (name.endsWith(" 4")) {
            return 6;
        }
        return 7;
    }

    private static boolean isGeneric(Device device) {
        return device.getManufacturer().equals(GENERIC);
    }

    private static boolean isNexus(Device device) {
        return device.getName().contains(NEXUS);
    }

    private static String getGenericLabel(Device d) {
        Matcher matcher;
        String name = d.getName();
        if (name.equals("3.7 FWVGA slider")) {
            name = "3.7in FWVGA slider";
        }
        if ((matcher = PATTERN.matcher(name)).matches()) {
            String size = matcher.group(1);
            String n = matcher.group(2);
            int dot = size.indexOf(46);
            if (dot == -1) {
                size = size + ".0";
                dot = size.length() - 2;
            }
            for (int i = 0; i < 2 - dot; ++i) {
                size = ' ' + size;
            }
            name = size + "\" " + n;
        }
        return String.format(Locale.US, "%1$s (%2$s)", name, AvdCreationDialog.getResolutionString(d));
    }

    private static String getNexusLabel(Device d) {
        String name = d.getName();
        Screen screen = d.getDefaultHardware().getScreen();
        float length = (float)screen.getDiagonalLength();
        return String.format(Locale.US, "%1$s (%3$s\", %2$s)", name, AvdCreationDialog.getResolutionString(d), Float.toString(length));
    }

    @Nullable
    private static String getResolutionString(Device device) {
        Screen screen = device.getDefaultHardware().getScreen();
        return String.format(Locale.US, "%1$d \u00d7 %2$d: %3$s", screen.getXDimension(), screen.getYDimension(), screen.getPixelDensity().getResourceValue());
    }

    private class DeviceSelectionListener
    extends SelectionAdapter {
        private DeviceSelectionListener() {
        }

        public void widgetSelected(SelectionEvent arg0) {
            Device currentDevice = AvdCreationDialog.this.getSelectedDevice();
            if (currentDevice != null) {
                AvdCreationDialog.this.fillDeviceProperties(currentDevice);
            }
            AvdCreationDialog.this.toggleCameras();
            AvdCreationDialog.this.validatePage();
        }
    }

    private class CreateNameModifyListener
    implements ModifyListener {
        private CreateNameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            String name = AvdCreationDialog.this.mAvdName.getText().trim();
            if (AvdCreationDialog.this.mAvdInfo == null || !name.equals(AvdCreationDialog.this.mAvdInfo.getName())) {
                Pair<AvdManager.AvdConflict, String> conflict = AvdCreationDialog.this.mAvdManager.isAvdNameConflicting(name);
                if (conflict.getFirst() != AvdManager.AvdConflict.NO_CONFLICT) {
                    if (!AvdCreationDialog.this.mForceCreation.isEnabled()) {
                        AvdCreationDialog.this.mForceCreation.setEnabled(true);
                        AvdCreationDialog.this.mForceCreation.setSelection(false);
                    }
                } else {
                    AvdCreationDialog.this.mForceCreation.setEnabled(false);
                    AvdCreationDialog.this.mForceCreation.setSelection(false);
                }
            } else {
                AvdCreationDialog.this.mForceCreation.setEnabled(false);
                AvdCreationDialog.this.mForceCreation.setSelection(false);
            }
            AvdCreationDialog.this.validatePage();
        }
    }

    private class ValidateListener
    extends SelectionAdapter
    implements ModifyListener {
        private ValidateListener() {
        }

        public void modifyText(ModifyEvent e) {
            AvdCreationDialog.this.validatePage();
        }

        public void widgetSelected(SelectionEvent e) {
            super.widgetSelected(e);
            AvdCreationDialog.this.validatePage();
        }
    }
}

