/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.resources.ResourceType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ResourceResolver
extends RenderResources {
    public static final String THEME_NAME = "Theme";
    public static final String THEME_NAME_DOT = "Theme.";
    public static final int MAX_RESOURCE_INDIRECTION = 50;
    private final Map<ResourceType, Map<String, ResourceValue>> mProjectResources;
    private final Map<ResourceType, Map<String, ResourceValue>> mFrameworkResources;
    private final Map<StyleResourceValue, StyleResourceValue> mStyleInheritanceMap = new HashMap<StyleResourceValue, StyleResourceValue>();
    private StyleResourceValue mTheme;
    private RenderResources.FrameworkResourceIdProvider mFrameworkProvider;
    private LayoutLog mLogger;
    private String mThemeName;
    private boolean mIsProjectTheme;

    private ResourceResolver(Map<ResourceType, Map<String, ResourceValue>> projectResources, Map<ResourceType, Map<String, ResourceValue>> frameworkResources) {
        this.mProjectResources = projectResources;
        this.mFrameworkResources = frameworkResources;
    }

    public static ResourceResolver create(Map<ResourceType, Map<String, ResourceValue>> projectResources, Map<ResourceType, Map<String, ResourceValue>> frameworkResources, String themeName, boolean isProjectTheme) {
        ResourceResolver resolver = new ResourceResolver(projectResources, frameworkResources);
        resolver.computeStyleMaps(themeName, isProjectTheme);
        return resolver;
    }

    public String getThemeName() {
        return this.mThemeName;
    }

    public boolean isProjectTheme() {
        return this.mIsProjectTheme;
    }

    public Map<ResourceType, Map<String, ResourceValue>> getProjectResources() {
        return this.mProjectResources;
    }

    public Map<ResourceType, Map<String, ResourceValue>> getFrameworkResources() {
        return this.mFrameworkResources;
    }

    @Override
    public void setFrameworkResourceIdProvider(RenderResources.FrameworkResourceIdProvider provider) {
        this.mFrameworkProvider = provider;
    }

    @Override
    public void setLogger(LayoutLog logger) {
        this.mLogger = logger;
    }

    @Override
    public StyleResourceValue getCurrentTheme() {
        return this.mTheme;
    }

    @Override
    public StyleResourceValue getTheme(String name, boolean frameworkTheme) {
        ResourceValue theme = null;
        if (frameworkTheme) {
            Map<String, ResourceValue> frameworkStyleMap = this.mFrameworkResources.get((Object)ResourceType.STYLE);
            theme = frameworkStyleMap.get(name);
        } else {
            Map<String, ResourceValue> projectStyleMap = this.mProjectResources.get((Object)ResourceType.STYLE);
            theme = projectStyleMap.get(name);
        }
        if (theme instanceof StyleResourceValue) {
            return (StyleResourceValue)theme;
        }
        return null;
    }

    @Override
    public boolean themeIsParentOf(StyleResourceValue parentTheme, StyleResourceValue childTheme) {
        do {
            if ((childTheme = this.mStyleInheritanceMap.get(childTheme)) != null) continue;
            return false;
        } while (childTheme != parentTheme);
        return true;
    }

    @Override
    public ResourceValue getFrameworkResource(ResourceType resourceType, String resourceName) {
        return this.getResource(resourceType, resourceName, this.mFrameworkResources);
    }

    @Override
    public ResourceValue getProjectResource(ResourceType resourceType, String resourceName) {
        return this.getResource(resourceType, resourceName, this.mProjectResources);
    }

    @Override
    @Deprecated
    public ResourceValue findItemInStyle(StyleResourceValue style, String attrName) {
        ResourceValue item = this.findItemInStyle(style, attrName, false);
        if (item == null) {
            item = this.findItemInStyle(style, attrName, true);
        }
        return item;
    }

    @Override
    public ResourceValue findItemInStyle(StyleResourceValue style, String itemName, boolean isFrameworkAttr) {
        StyleResourceValue parentStyle;
        ResourceValue item = style.findValue(itemName, isFrameworkAttr);
        if (item == null && this.mStyleInheritanceMap != null && (parentStyle = this.mStyleInheritanceMap.get(style)) != null) {
            return this.findItemInStyle(parentStyle, itemName, isFrameworkAttr);
        }
        return item;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ResourceValue findResValue(String reference, boolean forceFrameworkOnly) {
        ResourceType type;
        if (reference == null) {
            return null;
        }
        if (reference.startsWith("?") && reference.length() > "?".length()) {
            ResourceValue item;
            if (this.mTheme == null) {
                return null;
            }
            boolean frameworkOnly = false;
            String originalReference = reference;
            if (reference.startsWith("?android:")) {
                frameworkOnly = true;
                reference = reference.substring("?android:".length());
            } else {
                reference = reference.substring("?".length());
            }
            String[] segments = reference.split("/");
            String referenceName = null;
            if (segments.length == 2) {
                if (!ResourceType.ATTR.getName().equals(segments[0])) return null;
                referenceName = segments[1];
            } else {
                referenceName = segments[0];
                if (!Character.isJavaIdentifierStart(referenceName.charAt(0))) {
                    return null;
                }
                int n = referenceName.length();
                for (int i = 1; i < n; ++i) {
                    char c = referenceName.charAt(i);
                    if (Character.isJavaIdentifierPart(c) || c == '.') continue;
                    return null;
                }
            }
            if (referenceName.startsWith("android:")) {
                frameworkOnly = true;
                referenceName = referenceName.substring("android:".length());
            }
            if ((item = this.findItemInStyle(this.mTheme, referenceName, forceFrameworkOnly || frameworkOnly)) != null || this.mLogger == null) return item;
            this.mLogger.warning("resources.resolve.theme", String.format("Couldn't find theme resource %1$s for the current theme", reference), new ResourceValue(ResourceType.ATTR, originalReference, frameworkOnly));
            return item;
        }
        if (!reference.startsWith("@")) return null;
        boolean frameworkOnly = false;
        if ("@null".equals(reference)) {
            return null;
        }
        if (reference.startsWith("@android:")) {
            frameworkOnly = true;
            reference = reference.substring("@android:".length());
        } else {
            reference = reference.substring("@".length());
        }
        String[] segments = reference.split("/");
        if (segments.length != 2) {
            return null;
        }
        String referenceName = segments[1];
        if (referenceName.startsWith("android:")) {
            frameworkOnly = true;
            referenceName = referenceName.substring("android:".length());
        }
        if ((type = ResourceType.getEnum(segments[0])) == null) {
            return null;
        }
        if (!Character.isJavaIdentifierStart(referenceName.charAt(0))) {
            return null;
        }
        int n = referenceName.length();
        for (int i = 1; i < n; ++i) {
            char c = referenceName.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '.') continue;
            return null;
        }
        return this.findResValue(type, referenceName, forceFrameworkOnly ? true : frameworkOnly);
    }

    @Override
    public ResourceValue resolveValue(ResourceType type, String name, String value, boolean isFrameworkValue) {
        if (value == null) {
            return null;
        }
        ResourceValue resValue = this.findResValue(value, isFrameworkValue);
        if (resValue == null) {
            return new ResourceValue(type, name, value, isFrameworkValue);
        }
        return this.resolveResValue(resValue);
    }

    @Override
    public ResourceValue resolveResValue(ResourceValue resValue) {
        return this.resolveResValue(resValue, 0);
    }

    private ResourceValue resolveResValue(ResourceValue resValue, int depth) {
        if (resValue == null) {
            return null;
        }
        String value = resValue.getValue();
        if (value == null) {
            return resValue;
        }
        ResourceValue resolvedResValue = this.findResValue(value, resValue.isFramework());
        if (resolvedResValue == null) {
            return resValue;
        }
        if (resValue == resolvedResValue || depth >= 50) {
            if (this.mLogger != null) {
                this.mLogger.error("broken", String.format("Potential stack overflow trying to resolve '%s': cyclic resource definitions? Render may not be accurate.", value), null);
            }
            return resValue;
        }
        return this.resolveResValue(resolvedResValue, depth + 1);
    }

    private ResourceValue findResValue(ResourceType resType, String resName, boolean frameworkOnly) {
        Map<String, ResourceValue> typeMap;
        ResourceValue item;
        if (!frameworkOnly && (item = (typeMap = this.mProjectResources.get((Object)resType)).get(resName)) != null) {
            return item;
        }
        typeMap = this.mFrameworkResources.get((Object)resType);
        item = typeMap.get(resName);
        if (item != null) {
            return item;
        }
        if (this.mFrameworkProvider != null && resType == ResourceType.ID && this.mFrameworkProvider.getId(resType, resName) != null) {
            return new ResourceValue(resType, resName, true);
        }
        if (this.mLogger != null) {
            this.mLogger.warning("resources.resolve", "Couldn't resolve resource @" + (frameworkOnly ? "android:" : "") + (Object)((Object)resType) + "/" + resName, new ResourceValue(resType, resName, frameworkOnly));
        }
        return null;
    }

    private ResourceValue getResource(ResourceType resourceType, String resourceName, Map<ResourceType, Map<String, ResourceValue>> resourceRepository) {
        ResourceValue item;
        Map<String, ResourceValue> typeMap = resourceRepository.get((Object)resourceType);
        if (typeMap != null && (item = typeMap.get(resourceName)) != null) {
            item = this.resolveResValue(item);
            return item;
        }
        return null;
    }

    private void computeStyleMaps(String themeName, boolean isProjectTheme) {
        this.mThemeName = themeName;
        this.mIsProjectTheme = isProjectTheme;
        Map<String, ResourceValue> projectStyleMap = this.mProjectResources.get((Object)ResourceType.STYLE);
        Map<String, ResourceValue> frameworkStyleMap = this.mFrameworkResources.get((Object)ResourceType.STYLE);
        ResourceValue theme = null;
        if (isProjectTheme) {
            if (projectStyleMap != null) {
                theme = projectStyleMap.get(themeName);
            }
        } else if (frameworkStyleMap != null) {
            theme = frameworkStyleMap.get(themeName);
        }
        if (theme instanceof StyleResourceValue) {
            this.computeStyleInheritance(projectStyleMap.values(), projectStyleMap, frameworkStyleMap);
            if (frameworkStyleMap != null) {
                this.computeStyleInheritance(frameworkStyleMap.values(), null, frameworkStyleMap);
            }
            this.mTheme = (StyleResourceValue)theme;
        }
    }

    private void computeStyleInheritance(Collection<ResourceValue> styles, Map<String, ResourceValue> inProjectStyleMap, Map<String, ResourceValue> inFrameworkStyleMap) {
        for (ResourceValue value : styles) {
            if (!(value instanceof StyleResourceValue)) continue;
            StyleResourceValue style = (StyleResourceValue)value;
            StyleResourceValue parentStyle = null;
            String parentName = style.getParentStyle();
            if (parentName == null) {
                parentName = this.getParentName(value.getName());
            }
            if (parentName == null || (parentStyle = this.getStyle(parentName, inProjectStyleMap, inFrameworkStyleMap)) == null) continue;
            this.mStyleInheritanceMap.put(style, parentStyle);
        }
    }

    private String getParentName(String styleName) {
        int index = styleName.lastIndexOf(46);
        if (index != -1) {
            return styleName.substring(0, index);
        }
        return null;
    }

    private StyleResourceValue getStyle(String parentName, Map<String, ResourceValue> inProjectStyleMap, Map<String, ResourceValue> inFrameworkStyleMap) {
        boolean frameworkOnly = false;
        String name = parentName;
        if (name.startsWith("@")) {
            name = name.substring("@".length());
        }
        if (name.startsWith("android:")) {
            frameworkOnly = true;
            name = name.substring("android:".length());
        }
        if (name.startsWith("style/")) {
            name = name.substring("style/".length());
        } else if (name.indexOf(47) != -1) {
            return null;
        }
        ResourceValue parent = null;
        if (!frameworkOnly && inProjectStyleMap != null) {
            parent = inProjectStyleMap.get(name);
        }
        if (parent == null) {
            if (inFrameworkStyleMap == null) {
                return null;
            }
            parent = inFrameworkStyleMap.get(name);
        }
        if (parent instanceof StyleResourceValue) {
            return (StyleResourceValue)parent;
        }
        if (this.mLogger != null) {
            this.mLogger.error("resources.resolve", String.format("Unable to resolve parent style name: %s", parentName), null);
        }
        return null;
    }

    public boolean isTheme(@NonNull ResourceValue value, @Nullable Map<ResourceValue, Boolean> cache) {
        Boolean known;
        if (cache != null && (known = cache.get(value)) != null) {
            return known;
        }
        if (value instanceof StyleResourceValue) {
            StyleResourceValue srv = (StyleResourceValue)value;
            String name = srv.getName();
            if (name.startsWith(THEME_NAME_DOT) || name.equals(THEME_NAME)) {
                if (cache != null) {
                    cache.put(value, true);
                }
                return true;
            }
            StyleResourceValue parentStyle = this.mStyleInheritanceMap.get(srv);
            if (parentStyle != null) {
                boolean result = this.isTheme(parentStyle, cache);
                if (cache != null) {
                    cache.put(value, result);
                }
                return result;
            }
        }
        return false;
    }
}

