/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.archives;

import com.android.sdklib.internal.repository.IDescription;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.io.FileOp;
import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Properties;

public class Archive
implements IDescription,
Comparable<Archive> {
    private static final String PROP_OS = "Archive.Os";
    private static final String PROP_ARCH = "Archive.Arch";
    private final Os mOs;
    private final Arch mArch;
    private final String mUrl;
    private final long mSize;
    private final String mChecksum;
    private final ChecksumType mChecksumType = ChecksumType.SHA1;
    private final Package mPackage;
    private final String mLocalOsPath;
    private final boolean mIsLocal;

    public Archive(Package pkg, Os os, Arch arch, String url, long size, String checksum) {
        this.mPackage = pkg;
        this.mOs = os;
        this.mArch = arch;
        this.mUrl = url == null ? null : url.trim();
        this.mLocalOsPath = null;
        this.mSize = size;
        this.mChecksum = checksum;
        this.mIsLocal = false;
    }

    public Archive(Package pkg, Properties props, Os os, Arch arch, String localOsPath) {
        this.mPackage = pkg;
        this.mOs = props == null ? os : Os.valueOf(props.getProperty(PROP_OS, os.toString()));
        this.mArch = props == null ? arch : Arch.valueOf(props.getProperty(PROP_ARCH, arch.toString()));
        this.mUrl = null;
        this.mLocalOsPath = localOsPath;
        this.mSize = 0L;
        this.mChecksum = "";
        this.mIsLocal = localOsPath != null;
    }

    void saveProperties(Properties props) {
        props.setProperty(PROP_OS, this.mOs.toString());
        props.setProperty(PROP_ARCH, this.mArch.toString());
    }

    public boolean isLocal() {
        return this.mIsLocal;
    }

    public Package getParentPackage() {
        return this.mPackage;
    }

    public long getSize() {
        return this.mSize;
    }

    public String getChecksum() {
        return this.mChecksum;
    }

    public ChecksumType getChecksumType() {
        return this.mChecksumType;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public String getLocalOsPath() {
        return this.mLocalOsPath;
    }

    public Os getOs() {
        return this.mOs;
    }

    public Arch getArch() {
        return this.mArch;
    }

    public String getOsDescription() {
        String os = this.mOs == null ? "unknown OS" : (this.mOs == Os.ANY ? "any OS" : this.mOs.getUiName());
        String arch = "";
        if (this.mArch != null && this.mArch != Arch.ANY) {
            arch = this.mArch.getUiName();
        }
        return String.format("%1$s%2$s%3$s", os, arch.length() > 0 ? " " : "", arch);
    }

    public String toString() {
        String s = this.getShortDescription();
        if (s != null) {
            return s;
        }
        return super.toString();
    }

    @Override
    public String getShortDescription() {
        return String.format("Archive for %1$s", this.getOsDescription());
    }

    @Override
    public String getLongDescription() {
        return String.format("%1$s\n%2$s\n%3$s", this.getShortDescription(), this.getSizeDescription(), this.getSha1Description());
    }

    public String getSizeDescription() {
        long size = this.getSize();
        String sizeStr = size < 1024L ? String.format("%d Bytes", size) : (size < 0x100000L ? String.format("%d KiB", Math.round((double)size / 1024.0)) : (size < 0x40000000L ? String.format("%.1f MiB", (double)Math.round(10.0 * (double)size / 1048576.0) / 10.0) : String.format("%.1f GiB", (double)Math.round(10.0 * (double)size / 1.073741824E9) / 10.0)));
        return String.format("Size: %1$s", sizeStr);
    }

    public String getSha1Description() {
        return String.format("SHA1: %1$s", this.getChecksum());
    }

    public boolean isCompatible() {
        return this.getOs().isCompatible() && this.getArch().isCompatible();
    }

    public void deleteLocal() {
        if (this.isLocal()) {
            new FileOp().deleteFileOrFolder(new File(this.getLocalOsPath()));
        }
    }

    @Override
    public int compareTo(Archive rhs) {
        if (this.mPackage != null && rhs != null) {
            return this.mPackage.compareTo(rhs.getParentPackage());
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mArch == null ? 0 : this.mArch.hashCode());
        result = 31 * result + (this.mChecksum == null ? 0 : this.mChecksum.hashCode());
        result = 31 * result + (this.mChecksumType == null ? 0 : this.mChecksumType.hashCode());
        result = 31 * result + (this.mIsLocal ? 1231 : 1237);
        result = 31 * result + (this.mLocalOsPath == null ? 0 : this.mLocalOsPath.hashCode());
        result = 31 * result + (this.mOs == null ? 0 : this.mOs.hashCode());
        result = 31 * result + (int)(this.mSize ^ this.mSize >>> 32);
        result = 31 * result + (this.mUrl == null ? 0 : this.mUrl.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Archive)) {
            return false;
        }
        Archive other = (Archive)obj;
        if (this.mArch == null ? other.mArch != null : !this.mArch.equals((Object)other.mArch)) {
            return false;
        }
        if (this.mChecksum == null ? other.mChecksum != null : !this.mChecksum.equals(other.mChecksum)) {
            return false;
        }
        if (this.mChecksumType == null ? other.mChecksumType != null : !this.mChecksumType.equals((Object)other.mChecksumType)) {
            return false;
        }
        if (this.mIsLocal != other.mIsLocal) {
            return false;
        }
        if (this.mLocalOsPath == null ? other.mLocalOsPath != null : !this.mLocalOsPath.equals(other.mLocalOsPath)) {
            return false;
        }
        if (this.mOs == null ? other.mOs != null : !this.mOs.equals((Object)other.mOs)) {
            return false;
        }
        if (this.mSize != other.mSize) {
            return false;
        }
        return !(this.mUrl == null ? other.mUrl != null : !this.mUrl.equals(other.mUrl));
    }

    public static enum Arch {
        ANY("Any"),
        PPC("PowerPC"),
        X86("x86"),
        X86_64("x86_64");

        private final String mUiName;

        private Arch(String uiName) {
            this.mUiName = uiName;
        }

        public String getUiName() {
            return this.mUiName;
        }

        public String getXmlName() {
            return this.toString().toLowerCase(Locale.US);
        }

        public static Arch getCurrentArch() {
            String arch = System.getProperty("os.arch");
            if (arch.equalsIgnoreCase("x86_64") || arch.equalsIgnoreCase("amd64")) {
                return X86_64;
            }
            if (arch.equalsIgnoreCase("x86") || arch.equalsIgnoreCase("i386") || arch.equalsIgnoreCase("i686")) {
                return X86;
            }
            if (arch.equalsIgnoreCase("ppc") || arch.equalsIgnoreCase("PowerPC")) {
                return PPC;
            }
            return null;
        }

        public boolean isCompatible() {
            if (this == ANY) {
                return true;
            }
            Arch arch = Arch.getCurrentArch();
            return this == arch;
        }
    }

    public static enum Os {
        ANY("Any"),
        LINUX("Linux"),
        MACOSX("MacOS X"),
        WINDOWS("Windows");

        private final String mUiName;

        private Os(String uiName) {
            this.mUiName = uiName;
        }

        public String getUiName() {
            return this.mUiName;
        }

        public String getXmlName() {
            return this.toString().toLowerCase(Locale.US);
        }

        public static Os getCurrentOs() {
            String os = System.getProperty("os.name");
            if (os.startsWith("Mac")) {
                return MACOSX;
            }
            if (os.startsWith("Windows")) {
                return WINDOWS;
            }
            if (os.startsWith("Linux")) {
                return LINUX;
            }
            return null;
        }

        public boolean isCompatible() {
            if (this == ANY) {
                return true;
            }
            Os os = Os.getCurrentOs();
            return this == os;
        }
    }

    public static enum ChecksumType {
        SHA1("SHA-1");

        private final String mAlgorithmName;

        private ChecksumType(String algorithmName) {
            this.mAlgorithmName = algorithmName;
        }

        public MessageDigest getMessageDigest() throws NoSuchAlgorithmException {
            return MessageDigest.getInstance(this.mAlgorithmName);
        }
    }
}

