/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.actions;

import com.android.ddmuilib.ImageLoader;
import com.android.hierarchyviewerlib.HierarchyViewerDirector;
import com.android.hierarchyviewerlib.actions.ImageAction;
import com.android.hierarchyviewerlib.device.IHvDevice;
import com.android.hierarchyviewerlib.models.DeviceSelectionModel;
import com.android.hierarchyviewerlib.models.Window;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class LoadViewHierarchyAction
extends Action
implements ImageAction,
DeviceSelectionModel.IWindowChangeListener {
    private static LoadViewHierarchyAction sAction;
    private Image mImage;

    private LoadViewHierarchyAction() {
        super("Load View &Hierarchy");
        this.setAccelerator(SWT.MOD1 + 72);
        ImageLoader imageLoader = ImageLoader.getLoader(HierarchyViewerDirector.class);
        this.mImage = imageLoader.loadImage("load-view-hierarchy.png", Display.getDefault());
        this.setImageDescriptor(ImageDescriptor.createFromImage(this.mImage));
        this.setToolTipText("Load the view hierarchy into the tree view");
        this.setEnabled(DeviceSelectionModel.getModel().getSelectedWindow() != null);
        DeviceSelectionModel.getModel().addWindowChangeListener(this);
    }

    public static LoadViewHierarchyAction getAction() {
        if (sAction == null) {
            sAction = new LoadViewHierarchyAction();
        }
        return sAction;
    }

    @Override
    public void run() {
        HierarchyViewerDirector.getDirector().loadViewHierarchy();
    }

    @Override
    public Image getImage() {
        return this.mImage;
    }

    @Override
    public void deviceChanged(IHvDevice device) {
    }

    @Override
    public void deviceConnected(IHvDevice device) {
    }

    @Override
    public void deviceDisconnected(IHvDevice device) {
    }

    @Override
    public void focusChanged(IHvDevice device) {
    }

    @Override
    public void selectionChanged(IHvDevice device, final Window window) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                LoadViewHierarchyAction.getAction().setEnabled(window != null);
            }
        });
    }
}

