/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs;

import de.waldheinz.fs.FileSystem;
import de.waldheinz.fs.ReadOnlyException;
import java.io.IOException;

public abstract class AbstractFileSystem
implements FileSystem {
    private final boolean readOnly;
    private boolean closed = false;

    public AbstractFileSystem(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed()) {
            if (!this.isReadOnly()) {
                this.flush();
            }
            this.closed = true;
        }
    }

    @Override
    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public final boolean isReadOnly() {
        return this.readOnly;
    }

    protected final void checkClosed() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("file system was already closed");
        }
    }

    protected final void checkReadOnly() throws ReadOnlyException {
        if (this.isReadOnly()) {
            throw new ReadOnlyException();
        }
    }
}

