/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.support;

import lombok.ast.libs.org.parboiled.matchers.ActionMatcher;
import lombok.ast.libs.org.parboiled.matchers.AnyMatcher;
import lombok.ast.libs.org.parboiled.matchers.CharIgnoreCaseMatcher;
import lombok.ast.libs.org.parboiled.matchers.CharMatcher;
import lombok.ast.libs.org.parboiled.matchers.CharRangeMatcher;
import lombok.ast.libs.org.parboiled.matchers.CharSetMatcher;
import lombok.ast.libs.org.parboiled.matchers.CustomMatcher;
import lombok.ast.libs.org.parboiled.matchers.EmptyMatcher;
import lombok.ast.libs.org.parboiled.matchers.FirstOfMatcher;
import lombok.ast.libs.org.parboiled.matchers.Matcher;
import lombok.ast.libs.org.parboiled.matchers.MatcherVisitor;
import lombok.ast.libs.org.parboiled.matchers.OneOrMoreMatcher;
import lombok.ast.libs.org.parboiled.matchers.OptionalMatcher;
import lombok.ast.libs.org.parboiled.matchers.SequenceMatcher;
import lombok.ast.libs.org.parboiled.matchers.TestMatcher;
import lombok.ast.libs.org.parboiled.matchers.TestNotMatcher;
import lombok.ast.libs.org.parboiled.matchers.ZeroOrMoreMatcher;
import lombok.ast.libs.org.parboiled.support.CanMatchEmptyVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsStarterCharVisitor<V>
implements MatcherVisitor<V, Boolean> {
    private final CanMatchEmptyVisitor<V> canMatchEmptyVisitor = new CanMatchEmptyVisitor();
    private final char starterChar;

    public IsStarterCharVisitor(char starterChar) {
        this.starterChar = starterChar;
    }

    @Override
    public Boolean visit(ActionMatcher<V> matcher) {
        return false;
    }

    @Override
    public Boolean visit(AnyMatcher<V> matcher) {
        return this.starterChar != '\uffff';
    }

    @Override
    public Boolean visit(CharIgnoreCaseMatcher<V> matcher) {
        return matcher.charLow == this.starterChar || matcher.charUp == this.starterChar;
    }

    @Override
    public Boolean visit(CharMatcher<V> matcher) {
        return matcher.character == this.starterChar;
    }

    @Override
    public Boolean visit(CharRangeMatcher<V> matcher) {
        return matcher.cLow <= this.starterChar && this.starterChar <= matcher.cHigh;
    }

    @Override
    public Boolean visit(CharSetMatcher<V> matcher) {
        return matcher.characters.contains(this.starterChar);
    }

    @Override
    public Boolean visit(CustomMatcher<V> matcher) {
        return matcher.isStarterChar(this.starterChar);
    }

    @Override
    public Boolean visit(EmptyMatcher<V> matcher) {
        return false;
    }

    @Override
    public Boolean visit(FirstOfMatcher<V> matcher) {
        for (Matcher child : matcher.getChildren()) {
            if (!((Boolean)child.accept(this)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(OneOrMoreMatcher<V> matcher) {
        return (Boolean)matcher.subMatcher.accept(this);
    }

    @Override
    public Boolean visit(OptionalMatcher<V> matcher) {
        return (Boolean)matcher.subMatcher.accept(this);
    }

    @Override
    public Boolean visit(SequenceMatcher<V> matcher) {
        for (Matcher child : matcher.getChildren()) {
            if (((Boolean)child.accept(this)).booleanValue()) {
                return true;
            }
            if (((Boolean)child.accept(this.canMatchEmptyVisitor)).booleanValue()) continue;
            break;
        }
        return false;
    }

    @Override
    public Boolean visit(TestMatcher<V> matcher) {
        return (Boolean)matcher.subMatcher.accept(this);
    }

    @Override
    public Boolean visit(TestNotMatcher<V> matcher) {
        return false;
    }

    @Override
    public Boolean visit(ZeroOrMoreMatcher<V> matcher) {
        return (Boolean)matcher.subMatcher.accept(this);
    }
}

