/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.grammar;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import lombok.ast.AlternateConstructorInvocation;
import lombok.ast.Assert;
import lombok.ast.Block;
import lombok.ast.Break;
import lombok.ast.Case;
import lombok.ast.Catch;
import lombok.ast.Continue;
import lombok.ast.Default;
import lombok.ast.DoWhile;
import lombok.ast.EmptyStatement;
import lombok.ast.ExpressionStatement;
import lombok.ast.For;
import lombok.ast.ForEach;
import lombok.ast.If;
import lombok.ast.LabelledStatement;
import lombok.ast.Node;
import lombok.ast.Position;
import lombok.ast.Return;
import lombok.ast.SuperConstructorInvocation;
import lombok.ast.Switch;
import lombok.ast.Synchronized;
import lombok.ast.Throw;
import lombok.ast.Try;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.While;
import lombok.ast.grammar.Source;
import lombok.ast.grammar.SourceActions;
import lombok.ast.grammar.TemporaryNode;

public class StatementsActions
extends SourceActions {
    public StatementsActions(Source source) {
        super(source);
    }

    public Node createBlock(List<Node> statements) {
        Block block = new Block();
        if (statements != null) {
            for (Node s : statements) {
                if (s == null) continue;
                block.rawContents().addToEnd(s);
            }
        }
        return this.posify(block);
    }

    public Node createEmptyStatement() {
        return this.posify(new EmptyStatement());
    }

    public Node createLabelledStatement(List<Node> labelNames, Node statement) {
        Node current = statement;
        if (labelNames != null) {
            labelNames = Lists.newArrayList(labelNames);
            Collections.reverse(labelNames);
            for (Node n : labelNames) {
                if (n == null) continue;
                Position pos = current == null ? null : new Position(n.getPosition().getStart(), current.getPosition().getEnd());
                current = new LabelledStatement().astLabel(this.createIdentifierIfNeeded(n, this.currentPos())).rawStatement(current);
                current.setPosition(pos);
            }
        }
        return current;
    }

    public Node createIfStatement(Node condition, Node statement, Node elseStatement) {
        return this.posify(new If().rawCondition(condition).rawStatement(statement).rawElseStatement(elseStatement));
    }

    public Node createAssertStatement(Node assertion, Node message) {
        return this.posify(new Assert().rawAssertion(assertion).rawMessage(message));
    }

    public Node createSwitchStatement(Node condition, Node body) {
        return this.posify(new Switch().rawCondition(condition).rawBody(body));
    }

    public Node createCaseStatement(Node condition) {
        return this.posify(new Case().rawCondition(condition));
    }

    public Node createDefaultStatement(lombok.ast.libs.org.parboiled.Node<Node> defaultStatement) {
        Default node = new Default();
        this.source.registerStructure(node, defaultStatement);
        return this.posify(node);
    }

    public Node createWhileStatement(Node condition, Node statement) {
        return this.posify(new While().rawCondition(condition).rawStatement(statement));
    }

    public Node createDoStatement(Node condition, Node statement) {
        return this.posify(new DoWhile().rawCondition(condition).rawStatement(statement));
    }

    public Node createStatementExpressionList(Node head, List<Node> tail) {
        TemporaryNode.StatementExpressionList result = new TemporaryNode.StatementExpressionList();
        if (head != null) {
            result.expressions.add(head);
        }
        if (tail != null) {
            for (Node n : tail) {
                if (n == null) continue;
                result.expressions.add(n);
            }
        }
        return this.posify(result);
    }

    public Node createBasicFor(Node init, Node condition, Node update, Node statement) {
        For result = new For().rawCondition(condition).rawStatement(statement);
        List<Node> updates = update instanceof TemporaryNode.StatementExpressionList ? ((TemporaryNode.StatementExpressionList)update).expressions : Collections.singletonList(update);
        if (init instanceof TemporaryNode.StatementExpressionList) {
            for (Node n : ((TemporaryNode.StatementExpressionList)init).expressions) {
                result.rawExpressionInits().addToEnd(n);
            }
        } else {
            result.rawVariableDeclaration(init);
        }
        for (Node n : updates) {
            if (n == null) continue;
            result.rawUpdates().addToEnd(n);
        }
        return this.posify(result);
    }

    public Node createEnhancedFor(lombok.ast.libs.org.parboiled.Node<Node> modifiers, Node type, lombok.ast.libs.org.parboiled.Node<Node> varDefEntry, Node iterable, Node statement) {
        VariableDefinition decl = new VariableDefinition().rawTypeReference(type).rawVariables().addToEnd(varDefEntry.getValue());
        this.positionSpan(decl, modifiers, varDefEntry);
        decl.astModifiers(this.createModifiersIfNeeded(modifiers.getValue(), decl.getPosition().getStart()));
        return this.posify(new ForEach().rawVariable(decl).rawIterable(iterable).rawStatement(statement));
    }

    public Node createBreak(Node label) {
        Break b = new Break();
        if (label != null) {
            b.astLabel(this.createIdentifierIfNeeded(label, this.currentPos()));
        }
        return this.posify(b);
    }

    public Node createContinue(Node label) {
        Continue c = new Continue();
        if (label != null) {
            c.astLabel(this.createIdentifierIfNeeded(label, this.currentPos()));
        }
        return this.posify(c);
    }

    public Node createReturn(Node value) {
        return this.posify(new Return().rawValue(value));
    }

    public Node createThrow(Node throwable) {
        return this.posify(new Throw().rawThrowable(throwable));
    }

    public Node createSynchronizedStatement(Node lock, Node body) {
        return this.posify(new Synchronized().rawLock(lock).rawBody(body));
    }

    public Node createCatch(Node modifiers, Node type, Node varName, Node body) {
        VariableDefinitionEntry varNameEntry = new VariableDefinitionEntry().astName(this.createIdentifierIfNeeded(varName, this.currentPos()));
        if (varName != null) {
            varNameEntry.setPosition(varName.getPosition());
        }
        VariableDefinition decl = new VariableDefinition().rawTypeReference(type).rawVariables().addToEnd(varNameEntry);
        if (type != null && varName != null) {
            decl.setPosition(new Position(type.getPosition().getStart(), varName.getPosition().getEnd()));
        }
        if (modifiers != null) {
            decl.astModifiers(this.createModifiersIfNeeded(modifiers, this.currentPos()));
        }
        return this.posify(new Catch().rawExceptionDeclaration(decl).rawBody(body));
    }

    public Node createTryStatement(Node body, List<Node> catches, Node finallyBody) {
        Try result = new Try().rawBody(body).rawFinally(finallyBody);
        if (catches != null) {
            for (Node c : catches) {
                if (c == null) continue;
                result.rawCatches().addToEnd(c);
            }
        }
        return this.posify(result);
    }

    public Node addLocalVariableModifiers(Node variableDefinition, Node modifiers) {
        if (modifiers != null && variableDefinition instanceof VariableDefinition) {
            ((VariableDefinition)variableDefinition).astModifiers(this.createModifiersIfNeeded(modifiers, this.currentPos()));
        }
        return this.posify(variableDefinition);
    }

    public Node createAlternateConstructorInvocation(Node typeArguments, Node arguments) {
        AlternateConstructorInvocation result = new AlternateConstructorInvocation();
        if (typeArguments instanceof TemporaryNode.TypeArguments) {
            for (Node arg : ((TemporaryNode.TypeArguments)typeArguments).arguments) {
                result.rawConstructorTypeArguments().addToEnd(arg);
            }
        }
        if (arguments instanceof TemporaryNode.MethodArguments) {
            for (Node arg : ((TemporaryNode.MethodArguments)arguments).arguments) {
                result.rawArguments().addToEnd(arg);
            }
        }
        return this.posify(result);
    }

    public Node createSuperConstructorInvocation(lombok.ast.libs.org.parboiled.Node<Node> dot, Node qualifier, Node typeArguments, Node arguments) {
        SuperConstructorInvocation result = new SuperConstructorInvocation().rawQualifier(qualifier);
        if (typeArguments instanceof TemporaryNode.TypeArguments) {
            for (Node arg : ((TemporaryNode.TypeArguments)typeArguments).arguments) {
                result.rawConstructorTypeArguments().addToEnd(arg);
            }
        }
        if (arguments instanceof TemporaryNode.MethodArguments) {
            for (Node arg : ((TemporaryNode.MethodArguments)arguments).arguments) {
                result.rawArguments().addToEnd(arg);
            }
        }
        if (dot != null) {
            this.source.registerStructure(result, dot);
        }
        return this.posify(result);
    }

    public Node createExpressionStatement(Node expression) {
        return this.posify(new ExpressionStatement().rawExpression(expression));
    }

    public Node createVariableDeclaration(Node definition) {
        return this.posify(new VariableDeclaration().rawDefinition(definition));
    }
}

