/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.ClassLiteral;
import lombok.ast.DescribedNode;
import lombok.ast.ListAccessor;
import lombok.ast.MethodDeclaration;
import lombok.ast.Node;
import lombok.ast.RawListAccessor;
import lombok.ast.StrictListAccessor;
import lombok.ast.TypeReferencePart;
import lombok.ast.TypeReferenceTemplate;
import lombok.ast.TypeVariable;
import lombok.ast.WildcardKind;

public class TypeReference
extends AbstractNode
implements DescribedNode {
    private WildcardKind wildcard = WildcardKind.NONE;
    ListAccessor<TypeReferencePart, TypeReference> parts = ListAccessor.of(this, TypeReferencePart.class, "TypeReference.parts");
    private int arrayDimensions = 0;

    public TypeVariable upIfTypeVariableBoundToTypeVariable() {
        if (!(this.getParent() instanceof TypeVariable)) {
            return null;
        }
        TypeVariable out = (TypeVariable)this.getParent();
        if (!out.rawExtending().contains(this)) {
            return null;
        }
        return out;
    }

    public TypeReferencePart upIfTypeArgumentToTypeReferencePart() {
        if (!(this.getParent() instanceof TypeReferencePart)) {
            return null;
        }
        TypeReferencePart out = (TypeReferencePart)this.getParent();
        if (!out.rawTypeArguments().contains(this)) {
            return null;
        }
        return out;
    }

    public MethodDeclaration upIfReturnTypeToMethodDeclaration() {
        if (!(this.getParent() instanceof MethodDeclaration)) {
            return null;
        }
        MethodDeclaration out = (MethodDeclaration)this.getParent();
        if (out.rawReturnTypeReference() != this) {
            return null;
        }
        return out;
    }

    public ClassLiteral upToClassLiteral() {
        if (!(this.getParent() instanceof ClassLiteral)) {
            return null;
        }
        ClassLiteral out = (ClassLiteral)this.getParent();
        if (out.rawTypeReference() != this) {
            return null;
        }
        return out;
    }

    public WildcardKind astWildcard() {
        return this.wildcard;
    }

    public TypeReference astWildcard(WildcardKind wildcard) {
        this.wildcard = wildcard == null ? WildcardKind.NONE : wildcard;
        return this;
    }

    public RawListAccessor<TypeReferencePart, TypeReference> rawParts() {
        return this.parts.asRaw();
    }

    public StrictListAccessor<TypeReferencePart, TypeReference> astParts() {
        return this.parts.asStrict();
    }

    public int astArrayDimensions() {
        return this.arrayDimensions;
    }

    public TypeReference astArrayDimensions(int arrayDimensions) {
        this.arrayDimensions = arrayDimensions;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.parts.backingList());
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        return this.rawParts().replace(original, replacement);
    }

    @Override
    public boolean detach(Node child) {
        return this.rawParts().remove(child);
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitTypeReference(this)) {
            return;
        }
        for (AbstractNode child : this.parts.asIterable()) {
            child.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public TypeReference copy() {
        TypeReference result = new TypeReference();
        result.wildcard = this.wildcard;
        for (AbstractNode n : this.parts.backingList()) {
            result.rawParts().addToEnd(n == null ? null : n.copy());
        }
        result.arrayDimensions = this.arrayDimensions;
        return result;
    }

    @Override
    public String getDescription() {
        return TypeReferenceTemplate.getDescription(this);
    }

    public static TypeReference VOID() {
        return TypeReferenceTemplate.VOID();
    }

    public static TypeReference BOOLEAN() {
        return TypeReferenceTemplate.BOOLEAN();
    }

    public static TypeReference INT() {
        return TypeReferenceTemplate.INT();
    }

    public static TypeReference LONG() {
        return TypeReferenceTemplate.LONG();
    }

    public static TypeReference SHORT() {
        return TypeReferenceTemplate.SHORT();
    }

    public static TypeReference BYTE() {
        return TypeReferenceTemplate.BYTE();
    }

    public static TypeReference CHAR() {
        return TypeReferenceTemplate.CHAR();
    }

    public static TypeReference DOUBLE() {
        return TypeReferenceTemplate.DOUBLE();
    }

    public static TypeReference FLOAT() {
        return TypeReferenceTemplate.FLOAT();
    }

    public static TypeReference fromName(String name) {
        return TypeReferenceTemplate.fromName(name);
    }

    public boolean isPrimitive() {
        return TypeReferenceTemplate.isPrimitive(this);
    }

    public boolean isBoolean() {
        return TypeReferenceTemplate.isBoolean(this);
    }

    public boolean isInt() {
        return TypeReferenceTemplate.isInt(this);
    }

    public boolean isLong() {
        return TypeReferenceTemplate.isLong(this);
    }

    public boolean isShort() {
        return TypeReferenceTemplate.isShort(this);
    }

    public boolean isByte() {
        return TypeReferenceTemplate.isByte(this);
    }

    public boolean isChar() {
        return TypeReferenceTemplate.isChar(this);
    }

    public boolean isDouble() {
        return TypeReferenceTemplate.isDouble(this);
    }

    public boolean isFloat() {
        return TypeReferenceTemplate.isFloat(this);
    }

    public boolean isVoid() {
        return TypeReferenceTemplate.isVoid(this);
    }

    public String getTypeName() {
        return TypeReferenceTemplate.getTypeName(this);
    }

    public boolean hasTypeArguments() {
        return TypeReferenceTemplate.hasTypeArguments(this);
    }

    public StrictListAccessor<TypeReference, TypeReference> getTypeArguments() {
        return TypeReferenceTemplate.getTypeArguments(this);
    }
}

