/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSData;
import org.eclipse.swt.internal.cocoa.NSKeyedArchiver;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPrintInfo;
import org.eclipse.swt.internal.cocoa.NSPrintPanel;
import org.eclipse.swt.internal.cocoa.NSPrinter;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTPrintPanelDelegate;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class PrintDialog
extends Dialog {
    PrinterData printerData = new PrinterData();
    int returnCode;
    static Callback dialogCallback5;
    static final byte[] SWT_OBJECT;
    static /* synthetic */ Class class$0;

    static {
        byte[] byArray = new byte[11];
        byArray[0] = 83;
        byArray[1] = 87;
        byArray[2] = 84;
        byArray[3] = 95;
        byArray[4] = 79;
        byArray[5] = 66;
        byArray[6] = 74;
        byArray[7] = 69;
        byArray[8] = 67;
        byArray[9] = 84;
        SWT_OBJECT = byArray;
    }

    public PrintDialog(Shell shell) {
        this(shell, 32768);
    }

    public PrintDialog(Shell shell, int n) {
        super(shell, PrintDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    static int checkStyle(Shell shell, int n) {
        int n2 = 229376;
        if ((n & 0x10000000) != 0) {
            if (PrintDialog.getSheetEnabled()) {
                if (shell == null) {
                    n &= 0xEFFFFFFF;
                }
            } else {
                n &= 0xEFFFFFFF;
            }
            if ((n & n2) == 0) {
                n |= shell == null ? 65536 : 32768;
            }
        }
        return n;
    }

    public void setPrinterData(PrinterData printerData) {
        this.printerData = printerData;
    }

    public PrinterData getPrinterData() {
        return this.printerData;
    }

    public PrinterData open() {
        int n;
        NSObject nSObject;
        PrinterData printerData = null;
        NSPrintPanel nSPrintPanel = NSPrintPanel.printPanel();
        NSPrintInfo nSPrintInfo = new NSPrintInfo(NSPrintInfo.sharedPrintInfo().copy());
        nSPrintInfo.setOrientation(this.printerData.orientation == 2 ? 1 : 0);
        NSMutableDictionary nSMutableDictionary = nSPrintInfo.dictionary();
        nSMutableDictionary.setValue(NSNumber.numberWithBool(this.printerData.collate), OS.NSPrintMustCollate);
        nSMutableDictionary.setValue(NSNumber.numberWithInt(this.printerData.copyCount), OS.NSPrintCopies);
        if (this.printerData.printToFile) {
            nSMutableDictionary.setValue(OS.NSPrintSaveJob, OS.NSPrintJobDisposition);
        }
        if (this.printerData.fileName != null && this.printerData.fileName.length() > 0) {
            nSMutableDictionary.setValue(NSString.stringWith(this.printerData.fileName), OS.NSPrintSavePath);
        }
        nSMutableDictionary.setValue(NSNumber.numberWithBool(this.printerData.scope == 0), OS.NSPrintAllPages);
        if (this.printerData.scope == 1) {
            nSMutableDictionary.setValue(NSNumber.numberWithInt(this.printerData.startPage), OS.NSPrintFirstPage);
            nSMutableDictionary.setValue(NSNumber.numberWithInt(this.printerData.endPage), OS.NSPrintLastPage);
        }
        nSPrintPanel.setOptions(0x100L | nSPrintPanel.options());
        if ((this.getStyle() & 0x10000000) != 0) {
            this.initClasses();
            nSObject = (SWTPrintPanelDelegate)new SWTPrintPanelDelegate().alloc().init();
            long l = OS.NewGlobalRef(this);
            if (l == 0L) {
                SWT.error(2);
            }
            OS.object_setInstanceVariable(((SWTPrintPanelDelegate)nSObject).id, SWT_OBJECT, l);
            this.returnCode = -1;
            Shell shell = this.getParent();
            nSPrintPanel.beginSheetWithPrintInfo(nSPrintInfo, shell.view.window(), nSObject, OS.sel_panelDidEnd_returnCode_contextInfo_, 0L);
            NSApplication nSApplication = NSApplication.sharedApplication();
            while (this.returnCode == -1) {
                nSApplication.run();
            }
            if (nSObject != null) {
                nSObject.release();
            }
            if (l != 0L) {
                OS.DeleteGlobalRef(l);
            }
            n = this.returnCode;
        } else {
            n = (int)nSPrintPanel.runModalWithPrintInfo(nSPrintInfo);
        }
        if (n != 0) {
            NSObject nSObject2;
            nSObject = nSPrintInfo.printer();
            NSString nSString = ((NSPrinter)nSObject).name();
            printerData = new PrinterData("Mac", nSString.getString());
            printerData.printToFile = nSPrintInfo.jobDisposition().isEqual(OS.NSPrintSaveJob);
            if (printerData.printToFile) {
                nSObject2 = new NSString(nSMutableDictionary.objectForKey(OS.NSPrintSavePath));
                printerData.fileName = ((NSString)nSObject2).getString();
            }
            int n2 = printerData.scope = new NSNumber(nSMutableDictionary.objectForKey(OS.NSPrintAllPages)).intValue() != 0 ? 0 : 1;
            if (printerData.scope == 1) {
                printerData.startPage = new NSNumber(nSMutableDictionary.objectForKey(OS.NSPrintFirstPage)).intValue();
                printerData.endPage = new NSNumber(nSMutableDictionary.objectForKey(OS.NSPrintLastPage)).intValue();
            }
            printerData.collate = new NSNumber(nSMutableDictionary.objectForKey(OS.NSPrintMustCollate)).intValue() != 0;
            printerData.collate = false;
            printerData.copyCount = new NSNumber(nSMutableDictionary.objectForKey(OS.NSPrintCopies)).intValue();
            printerData.copyCount = 1;
            printerData.orientation = nSPrintInfo.orientation() == 1L ? 2 : 1;
            nSObject2 = NSKeyedArchiver.archivedDataWithRootObject(nSPrintInfo);
            printerData.otherData = new byte[(int)((NSData)nSObject2).length()];
            OS.memmove(printerData.otherData, ((NSData)nSObject2).bytes(), (long)printerData.otherData.length);
            this.printerData = printerData;
        }
        nSPrintInfo.release();
        return printerData;
    }

    public int getScope() {
        return this.printerData.scope;
    }

    static boolean getSheetEnabled() {
        return !"false".equals(System.getProperty("org.eclipse.swt.sheet"));
    }

    static long dialogProc(long l, long l2, long l3, long l4, long l5) {
        long[] lArray = new long[1];
        OS.object_getInstanceVariable(l, SWT_OBJECT, lArray);
        if (lArray[0] == 0L) {
            return 0L;
        }
        if (l2 == OS.sel_panelDidEnd_returnCode_contextInfo_) {
            PrintDialog printDialog = (PrintDialog)OS.JNIGetObject(lArray[0]);
            if (printDialog == null) {
                return 0L;
            }
            printDialog.panelDidEnd_returnCode_contextInfo(l, l2, l3, l4, l5);
        }
        return 0L;
    }

    void initClasses() {
        String string = "SWTPrintPanelDelegate";
        if (OS.objc_lookUpClass(string) != 0L) {
            return;
        }
        dialogCallback5 = new Callback(this.getClass(), "dialogProc", 5);
        long l = dialogCallback5.getAddress();
        if (l == 0L) {
            SWT.error(3);
        }
        byte[] byArray = new byte[2];
        byArray[0] = 42;
        byte[] byArray2 = byArray;
        int n = C.PTR_SIZEOF;
        int n2 = C.PTR_SIZEOF == 4 ? 2 : 3;
        long l2 = OS.objc_allocateClassPair(OS.class_NSObject, string, 0L);
        OS.class_addIvar(l2, SWT_OBJECT, n, (byte)n2, byArray2);
        OS.class_addMethod(l2, OS.sel_panelDidEnd_returnCode_contextInfo_, l, "@:@i@");
        OS.objc_registerClassPair(l2);
    }

    void panelDidEnd_returnCode_contextInfo(long l, long l2, long l3, long l4, long l5) {
        this.returnCode = (int)l4;
        NSApplication nSApplication = NSApplication.sharedApplication();
        nSApplication.stop(null);
    }

    public void setScope(int n) {
        this.printerData.scope = n;
    }

    public int getStartPage() {
        return this.printerData.startPage;
    }

    public void setStartPage(int n) {
        this.printerData.startPage = n;
    }

    public int getEndPage() {
        return this.printerData.endPage;
    }

    public void setEndPage(int n) {
        this.printerData.endPage = n;
    }

    public boolean getPrintToFile() {
        return this.printerData.printToFile;
    }

    public void setPrintToFile(boolean bl) {
        this.printerData.printToFile = bl;
    }

    protected void checkSubclass() {
        String string;
        String string2 = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.printing.PrintDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(string = clazz.getName()).equals(string2)) {
            SWT.error(43);
        }
    }
}

