/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.monitor;

import com.android.ide.eclipse.monitor.SdkToolsLocator;
import com.android.ide.eclipse.monitor.SwtUtils;
import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SdkLocationChooserDialog
extends Dialog {
    private static final String TITLE = "Android Device Monitor";
    private static final String DEFAULT_MESSAGE = "Provide the path to the Android SDK";
    private Label mStatusLabel;
    private Text mTextBox;
    private String mPath;

    public SdkLocationChooserDialog(Shell shell) {
        super(shell);
    }

    protected Control createDialogArea(Composite composite) {
        this.getShell().setText(TITLE);
        Composite composite2 = new Composite((Composite)super.createDialogArea(composite), 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite2, 0);
        label.setText(DEFAULT_MESSAGE);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)label);
        this.mTextBox = new Text(composite2, 2048);
        this.mTextBox.setLayoutData((Object)new GridData(768));
        GridDataFactory.fillDefaults().hint(SwtUtils.getFontWidth((Control)this.mTextBox) * 80, -1).applyTo((Control)this.mTextBox);
        this.mTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                SdkLocationChooserDialog.this.validateInstall();
            }
        });
        Button button = new Button(composite2, 8);
        button.setText("Browse");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DirectoryDialog directoryDialog = new DirectoryDialog(SdkLocationChooserDialog.this.getShell(), 4096);
                directoryDialog.setText("Android SDK location");
                String string = directoryDialog.open();
                if (string != null) {
                    SdkLocationChooserDialog.this.mTextBox.setText(string);
                    SdkLocationChooserDialog.this.validateInstall();
                }
            }
        });
        this.mStatusLabel = new Label(composite2, 64);
        this.mStatusLabel.setText("");
        this.mStatusLabel.setForeground(this.getShell().getDisplay().getSystemColor(3));
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.mStatusLabel);
        return super.createDialogArea(composite);
    }

    private void validateInstall() {
        SdkToolsLocator sdkToolsLocator = new SdkToolsLocator(new File(this.mTextBox.getText()));
        SdkToolsLocator.SdkInstallStatus sdkInstallStatus = sdkToolsLocator.isValidInstallation();
        if (sdkInstallStatus.isValid()) {
            this.mStatusLabel.setText("");
            this.getButton(0).setEnabled(true);
        } else {
            this.mStatusLabel.setText(sdkInstallStatus.getErrorMessage());
            this.mStatusLabel.pack();
            this.getButton(0).setEnabled(false);
        }
    }

    public boolean close() {
        this.mPath = this.mTextBox.getText();
        return super.close();
    }

    public String getPath() {
        return this.mPath;
    }
}

