/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls.attribute;

import com.vladium.jcd.cls.attribute.Attribute_info;
import com.vladium.jcd.cls.attribute.IAttributeVisitor;
import com.vladium.jcd.cls.attribute.InnerClass_info;
import com.vladium.jcd.lib.UDataInputStream;
import com.vladium.jcd.lib.UDataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class InnerClassesAttribute_info
extends Attribute_info {
    private List m_classes;

    public boolean makesClassNested(int n, int[] nArray) {
        if (n > 0) {
            int n2 = this.size();
            for (int i = 0; i < n2; ++i) {
                InnerClass_info innerClass_info = this.get(i);
                if (innerClass_info.m_inner_class_index != n) continue;
                nArray[0] = innerClass_info.m_inner_access_flags;
                return true;
            }
        }
        return false;
    }

    public final InnerClass_info get(int n) {
        return (InnerClass_info)this.m_classes.get(n);
    }

    public final int size() {
        return this.m_classes.size();
    }

    public final long length() {
        return 8 + (this.m_classes.size() << 3);
    }

    public void accept(IAttributeVisitor iAttributeVisitor, Object object) {
        iAttributeVisitor.visit(this, object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("InnerClassesAttribute_info: [attribute_name_index = " + this.m_name_index + ", attribute_length = " + this.length() + "]\n");
        for (int i = 0; i < this.size(); ++i) {
            stringBuffer.append("            " + this.get(i));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        InnerClassesAttribute_info innerClassesAttribute_info = (InnerClassesAttribute_info)super.clone();
        List list = this.m_classes;
        int n = list.size();
        innerClassesAttribute_info.m_classes = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            innerClassesAttribute_info.m_classes.add(((InnerClass_info)list.get(i)).clone());
        }
        return innerClassesAttribute_info;
    }

    public void writeInClassFormat(UDataOutputStream uDataOutputStream) throws IOException {
        super.writeInClassFormat(uDataOutputStream);
        List list = this.m_classes;
        int n = list.size();
        uDataOutputStream.writeU2(n);
        for (int i = 0; i < n; ++i) {
            ((InnerClass_info)list.get(i)).writeInClassFormat(uDataOutputStream);
        }
    }

    InnerClassesAttribute_info(int n, long l, UDataInputStream uDataInputStream) throws IOException {
        super(n, l);
        int n2 = uDataInputStream.readU2();
        ArrayList<InnerClass_info> arrayList = new ArrayList<InnerClass_info>(n2);
        for (int i = 0; i < n2; ++i) {
            arrayList.add(new InnerClass_info(uDataInputStream));
        }
        this.m_classes = arrayList;
    }
}

