/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report.html.doc;

import com.vladium.emma.EMMARuntimeException;
import com.vladium.util.IConstants;
import java.io.IOException;
import java.io.Writer;

public final class HTMLWriter {
    private Writer m_out;

    public HTMLWriter(Writer writer) {
        if (writer == null) {
            throw new IllegalArgumentException("null input: out");
        }
        this.m_out = writer;
    }

    public void write(String string) {
        if (this.m_out != null) {
            try {
                this.m_out.write(string);
            }
            catch (IOException iOException) {
                throw new EMMARuntimeException("REPORT_IO_FAILURE", iOException);
            }
        }
    }

    public void write(char c) {
        if (this.m_out != null) {
            try {
                this.m_out.write(c);
            }
            catch (IOException iOException) {
                throw new EMMARuntimeException("REPORT_IO_FAILURE", iOException);
            }
        }
    }

    public void eol() {
        if (this.m_out != null) {
            try {
                this.m_out.write(IConstants.EOL);
            }
            catch (IOException iOException) {
                throw new EMMARuntimeException("REPORT_IO_FAILURE", iOException);
            }
        }
    }

    public void flush() {
        if (this.m_out != null) {
            try {
                this.m_out.flush();
            }
            catch (IOException iOException) {
                throw new EMMARuntimeException("REPORT_IO_FAILURE", iOException);
            }
        }
    }

    public void close() {
        if (this.m_out != null) {
            try {
                this.m_out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_out = null;
        }
    }
}

