/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.data;

import com.vladium.emma.data.CoverageData;
import com.vladium.emma.data.CoverageOptions;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMergeable;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.data.ISessionData;
import com.vladium.emma.data.MetaData;
import com.vladium.logging.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLConnection;

public abstract class DataFactory {
    public static final byte TYPE_METADATA = 0;
    public static final byte TYPE_COVERAGEDATA = 1;
    private static final int NULL_ARRAY_LENGTH = -1;
    private static final int MAGIC = 1162693953;
    private static final long UNKNOWN = 0L;
    private static final int FILE_HEADER_LENGTH = 24;
    private static final int ENTRY_HEADER_LENGTH = 9;
    private static final boolean DO_FSYNC = true;
    private static final int IO_BUF_SIZE = 32768;

    public static IMergeable[] load(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("null input: file");
        }
        return DataFactory.mergeload(file);
    }

    public static void persist(IMetaData iMetaData, File file, boolean bl) throws IOException {
        if (iMetaData == null) {
            throw new IllegalArgumentException("null input: data");
        }
        if (file == null) {
            throw new IllegalArgumentException("null input: file");
        }
        if (!bl && file.exists() && !file.delete()) {
            throw new IOException("could not delete file [" + file.getAbsolutePath() + "]");
        }
        DataFactory.persist((IMergeable)iMetaData, (byte)0, file);
    }

    public static void persist(ICoverageData iCoverageData, File file, boolean bl) throws IOException {
        if (iCoverageData == null) {
            throw new IllegalArgumentException("null input: data");
        }
        if (file == null) {
            throw new IllegalArgumentException("null input: file");
        }
        if (!bl && file.exists() && !file.delete()) {
            throw new IOException("could not delete file [" + file.getAbsolutePath() + "]");
        }
        DataFactory.persist((IMergeable)iCoverageData, (byte)1, file);
    }

    public static void persist(ISessionData iSessionData, File file, boolean bl) throws IOException {
        if (iSessionData == null) {
            throw new IllegalArgumentException("null input: data");
        }
        if (file == null) {
            throw new IllegalArgumentException("null input: file");
        }
        if (!bl && file.exists() && !file.delete()) {
            throw new IOException("could not delete file [" + file.getAbsolutePath() + "]");
        }
        DataFactory.persist((IMergeable)iSessionData.getMetaData(), (byte)0, file);
        DataFactory.persist((IMergeable)iSessionData.getCoverageData(), (byte)1, file);
    }

    public static IMetaData newMetaData(CoverageOptions coverageOptions) {
        return new MetaData(coverageOptions);
    }

    public static ICoverageData newCoverageData() {
        return new CoverageData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IMetaData readMetaData(URL uRL) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new BufferedInputStream(uRL.openStream(), 32768));
            IMetaData iMetaData = (IMetaData)objectInputStream.readObject();
            return iMetaData;
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void writeMetaData(IMetaData iMetaData, OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(iMetaData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMetaData(IMetaData iMetaData, URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoOutput(true);
        OutputStream outputStream = null;
        try {
            outputStream = uRLConnection.getOutputStream();
            DataFactory.writeMetaData(iMetaData, outputStream);
            outputStream.flush();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICoverageData readCoverageData(URL uRL) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new BufferedInputStream(uRL.openStream(), 32768));
            ICoverageData iCoverageData = (ICoverageData)objectInputStream.readObject();
            return iCoverageData;
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void writeCoverageData(ICoverageData iCoverageData, OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(iCoverageData);
    }

    public static int[] readIntArray(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        if (n == -1) {
            return null;
        }
        int[] nArray = new int[n];
        int n2 = n;
        while (--n2 >= 0) {
            nArray[n2] = dataInput.readInt();
        }
        return nArray;
    }

    public static boolean[] readBooleanArray(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        if (n == -1) {
            return null;
        }
        boolean[] blArray = new boolean[n];
        int n2 = n;
        while (--n2 >= 0) {
            blArray[n2] = dataInput.readBoolean();
        }
        return blArray;
    }

    public static void writeIntArray(int[] nArray, DataOutput dataOutput) throws IOException {
        if (nArray == null) {
            dataOutput.writeInt(-1);
        } else {
            int n = nArray.length;
            dataOutput.writeInt(n);
            int n2 = n;
            while (--n2 >= 0) {
                dataOutput.writeInt(nArray[n2]);
            }
        }
    }

    public static void writeBooleanArray(boolean[] blArray, DataOutput dataOutput) throws IOException {
        if (blArray == null) {
            dataOutput.writeInt(-1);
        } else {
            int n = blArray.length;
            dataOutput.writeInt(n);
            int n2 = n;
            while (--n2 >= 0) {
                dataOutput.writeBoolean(blArray[n2]);
            }
        }
    }

    private DataFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IMergeable[] mergeload(File file) throws IOException {
        IMergeable[] iMergeableArray;
        long l;
        boolean bl;
        Logger logger;
        block21: {
            logger = Logger.getLogger();
            bl = logger.atTRACE1();
            boolean bl2 = logger.atTRACE2();
            l = 0L;
            if (bl) {
                l = System.currentTimeMillis();
            }
            iMergeableArray = new IMergeable[2];
            if (!file.exists()) {
                throw new IOException("input file does not exist: [" + file.getAbsolutePath() + "]");
            }
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(file, "r");
                long l2 = randomAccessFile.length();
                if (bl) {
                    logger.trace1("mergeload", "[" + file + "]: file length = " + l2);
                }
                if (l2 < 24L) {
                    throw new IOException("file [" + file.getAbsolutePath() + "] is corrupt or was not created by " + "EMMA");
                }
                if (l2 <= 24L) break block21;
                randomAccessFile.seek(24L);
                long l3 = 24L;
                long l4 = 0L;
                while (true) {
                    IMergeable iMergeable;
                    if (bl2) {
                        logger.trace2("mergeload", "[" + file + "]: position " + randomAccessFile.getFilePointer());
                    }
                    if (l3 >= l2) {
                        break;
                    }
                    long l5 = randomAccessFile.readLong();
                    if (l5 <= 0L) break;
                    if (l3 + l5 + 9L > l2) {
                        break;
                    }
                    byte by = randomAccessFile.readByte();
                    if (by < 0) break;
                    if (by >= iMergeableArray.length) {
                        break;
                    }
                    if (bl2) {
                        logger.trace2("mergeload", "[" + file + "]: found valid entry of size " + l5 + " and type " + by);
                    }
                    if (bl2) {
                        l4 = System.currentTimeMillis();
                    }
                    IMergeable iMergeable2 = DataFactory.readEntry(randomAccessFile, by, l5);
                    if (bl2) {
                        logger.trace2("mergeload", "entry read in " + (System.currentTimeMillis() - l4) + " ms");
                    }
                    iMergeableArray[by] = (iMergeable = iMergeableArray[by]) == null ? iMergeable2 : iMergeable.merge(iMergeable2);
                    randomAccessFile.seek(l3 += l5 + 9L);
                }
            }
            finally {
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (Throwable throwable) {}
                }
                randomAccessFile = null;
            }
        }
        if (bl) {
            long l6 = System.currentTimeMillis();
            logger.trace1("mergeload", "[" + file + "]: file processed in " + (l6 - l) + " ms");
        }
        return iMergeableArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void persist(IMergeable iMergeable, byte by, File file) throws IOException {
        Logger logger = Logger.getLogger();
        boolean bl = logger.atTRACE1();
        boolean bl2 = logger.atTRACE2();
        long l = 0L;
        if (bl) {
            l = System.currentTimeMillis();
        }
        RandomAccessFile randomAccessFile = null;
        try {
            boolean bl3 = false;
            boolean bl4 = false;
            if (file.exists()) {
                if (!file.isFile()) {
                    throw new IOException("can persist in normal files only: " + file.getAbsolutePath());
                }
                randomAccessFile = new RandomAccessFile(file, "rw");
                long l2 = randomAccessFile.length();
                if (bl) {
                    logger.trace1("persist", "[" + file + "]: existing file length = " + l2);
                }
                if (l2 < 4L) {
                    bl3 = true;
                    bl4 = l2 > 0L;
                } else {
                    int n = randomAccessFile.readInt();
                    if (n != 1162693953) {
                        throw new IOException("cannot overwrite [" + file.getAbsolutePath() + "]: not created by " + "EMMA");
                    }
                    if (l2 < 24L) {
                        bl3 = true;
                        bl4 = true;
                    } else {
                        long l3 = randomAccessFile.readLong();
                        if (l3 != 32L) {
                            int n2 = 0;
                            int n3 = 0;
                            int n4 = 0;
                            boolean bl5 = false;
                            try {
                                n2 = randomAccessFile.readInt();
                                n3 = randomAccessFile.readInt();
                                n4 = randomAccessFile.readInt();
                                bl5 = true;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            if (bl5) {
                                throw new IOException("cannot merge new data into [" + file.getAbsolutePath() + "]: created by another " + "EMMA" + " version [" + DataFactory.makeAppVersion(n2, n3, n4) + "]");
                            }
                            throw new IOException("cannot merge new data into [" + file.getAbsolutePath() + "]: created by another " + "EMMA" + " version");
                        }
                        randomAccessFile.seek(24L);
                        if (l2 == 24L) {
                            DataFactory.writeEntry(logger, randomAccessFile, 24L, iMergeable, by);
                        } else {
                            long l4 = 24L;
                            while (true) {
                                long l5;
                                if (bl2) {
                                    logger.trace2("persist", "[" + file + "]: position " + randomAccessFile.getFilePointer());
                                }
                                if (l4 >= l2 || (l5 = randomAccessFile.readLong()) <= 0L || l4 + l5 + 9L > l2) break;
                                if (bl2) {
                                    logger.trace2("persist", "[" + file + "]: found valid entry of size " + l5);
                                }
                                randomAccessFile.seek(l4 += l5 + 9L);
                            }
                            if (bl2) {
                                logger.trace2("persist", "[" + file + "]: adding entry at position " + l4);
                            }
                            DataFactory.writeEntry(logger, randomAccessFile, l4, iMergeable, by);
                        }
                    }
                }
            } else {
                File file2;
                if (bl) {
                    logger.trace1("persist", "[" + file + "]: creating a new file");
                }
                if ((file2 = file.getParentFile()) != null) {
                    file2.mkdirs();
                }
                randomAccessFile = new RandomAccessFile(file, "rw");
                bl3 = true;
            }
            if (bl3) {
                if (bl4) {
                    randomAccessFile.seek(0L);
                }
                DataFactory.writeFileHeader(randomAccessFile);
                DataFactory.writeEntry(logger, randomAccessFile, 24L, iMergeable, by);
            }
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Throwable throwable) {}
            }
            randomAccessFile = null;
        }
        if (bl) {
            long l6 = System.currentTimeMillis();
            logger.trace1("persist", "[" + file + "]: file processed in " + (l6 - l) + " ms");
        }
    }

    private static void writeFileHeader(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(1162693953);
        dataOutput.writeLong(32L);
        dataOutput.writeInt(0);
        dataOutput.writeInt(0);
        dataOutput.writeInt(0);
    }

    private static void writeEntryHeader(DataOutput dataOutput, byte by) throws IOException {
        dataOutput.writeLong(0L);
        dataOutput.writeByte(by);
    }

    private static void writeEntry(Logger logger, RandomAccessFile randomAccessFile, long l, IMergeable iMergeable, byte by) throws IOException {
        DataFactory.writeEntryHeader(randomAccessFile, by);
        RandomAccessFileOutputStream randomAccessFileOutputStream = new RandomAccessFileOutputStream(randomAccessFile, 32768);
        DataOutputStream dataOutputStream = new DataOutputStream(randomAccessFileOutputStream);
        switch (by) {
            case 0: {
                MetaData.writeExternal((MetaData)iMergeable, dataOutputStream);
                break;
            }
            default: {
                CoverageData.writeExternal((CoverageData)iMergeable, dataOutputStream);
            }
        }
        dataOutputStream.flush();
        dataOutputStream = null;
        randomAccessFile.setLength(randomAccessFile.getFilePointer());
        randomAccessFile.seek(l);
        randomAccessFile.writeLong(randomAccessFileOutputStream.getCount());
        randomAccessFile.getFD().sync();
        if (logger.atTRACE2()) {
            logger.trace2("writeEntry", "entry [" + iMergeable.getClass().getName() + "] length: " + randomAccessFileOutputStream.getCount());
        }
    }

    private static IMergeable readEntry(RandomAccessFile randomAccessFile, byte by, long l) throws IOException {
        IMergeable iMergeable;
        RandomAccessFileInputStream randomAccessFileInputStream = new RandomAccessFileInputStream(randomAccessFile, 32768);
        DataInputStream dataInputStream = new DataInputStream(randomAccessFileInputStream);
        switch (by) {
            case 0: {
                iMergeable = MetaData.readExternal(dataInputStream);
                break;
            }
            default: {
                iMergeable = CoverageData.readExternal(dataInputStream);
            }
        }
        return iMergeable;
    }

    private static String makeAppVersion(int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        stringBuffer.append('.');
        stringBuffer.append(n2);
        stringBuffer.append('.');
        stringBuffer.append(n3);
        return stringBuffer.toString();
    }

    private static final class RandomAccessFileOutputStream
    extends BufferedOutputStream {
        private long m_count;

        public final void write(byte[] byArray, int n, int n2) throws IOException {
            super.write(byArray, n, n2);
            this.m_count += (long)n2;
        }

        public final void write(byte[] byArray) throws IOException {
            super.write(byArray);
            this.m_count += (long)byArray.length;
        }

        public final void write(int n) throws IOException {
            super.write(n);
            ++this.m_count;
        }

        public void close() {
        }

        RandomAccessFileOutputStream(RandomAccessFile randomAccessFile, int n) throws IOException {
            super(new UCFileOutputStream(randomAccessFile.getFD()), n);
        }

        final long getCount() {
            return this.m_count;
        }
    }

    private static final class RandomAccessFileInputStream
    extends BufferedInputStream {
        private long m_count;

        public final int read() throws IOException {
            int n = super.read();
            if (n >= 0) {
                ++this.m_count;
            }
            return n;
        }

        public final int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = super.read(byArray, n, n2);
            if (n3 >= 0) {
                this.m_count += (long)n3;
            }
            return n3;
        }

        public final int read(byte[] byArray) throws IOException {
            int n = super.read(byArray);
            if (n >= 0) {
                this.m_count += (long)n;
            }
            return n;
        }

        public void close() {
        }

        RandomAccessFileInputStream(RandomAccessFile randomAccessFile, int n) throws IOException {
            super(new UCFileInputStream(randomAccessFile.getFD()), n);
        }

        final long getCount() {
            return this.m_count;
        }
    }

    private static final class UCFileOutputStream
    extends FileOutputStream {
        public void close() {
        }

        UCFileOutputStream(FileDescriptor fileDescriptor) {
            super(fileDescriptor);
        }
    }

    private static final class UCFileInputStream
    extends FileInputStream {
        public void close() {
        }

        UCFileInputStream(FileDescriptor fileDescriptor) {
            super(fileDescriptor);
        }
    }
}

