/*
 * Decompiled with CFR 0.152.
 */
package org.dict.zip;

import java.io.EOFException;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.dict.zip.DictZipFileUtils;
import org.dict.zip.DictZipHeader;
import org.dict.zip.RandomAccessInputStream;

public class DictZipInputStream
extends InflaterInputStream {
    private DictZipHeader header;
    private final CRC32 crc = new CRC32();
    private long crcVal = 0L;
    private long totalLength = 0L;
    private long compLength = 0L;
    private int offset = 0;
    private long rawOffset = 0L;
    private static final int BUF_LEN = 8192;
    private int markOffset = -1;
    private long mark;
    private boolean eos;

    public DictZipInputStream(String filename) throws IOException {
        this(new RandomAccessInputStream(filename, "r"), 8192);
    }

    public DictZipInputStream(RandomAccessInputStream in) throws IOException {
        this(in, 8192);
    }

    public DictZipInputStream(RandomAccessInputStream in, int size) throws IOException {
        super(in, new Inflater(true), size);
        this.header = this.readHeader();
        in.mark(in.getLength());
        this.readTrailer();
        in.reset();
    }

    @Override
    public final void close() throws IOException {
        this.inf.end();
        this.in.close();
        this.rawOffset = -1L;
        this.eos = true;
    }

    public final long position() {
        return this.rawOffset;
    }

    @Override
    public final boolean markSupported() {
        return true;
    }

    @Override
    public final void mark(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("markOffset should be positive number.");
        }
        this.markOffset = offset;
        this.mark = this.position();
    }

    @Override
    public final void reset() throws IOException {
        if (this.markOffset == -1 || this.position() > this.mark + (long)this.markOffset || this.position() < this.mark - (long)this.markOffset) {
            throw new IOException("Cannot reset to mark because offset overcome.");
        }
        this.seek(this.mark);
    }

    @Override
    public final int read(byte[] buffer, int off, int size) throws IOException {
        int readLen;
        if (this.eos) {
            return -1;
        }
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (off < 0 || size < 0 || size > buffer.length - off || off >= buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (size == 0) {
            return 0;
        }
        if (this.offset > 0) {
            int len;
            byte[] b = new byte[8192];
            for (int total = 0; total < this.offset; total += len) {
                len = this.offset - total;
                if (len > b.length) {
                    len = b.length;
                }
                if ((len = super.read(b, 0, len)) != -1) continue;
                this.eos = true;
                return -1;
            }
            this.offset = 0;
        }
        if ((readLen = super.read(buffer, off, size)) == -1) {
            this.eos = true;
        } else {
            this.crc.update(buffer, off, readLen);
            this.rawOffset += (long)readLen;
        }
        if (this.markOffset >= 0 && this.position() > this.mark + (long)this.markOffset) {
            this.markOffset = -1;
        }
        return readLen;
    }

    public final void readFully(byte[] buffer) throws IOException {
        this.readFully(buffer, 0, buffer.length);
    }

    public final void readFully(byte[] buffer, int off, int size) throws IOException {
        int count;
        for (int num = 0; num < size; num += count) {
            count = this.read(buffer, off + num, size - num);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    private DictZipHeader readHeader() throws IOException {
        if (this.header == null) {
            this.header = DictZipHeader.readHeader(this.in, this.crc);
            this.crc.reset();
        }
        return this.header;
    }

    public void seek(long next) throws IOException {
        this.rawOffset = next;
        if (!(this.in instanceof RandomAccessInputStream)) {
            throw new IOException("Illegal type of InputStream.");
        }
        RandomAccessInputStream rain = (RandomAccessInputStream)this.in;
        this.offset = this.header.getOffset(next);
        long pos = this.header.getPosition(next);
        rain.seek(pos);
        this.inf.reset();
        this.eos = false;
    }

    public long getCrc() throws IOException {
        if (this.totalLength == 0L) {
            this.readTrailer();
        }
        return this.crcVal;
    }

    public long getLength() throws IOException {
        if (this.totalLength == 0L) {
            this.readTrailer();
        }
        return this.totalLength;
    }

    public long getCompLength() throws IOException {
        if (this.totalLength == 0L) {
            this.readTrailer();
        }
        return this.compLength;
    }

    public String getType() {
        return this.header.getType();
    }

    public int getChunkLength() {
        return this.header.getChunkLength();
    }

    public int getChunkCount() {
        return this.header.getChunkCount();
    }

    public long getMtime() {
        return this.header.getMtime();
    }

    public String getFilename() {
        return this.header.getFilename();
    }

    void readTrailer() throws IOException {
        if (!(this.in instanceof RandomAccessInputStream)) {
            throw new IOException("Illegal type of InputStream.");
        }
        RandomAccessInputStream rain = (RandomAccessInputStream)this.in;
        this.compLength = rain.length();
        rain.seek(this.compLength - 8L);
        this.crcVal = DictZipFileUtils.readUInt(rain);
        this.totalLength = DictZipFileUtils.readUInt(rain);
    }
}

