/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.groovydoc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.codehaus.groovy.groovydoc.GroovyClassDoc;
import org.codehaus.groovy.groovydoc.GroovyPackageDoc;
import org.codehaus.groovy.groovydoc.GroovyRootDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyClassDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyDoc;

public class SimpleGroovyRootDoc
extends SimpleGroovyDoc
implements GroovyRootDoc {
    private static final Pattern EQUIVALENT_PACKAGE_IMPORT = Pattern.compile("[^/]+$");
    private static final GroovyClassDoc[] EMPTY_GROOVYCLASSDOC_ARRAY = new GroovyClassDoc[0];
    private static final GroovyPackageDoc[] EMPTY_GROOVYPACKAGEDOC_ARRAY = new GroovyPackageDoc[0];
    private final Map<String, GroovyPackageDoc> packageDocs;
    private List<GroovyPackageDoc> packageDocValues = null;
    private final Map<String, GroovyClassDoc> classDocs;
    private final Map<String, String> equivalentPackageImports;
    private List<GroovyClassDoc> classDocValues = null;
    private final Map<String, GroovyClassDoc> cachedResolvedClasses = new HashMap<String, GroovyClassDoc>();
    private final ClassNamedCache classNamedCache;
    private String description = "";

    public SimpleGroovyRootDoc(String name) {
        super(name);
        this.packageDocs = new LinkedHashMap<String, GroovyPackageDoc>();
        this.classDocs = new LinkedHashMap<String, GroovyClassDoc>();
        this.equivalentPackageImports = new HashMap<String, String>();
        this.classNamedCache = new ClassNamedCache(this.classDocs);
    }

    @Override
    public GroovyClassDoc classNamed(GroovyClassDoc groovyClassDoc, String name) {
        GroovyClassDoc doc = this.classDocs.get(name);
        if (doc != null) {
            return doc;
        }
        return this.classNamedCache.search(groovyClassDoc, name);
    }

    public GroovyClassDoc classNamedExact(String name) {
        return this.classDocs.get(name);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String description() {
        return this.description;
    }

    public String summary() {
        return SimpleGroovyDoc.calculateFirstSentence(this.description);
    }

    @Override
    public GroovyClassDoc[] classes() {
        if (this.classDocValues == null) {
            this.classDocValues = new ArrayList<GroovyClassDoc>(this.classDocs.values());
            Collections.sort(this.classDocValues);
        }
        return this.classDocValues.toArray(EMPTY_GROOVYCLASSDOC_ARRAY);
    }

    @Override
    public String[][] options() {
        return null;
    }

    @Override
    public GroovyPackageDoc packageNamed(String packageName) {
        return this.packageDocs.get(packageName);
    }

    public void putAllClasses(Map<String, GroovyClassDoc> classes) {
        this.classDocs.putAll(classes);
        this.classDocValues = null;
    }

    public void put(String packageName, GroovyPackageDoc packageDoc) {
        this.packageDocs.put(packageName, packageDoc);
        this.packageDocValues = null;
    }

    @Override
    public GroovyClassDoc[] specifiedClasses() {
        return null;
    }

    @Override
    public GroovyPackageDoc[] specifiedPackages() {
        if (this.packageDocValues == null) {
            this.packageDocValues = new ArrayList<GroovyPackageDoc>(this.packageDocs.values());
            Collections.sort(this.packageDocValues);
        }
        return this.packageDocValues.toArray(EMPTY_GROOVYPACKAGEDOC_ARRAY);
    }

    @Override
    public Map<String, GroovyClassDoc> getVisibleClasses(List importedClassesAndPackages) {
        LinkedHashMap<String, GroovyClassDoc> visibleClasses = new LinkedHashMap<String, GroovyClassDoc>();
        for (Map.Entry<String, GroovyClassDoc> entry : this.classDocs.entrySet()) {
            String fullClassName = entry.getKey();
            String equivalentPackageImport = this.findEquivalentPackageImport(fullClassName);
            if (!importedClassesAndPackages.contains(fullClassName) && !importedClassesAndPackages.contains(equivalentPackageImport)) continue;
            GroovyClassDoc classDoc = entry.getValue();
            visibleClasses.put(classDoc.name(), classDoc);
        }
        return visibleClasses;
    }

    private String findEquivalentPackageImport(String fullClassName) {
        String eq = this.equivalentPackageImports.get(fullClassName);
        if (eq == null) {
            eq = EQUIVALENT_PACKAGE_IMPORT.matcher(fullClassName).replaceAll("*");
            this.equivalentPackageImports.put(fullClassName, eq);
        }
        return eq;
    }

    @Override
    public Map<String, GroovyClassDoc> getResolvedClasses() {
        return this.cachedResolvedClasses;
    }

    @Override
    public void printError(String arg0) {
    }

    @Override
    public void printNotice(String arg0) {
    }

    @Override
    public void printWarning(String arg0) {
    }

    public void resolve() {
        for (GroovyClassDoc groovyClassDoc : this.classDocs.values()) {
            SimpleGroovyClassDoc classDoc = (SimpleGroovyClassDoc)groovyClassDoc;
            classDoc.resolve(this);
        }
    }

    private static class ClassNamedCache {
        private final Map<String, GroovyClassDoc> classDocs;
        private final Map<Entry, GroovyClassDoc> store = new HashMap<Entry, GroovyClassDoc>();

        private ClassNamedCache(Map<String, GroovyClassDoc> classDocs) {
            this.classDocs = classDocs;
        }

        public GroovyClassDoc search(GroovyClassDoc groovyClassDoc, String name) {
            Entry entry = new Entry(groovyClassDoc, name);
            GroovyClassDoc result = this.store.get(entry);
            if (result == null) {
                if (this.store.containsKey(entry)) {
                    return null;
                }
                result = this.performLookup(groovyClassDoc, name);
                this.store.put(entry, result);
            }
            return result;
        }

        private GroovyClassDoc performLookup(GroovyClassDoc groovyClassDoc, String name) {
            boolean hasPackage;
            String fullPathName = groovyClassDoc != null ? groovyClassDoc.getFullPathName() : null;
            boolean bl = hasPackage = fullPathName != null && fullPathName.lastIndexOf(47) > 0;
            if (hasPackage) {
                fullPathName = fullPathName.substring(0, fullPathName.lastIndexOf(47));
            }
            for (Map.Entry<String, GroovyClassDoc> entry : this.classDocs.entrySet()) {
                String shortKey;
                String key = entry.getKey();
                int lastSlashIdx = key.lastIndexOf(47);
                if (lastSlashIdx <= 0 || !(shortKey = key.substring(lastSlashIdx + 1)).equals(name) || hasPackage && !key.startsWith(fullPathName)) continue;
                GroovyClassDoc value = entry.getValue();
                return value;
            }
            return null;
        }

        private static class Entry {
            private final GroovyClassDoc groovyClass;
            private final String name;
            private final int hashCode;

            private Entry(GroovyClassDoc groovyClass, String name) {
                this.groovyClass = groovyClass;
                this.name = name;
                this.hashCode = this.computeHash();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Entry entry = (Entry)o;
                if (this.groovyClass != null ? !this.groovyClass.equals(entry.groovyClass) : entry.groovyClass != null) {
                    return false;
                }
                return this.name.equals(entry.name);
            }

            private int computeHash() {
                int result = this.groovyClass != null ? this.groovyClass.hashCode() : 0;
                result = 31 * result + this.name.hashCode();
                return result;
            }

            public int hashCode() {
                return this.hashCode;
            }
        }
    }
}

