/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.util.FS;

public class FileTreeIterator
extends WorkingTreeIterator {
    protected final File directory;
    protected final FS fs;
    protected final FileModeStrategy fileModeStrategy;

    public FileTreeIterator(Repository repo) {
        this(repo, repo.getConfig().get(WorkingTreeOptions.KEY).isDirNoGitLinks() ? NoGitlinksStrategy.INSTANCE : DefaultFileModeStrategy.INSTANCE);
    }

    public FileTreeIterator(Repository repo, FileModeStrategy fileModeStrategy) {
        this(repo.getWorkTree(), repo.getFS(), repo.getConfig().get(WorkingTreeOptions.KEY), fileModeStrategy);
        this.initRootIterator(repo);
    }

    public FileTreeIterator(File root, FS fs, WorkingTreeOptions options) {
        this(root, fs, options, (FileModeStrategy)DefaultFileModeStrategy.INSTANCE);
    }

    public FileTreeIterator(File root, FS fs, WorkingTreeOptions options, FileModeStrategy fileModeStrategy) {
        super(options);
        this.directory = root;
        this.fs = fs;
        this.fileModeStrategy = fileModeStrategy;
        this.init(this.entries());
    }

    @Deprecated
    protected FileTreeIterator(WorkingTreeIterator p, File root, FS fs) {
        this(p, root, fs, (FileModeStrategy)DefaultFileModeStrategy.INSTANCE);
    }

    protected FileTreeIterator(FileTreeIterator p, File root, FS fs) {
        this(p, root, fs, p.fileModeStrategy);
    }

    protected FileTreeIterator(WorkingTreeIterator p, File root, FS fs, FileModeStrategy fileModeStrategy) {
        super(p);
        this.directory = root;
        this.fs = fs;
        this.fileModeStrategy = fileModeStrategy;
        this.init(this.entries());
    }

    @Override
    public AbstractTreeIterator createSubtreeIterator(ObjectReader reader) throws IncorrectObjectTypeException, IOException {
        return new FileTreeIterator(this, ((FileEntry)this.current()).getFile(), this.fs, this.fileModeStrategy);
    }

    private WorkingTreeIterator.Entry[] entries() {
        File[] all = this.directory.listFiles();
        if (all == null) {
            return EOF;
        }
        WorkingTreeIterator.Entry[] r = new WorkingTreeIterator.Entry[all.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = new FileEntry(all[i], this.fs, this.fileModeStrategy);
        }
        return r;
    }

    public File getDirectory() {
        return this.directory;
    }

    public File getEntryFile() {
        return ((FileEntry)this.current()).getFile();
    }

    @Override
    protected byte[] idSubmodule(WorkingTreeIterator.Entry e) {
        return this.idSubmodule(this.getDirectory(), e);
    }

    @Override
    protected String readSymlinkTarget(WorkingTreeIterator.Entry entry) throws IOException {
        return this.fs.readSymLink(this.getEntryFile());
    }

    public static class DefaultFileModeStrategy
    implements FileModeStrategy {
        public static final DefaultFileModeStrategy INSTANCE = new DefaultFileModeStrategy();

        @Override
        public FileMode getMode(File f, FS.Attributes attributes) {
            if (attributes.isSymbolicLink()) {
                return FileMode.SYMLINK;
            }
            if (attributes.isDirectory()) {
                if (new File(f, ".git").exists()) {
                    return FileMode.GITLINK;
                }
                return FileMode.TREE;
            }
            if (attributes.isExecutable()) {
                return FileMode.EXECUTABLE_FILE;
            }
            return FileMode.REGULAR_FILE;
        }
    }

    public static class FileEntry
    extends WorkingTreeIterator.Entry {
        private final FileMode mode;
        private FS.Attributes attributes;
        private FS fs;

        public FileEntry(File f, FS fs) {
            this(f, fs, DefaultFileModeStrategy.INSTANCE);
        }

        public FileEntry(File f, FS fs, FileModeStrategy fileModeStrategy) {
            this.fs = fs;
            f = fs.normalize(f);
            this.attributes = fs.getAttributes(f);
            this.mode = fileModeStrategy.getMode(f, this.attributes);
        }

        @Override
        public FileMode getMode() {
            return this.mode;
        }

        @Override
        public String getName() {
            return this.attributes.getName();
        }

        @Override
        public long getLength() {
            return this.attributes.getLength();
        }

        @Override
        public long getLastModified() {
            return this.attributes.getLastModifiedTime();
        }

        @Override
        public InputStream openInputStream() throws IOException {
            if (this.fs.isSymLink(this.getFile())) {
                return new ByteArrayInputStream(this.fs.readSymLink(this.getFile()).getBytes("UTF-8"));
            }
            return new FileInputStream(this.getFile());
        }

        public File getFile() {
            return this.attributes.getFile();
        }
    }

    public static interface FileModeStrategy {
        public FileMode getMode(File var1, FS.Attributes var2);
    }

    public static class NoGitlinksStrategy
    implements FileModeStrategy {
        public static final NoGitlinksStrategy INSTANCE = new NoGitlinksStrategy();

        @Override
        public FileMode getMode(File f, FS.Attributes attributes) {
            if (attributes.isSymbolicLink()) {
                return FileMode.SYMLINK;
            }
            if (attributes.isDirectory()) {
                return FileMode.TREE;
            }
            if (attributes.isExecutable()) {
                return FileMode.EXECUTABLE_FILE;
            }
            return FileMode.REGULAR_FILE;
        }
    }
}

