/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.preferences.view;

import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import org.omegat.core.data.CommandVarExpansion;
import org.omegat.gui.preferences.BasePreferencesController;
import org.omegat.gui.preferences.view.SaveOptionsPanel;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;

public class SaveOptionsController
extends BasePreferencesController {
    private SaveOptionsPanel panel;

    @Override
    public JComponent getGui() {
        if (this.panel == null) {
            this.initGui();
            this.initFromPrefs();
        }
        return this.panel;
    }

    @Override
    public String toString() {
        return OStrings.getString("PREFS_TITLE_SAVING_AND_OUTPUT");
    }

    private void initGui() {
        this.panel = new SaveOptionsPanel();
        this.panel.insertButton.addActionListener(e -> this.panel.externalCommandTextArea.replaceSelection(this.panel.variablesList.getSelectedItem().toString()));
    }

    @Override
    protected void initFromPrefs() {
        int saveInterval = Preferences.getPreferenceDefault("auto_save_interval", 180);
        this.panel.minutesSpinner.setValue(saveInterval / 60);
        this.panel.secondsSpinner.setValue(saveInterval % 60);
        this.panel.externalCommandTextArea.setText(Preferences.getPreference("external_command"));
        this.panel.allowProjectCmdCheckBox.setSelected(Preferences.isPreference("allow_project_extern_cmd"));
        this.panel.variablesList.setModel(new DefaultComboBoxModel<String>(new Vector<String>(CommandVarExpansion.getCommandVariables())));
    }

    @Override
    public void restoreDefaults() {
        this.panel.minutesSpinner.setValue(3);
        this.panel.secondsSpinner.setValue(0);
        this.panel.externalCommandTextArea.setText("");
        this.panel.allowProjectCmdCheckBox.setSelected(false);
    }

    @Override
    public void persist() {
        int saveMinutes = 0;
        int saveSeconds = 0;
        try {
            saveMinutes = Integer.parseInt(this.panel.minutesSpinner.getValue().toString());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            saveSeconds = Integer.parseInt(this.panel.secondsSpinner.getValue().toString());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int saveInterval = saveMinutes * 60 + saveSeconds;
        if (saveInterval < 10) {
            saveInterval = 10;
        }
        Preferences.setPreference("auto_save_interval", saveInterval);
        Preferences.setPreference("external_command", this.panel.externalCommandTextArea.getText());
        Preferences.setPreference("allow_project_extern_cmd", this.panel.allowProjectCmdCheckBox.isSelected());
    }
}

