/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.preferences.view;

import java.awt.Desktop;
import java.io.File;
import javax.swing.JComponent;
import org.omegat.core.Core;
import org.omegat.gui.preferences.BasePreferencesController;
import org.omegat.gui.preferences.view.GeneralOptionsPanel;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;

public class GeneralOptionsController
extends BasePreferencesController {
    private GeneralOptionsPanel panel;

    @Override
    public JComponent getGui() {
        if (this.panel == null) {
            this.initGui();
            this.initFromPrefs();
        }
        return this.panel;
    }

    @Override
    public String toString() {
        return OStrings.getString("PREFS_TITLE_GENERAL");
    }

    private void initGui() {
        this.panel = new GeneralOptionsPanel();
        this.panel.accessConfigDirButton.addActionListener(e -> this.openFile(new File(StaticUtils.getConfigDir())));
    }

    private void openFile(File path) {
        try {
            path = path.getCanonicalFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!path.exists()) {
            Core.getMainWindow().showStatusMessageRB("LFC_ERROR_FILE_DOESNT_EXIST", path);
            return;
        }
        try {
            Desktop.getDesktop().open(path);
        }
        catch (Exception ex) {
            Log.logErrorRB(ex, "RPF_ERROR", new Object[0]);
            Core.getMainWindow().displayErrorRB(ex, "RPF_ERROR", new Object[0]);
        }
    }

    @Override
    protected void initFromPrefs() {
        this.panel.tabAdvanceCheckBox.setSelected(Core.getEditor().getSettings().isUseTabForAdvance());
        this.panel.confirmQuitCheckBox.setSelected(Preferences.isPreference("always_confirm_quit"));
    }

    @Override
    public void restoreDefaults() {
        this.panel.tabAdvanceCheckBox.setSelected(false);
        this.panel.confirmQuitCheckBox.setSelected(false);
    }

    @Override
    public void persist() {
        Core.getEditor().getSettings().setUseTabForAdvance(this.panel.tabAdvanceCheckBox.isSelected());
        Preferences.setPreference("always_confirm_quit", this.panel.confirmQuitCheckBox.isSelected());
    }
}

