/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.Serializable;

public class FSID
implements Serializable {
    public static final long ITEM_INDEX_UNUSED = 0L;
    public static final long ITEM_INDEX_CHANGES = 1L;
    public static final long ITEM_INDEX_ROOT_NODE = 2L;
    public static final long ITEM_FIRST_USER = 3L;
    private static final long serialVersionUID = 4845L;
    private String myNodeID;
    private String myCopyID;
    private String myTxnID;
    private long myRevision;
    private long myOffset;

    public boolean isTxn() {
        return this.myTxnID != null;
    }

    public static FSID createTxnId(String nodeId, String copyId, String txnId) {
        return new FSID(nodeId, txnId, copyId, -1L, -1L);
    }

    public static FSID createRevId(String nodeId, String copyId, long revision, long offset) {
        return new FSID(nodeId, null, copyId, revision, offset);
    }

    private FSID(String nodeId, String txnId, String copyId, long revision, long offset) {
        this.myNodeID = nodeId;
        this.myCopyID = copyId;
        this.myTxnID = txnId;
        this.myRevision = revision;
        this.myOffset = offset;
    }

    public FSID copy() {
        return new FSID(this.getNodeID(), this.getTxnID(), this.getCopyID(), this.getRevision(), this.getOffset());
    }

    public String getNodeID() {
        return this.myNodeID;
    }

    public String getTxnID() {
        return this.myTxnID;
    }

    public String getCopyID() {
        return this.myCopyID;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public long getOffset() {
        return this.myOffset;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != FSID.class) {
            return false;
        }
        FSID id = (FSID)obj;
        if (this == id) {
            return true;
        }
        if (this.myNodeID != null && !this.myNodeID.equals(id.getNodeID())) {
            return false;
        }
        if (this.myNodeID == null && id.getNodeID() != null) {
            return false;
        }
        if (this.myCopyID != null && !this.myCopyID.equals(id.getCopyID())) {
            return false;
        }
        if (this.myCopyID == null && id.getCopyID() != null) {
            return false;
        }
        if (this.myTxnID != null && !this.myTxnID.equals(id.getTxnID())) {
            return false;
        }
        if (this.myTxnID == null && id.getTxnID() != null) {
            return false;
        }
        return this.myRevision == id.getRevision() && this.myOffset == id.getOffset();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.myNodeID == null ? 0 : this.myNodeID.hashCode());
        result = 31 * result + (this.myCopyID == null ? 0 : this.myCopyID.hashCode());
        result = 31 * result + (this.myTxnID == null ? 0 : this.myTxnID.hashCode());
        result = 31 * result + (int)(this.myRevision ^ this.myRevision >>> 32);
        result = 31 * result + (int)(this.myOffset ^ this.myOffset >>> 32);
        return result;
    }

    public int compareTo(FSID otherID) {
        if (otherID == null) {
            return -1;
        }
        if (otherID.equals(this)) {
            return 0;
        }
        return this.isRelated(otherID) ? 1 : -1;
    }

    public boolean isRelated(FSID otherID) {
        if (otherID == null) {
            return false;
        }
        if (this == otherID) {
            return true;
        }
        if (this.myNodeID != null && this.myNodeID.startsWith("_")) {
            if (this.myTxnID != null && !this.myTxnID.equals(otherID.getTxnID())) {
                return false;
            }
            if (this.myTxnID == null && otherID.getTxnID() != null) {
                return false;
            }
        }
        return this.myNodeID.equals(otherID.getNodeID());
    }

    public String toString() {
        return this.myNodeID + "." + this.myCopyID + "." + (this.isTxn() ? "t" + this.myTxnID : "r" + this.myRevision + "/" + this.myOffset);
    }

    public static FSID fromString(String revNodeId) {
        int dotInd = revNodeId.indexOf(46);
        if (dotInd == -1) {
            return null;
        }
        String nodeId = revNodeId.substring(0, dotInd);
        if ((dotInd = (revNodeId = revNodeId.substring(dotInd + 1)).indexOf(46)) == -1) {
            return null;
        }
        String copyId = revNodeId.substring(0, dotInd);
        if ((revNodeId = revNodeId.substring(dotInd + 1)).charAt(0) == 'r') {
            int slashInd = revNodeId.indexOf(47);
            long rev = -1L;
            long offset = -1L;
            try {
                rev = Long.parseLong(revNodeId.substring(1, slashInd));
                offset = Long.parseLong(revNodeId.substring(slashInd + 1));
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            return FSID.createRevId(nodeId, copyId, rev, offset);
        }
        if (revNodeId.charAt(0) == 't') {
            String txnId = revNodeId.substring(1);
            return FSID.createTxnId(nodeId, copyId, txnId);
        }
        return null;
    }
}

