/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import net.loomchild.maligna.coretypes.Alignment;
import net.loomchild.maligna.util.IORuntimeException;
import net.loomchild.maligna.util.ResourceNotFoundException;

public class Util {
    public static final int READ_BUFFER_SIZE = 1024;

    public static List<Alignment> alignManyToZero(List<String> sourceSegmentList) {
        Alignment alignment = new Alignment();
        alignment.addSourceSegmentList(sourceSegmentList);
        return Collections.singletonList(alignment);
    }

    public static List<Alignment> alignZeroToMany(List<String> targetSegmentList) {
        Alignment alignment = new Alignment();
        alignment.addTargetSegmentList(targetSegmentList);
        return Collections.singletonList(alignment);
    }

    public static List<Alignment> alignManyToMany(List<String> sourceSegmentList, List<String> targetSegmentList) {
        Alignment alignment = new Alignment(sourceSegmentList, targetSegmentList, 0.0f);
        return Collections.singletonList(alignment);
    }

    public static double toScore(double probability) {
        return -Math.log(probability);
    }

    public static double toProbability(double score) {
        return Math.exp(-score);
    }

    public static float scoreSum(List<Float> scoreList) {
        float scoreSum;
        if (scoreList.size() == 0) {
            scoreSum = 0.0f;
        } else {
            float minScore = Collections.min(scoreList).floatValue();
            if (minScore == Float.POSITIVE_INFINITY) {
                scoreSum = Float.POSITIVE_INFINITY;
            } else {
                double probabilitySum = 0.0;
                for (float score : scoreList) {
                    double probability = Util.toProbability(score - minScore);
                    probabilitySum += probability;
                }
                double probabilityScore = Util.toScore(probabilitySum);
                scoreSum = (float)((double)minScore + probabilityScore);
            }
        }
        return scoreSum;
    }

    public static String merge(List<String> stringList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringList) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static double round(double number, int precision) {
        double cutter = Math.pow(10.0, precision);
        return (double)((int)(number * cutter)) / cutter;
    }

    public static BufferedReader getReader(InputStream inputStream) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
            return reader;
        }
        catch (UnsupportedEncodingException e) {
            throw new IORuntimeException(e);
        }
    }

    public static PrintWriter getWriter(OutputStream outputStream) {
        try {
            return new PrintWriter((Writer)new OutputStreamWriter(outputStream, "utf-8"), true);
        }
        catch (UnsupportedEncodingException e) {
            throw new IORuntimeException(e);
        }
    }

    public static FileInputStream getFileInputStream(String fileName) {
        try {
            return new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            throw new IORuntimeException(e);
        }
    }

    public static FileOutputStream getFileOutputStream(String fileName) {
        try {
            return new FileOutputStream(fileName);
        }
        catch (FileNotFoundException e) {
            throw new IORuntimeException(e);
        }
    }

    public static InputStream getResourceStream(String name) {
        InputStream inputStream = Util.class.getClassLoader().getResourceAsStream(name);
        if (inputStream == null) {
            throw new ResourceNotFoundException(name);
        }
        return inputStream;
    }

    public static String readAll(Reader reader) {
        StringWriter writer = new StringWriter();
        Util.copyAll(reader, writer);
        return writer.toString();
    }

    public static void copyAll(Reader reader, Writer writer) {
        try {
            int count;
            char[] readBuffer = new char[1024];
            while ((count = reader.read(readBuffer)) != -1) {
                writer.write(readBuffer, 0, count);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

