/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm;

import edu.berkeley.nlp.lm.ArrayEncodedNgramLanguageModel;
import edu.berkeley.nlp.lm.WordIndexer;
import edu.berkeley.nlp.lm.collections.Counter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public interface NgramLanguageModel<W> {
    public int getLmOrder();

    public WordIndexer<W> getWordIndexer();

    public float scoreSentence(List<W> var1);

    public float getLogProb(List<W> var1);

    public void setOovWordLogProb(float var1);

    public static class StaticMethods {
        public static <T> int[] toIntArray(List<T> ngram, ArrayEncodedNgramLanguageModel<T> lm) {
            int[] ints = new int[ngram.size()];
            WordIndexer<T> wordIndexer = lm.getWordIndexer();
            for (int i = 0; i < ngram.size(); ++i) {
                ints[i] = wordIndexer.getIndexPossiblyUnk(ngram.get(i));
            }
            return ints;
        }

        public static <T> List<T> toObjectList(int[] ngram, ArrayEncodedNgramLanguageModel<T> lm) {
            ArrayList ret = new ArrayList(ngram.length);
            WordIndexer wordIndexer = lm.getWordIndexer();
            for (int i = 0; i < ngram.length; ++i) {
                ret.add(wordIndexer.getWord(ngram[i]));
            }
            return ret;
        }

        public static <W> List<W> sample(Random random, NgramLanguageModel<W> lm) {
            return StaticMethods.sample(random, lm, 1.0);
        }

        public static <W> List<W> sample(Random random, NgramLanguageModel<W> lm, double sampleTemperature) {
            Object sample;
            ArrayList<Object> ret = new ArrayList<Object>();
            ret.add(lm.getWordIndexer().getStartSymbol());
            do {
                int contextEnd = ret.size();
                int contextStart = Math.max(0, contextEnd - lm.getLmOrder() + 1);
                Counter<W> c = new Counter<W>();
                ArrayList<W> ngram = new ArrayList<W>(ret.subList(contextStart, contextEnd));
                ngram.add(null);
                for (int index = 0; index < lm.getWordIndexer().numWords(); ++index) {
                    W word = lm.getWordIndexer().getWord(index);
                    if (word.equals(lm.getWordIndexer().getStartSymbol()) || ret.size() <= 1 && word.equals(lm.getWordIndexer().getEndSymbol())) continue;
                    ngram.set(ngram.size() - 1, word);
                    c.setCount(word, Math.exp(sampleTemperature * (double)lm.getLogProb(ngram) * Math.log(10.0)));
                }
                sample = c.sample(random);
                ret.add(sample);
            } while (!sample.equals(lm.getWordIndexer().getEndSymbol()));
            return ret.subList(1, ret.size() - 1);
        }
    }
}

