/**
 * Filters are objects that know how to "filter out" nodes. If a NodeIterator or TreeWalker is given a NodeFilter, it applies the filter before it returns the next node. If the filter says to accept the node, the traversal logic returns it; otherwise, traversal looks for the next node and pretends that the node that was rejected was not there.The DOM does not provide any filters. NodeFilter is just an interface that users can implement to provide their own filters.NodeFilters do not need to know how to traverse from node to node, nor do they need to know anything about the data structure that is being traversed. This makes it very easy to write filters, since the only thing they have to know how to do is evaluate a single node. One filter may be used with a number of different kinds of traversals, encouraging code reuse.
 */
var NodeFilter = {
}
/**
 * Show ProcessingInstruction nodes.
 * @syntax NodeFilter.SHOW_PROCESSING_INSTRUCTION
 * @returns {Number} 
 * @static
 */
NodeFilter.SHOW_PROCESSING_INSTRUCTION = new Number();

/**
 * Reject the node. Navigation methods defined for NodeIterator or TreeWalker will not return this node. For TreeWalker, the children of this node will also be rejected. NodeIterators treat this as a synonym for FILTER_SKIP.
 * @syntax NodeFilter.FILTER_REJECT
 * @returns {Number} 
 * @static
 */
NodeFilter.FILTER_REJECT = new Number();

/**
 * Test whether a specified node is visible in the logical view of a TreeWalker or NodeIterator. This function will be called by the implementation of TreeWalker and NodeIterator; it is not normally called directly from user code. (Though you could do so if you wanted to use the same filter to guide your own application logic.)
 * @syntax nodeFilter.acceptNode(n)
 * @param {Node} n The node to check to see if it passes the filter or not.
 * @returns {Number} a constant to determine whether the node is accepted, rejected, or skipped, as defined above.
 */
NodeFilter.prototype.acceptNode = function(n) {};

/**
 * Skip this single node. Navigation methods defined for NodeIterator or TreeWalker will not return this node. For both NodeIterator and TreeWalker, the children of this node will still be considered.
 * @syntax NodeFilter.FILTER_SKIP
 * @returns {Number} 
 * @static
 */
NodeFilter.FILTER_SKIP = new Number();

/**
 * Show all Nodes.
 * @syntax NodeFilter.SHOW_ALL
 * @returns {Number} 
 * @static
 */
NodeFilter.SHOW_ALL = new Number();

/**
 * Show DocumentType nodes.
 * @syntax NodeFilter.SHOW_DOCUMENT_TYPE
 * @returns {Number} 
 * @static
 */
NodeFilter.SHOW_DOCUMENT_TYPE = new Number();

/**
 * Show Element nodes.
 * @syntax NodeFilter.SHOW_ELEMENT
 * @returns {Number} 
 * @static
 */
NodeFilter.SHOW_ELEMENT = new Number();

/**
 * Show EntityReference nodes.
 * @syntax NodeFilter.SHOW_ENTITY_REFERENCE
 * @returns {Number} 
 * @static
 */
NodeFilter.SHOW_ENTITY_REFERENCE = new Number();

/**
 * Show Notation nodes. This is meaningful only when creating an iterator or tree-walker with a Notation node as its root; in this case, it means that the Notation node will appear in the first position of the traversal. Since notations are not part of the document tree, they do not appear when traversing over the document tree.
 * @syntax NodeFilter.SHOW_NOTATION
 * @returns {Number} 
 * @static
 */
NodeFilter.SHOW_NOTATION = new Number();

/**
 * Show Comment nodes.
 * @syntax NodeFilter.SHOW_COMMENT
 * @returns {Number} 
 * @static
 */
NodeFilter.SHOW_COMMENT = new Number();

/**
 * Show Entity nodes. This is meaningful only when creating an iterator or tree-walker with an Entity node as its root; in this case, it means that the Entity node will appear in the first position of the traversal. Since entities are not part of the document tree, they do not appear when traversing over the document tree.
 * @syntax NodeFilter.SHOW_ENTITY
 * @returns {Number} 
 * @static
 */
NodeFilter.SHOW_ENTITY = new Number();

/**
 * Show CDATASection nodes.
 * @syntax NodeFilter.SHOW_CDATA_SECTION
 * @returns {Number} 
 * @static
 */
NodeFilter.SHOW_CDATA_SECTION = new Number();

/**
 * Show Attr nodes. This is meaningful only when creating an iterator or tree-walker with an attribute node as its root; in this case, it means that the attribute node will appear in the first position of the iteration or traversal. Since attributes are never children of other nodes, they do not appear when traversing over the document tree.
 * @syntax NodeFilter.SHOW_ATTRIBUTE
 * @returns {Number} 
 * @static
 */
NodeFilter.SHOW_ATTRIBUTE = new Number();

/**
 * Show Document nodes.
 * @syntax NodeFilter.SHOW_DOCUMENT
 * @returns {Number} 
 * @static
 */
NodeFilter.SHOW_DOCUMENT = new Number();

/**
 * Show DocumentFragment nodes.
 * @syntax NodeFilter.SHOW_DOCUMENT_FRAGMENT
 * @returns {Number} 
 * @static
 */
NodeFilter.SHOW_DOCUMENT_FRAGMENT = new Number();

/**
 * Show Text nodes.
 * @syntax NodeFilter.SHOW_TEXT
 * @returns {Number} 
 * @static
 */
NodeFilter.SHOW_TEXT = new Number();

/**
 * Accept the node. Navigation methods defined for NodeIterator or TreeWalker will return this node.
 * @syntax NodeFilter.FILTER_ACCEPT
 * @returns {Number} 
 * @static
 */
NodeFilter.FILTER_ACCEPT = new Number();

/**
 * Represents the NodeFilter prototype object.
 * @syntax NodeFilter.prototype
 * @static
 */
NodeFilter.prototype;

