/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.project;

import java.util.Map;
import java.util.Properties;
import org.netbeans.api.project.Project;
import org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities;
import org.openide.filesystems.FileObject;

public abstract class AntProjectSupportProvider {
    public abstract FileObject getProjectBuildScript();

    public abstract FileObject getProjectBuildScript(String var1);

    public abstract void configurePropertiesForProfiling(Map<String, String> var1, FileObject var2);

    public static abstract class Abstract
    extends AntProjectSupportProvider {
        private final Project project;

        @Override
        public FileObject getProjectBuildScript() {
            String buildFileName;
            FileObject buildFile = null;
            Properties props = ProjectUtilities.getProjectProperties((Project)this.getProject());
            String string = buildFileName = props != null ? props.getProperty("buildfile") : null;
            if (buildFileName != null) {
                buildFile = this.getProjectBuildScript(buildFileName);
            }
            if (buildFile == null) {
                buildFile = this.getProjectBuildScript("build.xml");
            }
            return buildFile;
        }

        @Override
        public FileObject getProjectBuildScript(String buildFileName) {
            return this.getProject().getProjectDirectory().getFileObject(buildFileName);
        }

        @Override
        public void configurePropertiesForProfiling(Map<String, String> props, FileObject profiledClassFile) {
        }

        protected final Project getProject() {
            return this.project;
        }

        protected Abstract(Project project) {
            this.project = project;
        }
    }

    static class Basic
    extends AntProjectSupportProvider {
        Basic() {
        }

        @Override
        public FileObject getProjectBuildScript() {
            return null;
        }

        @Override
        public FileObject getProjectBuildScript(String buildFileName) {
            return null;
        }

        @Override
        public void configurePropertiesForProfiling(Map<String, String> props, FileObject profiledClassFile) {
        }
    }
}

