/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.sunresources.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.sun.api.restricted.ResourceUtils;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.CommonAttributePanel;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigData;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigHelper;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.Util;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.setFocus;
import org.netbeans.modules.j2ee.sun.sunresources.beans.Field;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldGroup;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldHelper;
import org.netbeans.modules.j2ee.sun.sunresources.beans.WizardConstants;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CommonAttributeVisualPanel
extends JPanel
implements ChangeListener,
WizardConstants {
    public static final String TYPE_JDBC_RESOURCE = "_DS";
    public static final String TYPE_PERSISTENCE_MANAGER = "_PM";
    public static final String TYPE_CP_POOL_SETTING = "_CP_SETTING";
    protected ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.Bundle");
    protected final CommonAttributePanel panel;
    protected FieldGroup[] groups;
    protected int fieldSize;
    protected ResourceConfigHelper helper;
    protected String panelType = "_DS";
    protected boolean createNewResource = false;
    protected JTextArea descriptionTextArea = null;
    protected JPanel[] jPanel1 = null;
    protected JLabel[] jLabels = null;
    protected JComponent[] jFields = null;
    protected Field[] fields = null;
    protected String resourceName;
    protected boolean showGroupTitle = false;
    private JRadioButton existingResourceRadioButton;
    private JRadioButton newResourceRadioButton;
    private JPanel jPanel0;
    private JComboBox existingResourceComboBox;
    private boolean firstTime = true;
    private int y = 0;

    public CommonAttributeVisualPanel(CommonAttributePanel panel, FieldGroup[] groups, String panelType, ResourceConfigHelper helper) {
        this.panel = panel;
        this.helper = helper;
        this.resourceName = panel.getResourceName();
        this.setFieldGroups(groups);
        this.setName(NbBundle.getMessage(CommonAttributeVisualPanel.class, (String)("TITLE_" + groups[0].getName())));
        if (groups.length > 1) {
            this.showGroupTitle = true;
        }
        this.setLayout(new GridBagLayout());
        if (!this.showGroupTitle) {
            this.initDescriptionComponent();
        }
        this.setPanelType(panelType);
        if (this.getPanelType().equals(TYPE_JDBC_RESOURCE) || this.getPanelType().equals(TYPE_PERSISTENCE_MANAGER)) {
            this.initChoiceComponents();
            this.initComponents();
        } else {
            this.initComponents();
        }
        this.getAccessibleContext().setAccessibleName(this.bundle.getString("TITLE_ConnPoolWizardPanel_optionalProps"));
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("TITLE_ConnPoolWizardPanel_optionalProps"));
        this.refreshFields();
        this.firstTime = false;
    }

    public void setFieldGroups(FieldGroup[] groups) {
        this.groups = groups;
        this.fieldSize = 0;
        for (int i = 0; i < groups.length; ++i) {
            this.fieldSize += groups[i].sizeField();
        }
    }

    private void initComponents() {
        int gap = 0;
        int itemHeight = 28;
        if (this.fieldSize < 6) {
            itemHeight = 42;
            gap = 7;
        }
        int i = 0;
        this.jPanel1 = new JPanel[this.groups.length];
        this.fields = new Field[this.fieldSize];
        this.jLabels = new JLabel[this.fieldSize];
        this.jFields = new JComponent[this.fieldSize];
        for (int j = 0; j < this.groups.length; ++j) {
            GridBagConstraints gridBagConstraints;
            if (this.showGroupTitle) {
                JLabel label = new JLabel();
                label.setText(this.bundle.getString("LBL_GROUP_" + this.groups[j].getName()));
                label.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_LBL_GROUP_" + this.groups[j].getName() + "A11yDesc"));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = this.y++;
                gridBagConstraints.fill = 2;
                gridBagConstraints.ipadx = 0;
                gridBagConstraints.insets = new Insets(5, 0, 0, 11);
                this.add((Component)label, gridBagConstraints);
            }
            Field[] flds = this.groups[j].getField();
            int size = flds.length;
            this.jPanel1[j] = new JPanel();
            this.jPanel1[j].setLayout(new GridBagLayout());
            this.jPanel1[j].setMaximumSize(new Dimension(480, itemHeight * size));
            this.jPanel1[j].setMinimumSize(new Dimension(480, itemHeight * size));
            this.jPanel1[j].setPreferredSize(new Dimension(480, itemHeight * size));
            for (int k = 0; k < size; ++k) {
                this.fields[i] = flds[k];
                JLabel jLabel = new JLabel();
                Mnemonics.setLocalizedText((JLabel)jLabel, (String)this.bundle.getString("LBL_" + this.fields[i].getName()));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = k;
                gridBagConstraints.fill = 2;
                gridBagConstraints.ipadx = 0;
                gridBagConstraints.insets = new Insets(2, 12, gap, 0);
                this.jLabels[i] = jLabel;
                this.jPanel1[j].add((Component)this.jLabels[i], gridBagConstraints);
                if (FieldHelper.isList(this.fields[i])) {
                    JComboBox<String> jComboBox = new JComboBox<String>();
                    jLabel.setLabelFor(jComboBox);
                    jComboBox.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ToolTip_" + this.fields[i].getName()));
                    String[] tags = FieldHelper.getTags(this.fields[i]);
                    for (int h = 0; h < tags.length; ++h) {
                        jComboBox.addItem(tags[h]);
                    }
                    final int index = i;
                    jComboBox.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            CommonAttributeVisualPanel.this.jComboBoxActionPerformed(evt, index);
                        }
                    });
                    gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.gridy = k;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.insets = new Insets(2, 20, gap, 0);
                    gridBagConstraints.weightx = 1.0;
                    this.jFields[i] = jComboBox;
                    this.jPanel1[j].add(jComboBox, gridBagConstraints);
                } else {
                    JTextField jTextField;
                    if (FieldHelper.isInt(this.fields[i])) {
                        jTextField = new JTextField(Util.getNumericDocument(), null, 0);
                    } else {
                        jTextField = new JTextField();
                        jTextField.setText("jTextField1");
                    }
                    jLabel.setLabelFor(jTextField);
                    jTextField.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ToolTip_" + this.fields[i].getName()));
                    jTextField.setToolTipText(this.bundle.getString("ToolTip_" + this.fields[i].getName()));
                    jTextField.setMinimumSize(new Dimension(340, 21));
                    jTextField.setPreferredSize(new Dimension(340, 21));
                    final int index = i;
                    jTextField.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyReleased(KeyEvent evt) {
                            CommonAttributeVisualPanel.this.jTextField1KeyReleased(evt, index);
                        }
                    });
                    gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.gridy = k;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.insets = new Insets(2, 20, gap, 0);
                    this.jFields[i] = jTextField;
                    this.jPanel1[j].add((Component)jTextField, gridBagConstraints);
                }
                ++i;
            }
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = this.y++;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 0, 10, 11);
            this.jPanel1[j].setBorder(new EtchedBorder());
            this.add((Component)this.jPanel1[j], gridBagConstraints);
        }
    }

    private void initDescriptionComponent() {
        this.descriptionTextArea = new JTextArea();
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setFont(UIManager.getFont("Label.font"));
        this.descriptionTextArea.setText(this.bundle.getString(this.resourceName + "_Description"));
        this.descriptionTextArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.descriptionTextArea.setRequestFocusEnabled(false);
        this.descriptionTextArea.setEnabled(false);
        this.descriptionTextArea.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.y++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(12, 12, 20, 11);
        this.add((Component)this.descriptionTextArea, gridBagConstraints);
    }

    private void jComboBoxActionPerformed(ActionEvent evt, int index) {
        String fieldName;
        String val;
        ResourceConfigData data = this.helper.getData();
        String item = (String)((JComboBox)this.jFields[index]).getSelectedItem();
        if (!item.equals(val = data.getString(fieldName = this.fields[index].getName()))) {
            data.setString(fieldName, item);
        }
    }

    private void jTextField1KeyReleased(KeyEvent evt, int index) {
        ResourceConfigData data = this.helper.getData();
        String item = ((JTextField)this.jFields[index]).getText();
        String fieldName = this.fields[index].getName();
        String val = data.getString(fieldName);
        String jLabel = this.jLabels[index].getText();
        if (!item.equals(val)) {
            data.setString(fieldName, item);
        }
        this.panel.fireChange(this);
    }

    private void initChoiceComponents() {
        this.jPanel0 = new JPanel();
        ButtonGroup bg = new ButtonGroup();
        this.existingResourceRadioButton = new JRadioButton();
        this.existingResourceComboBox = new JComboBox();
        this.newResourceRadioButton = new JRadioButton();
        this.jPanel0.setMaximumSize(new Dimension(480, 150));
        this.jPanel0.setMinimumSize(new Dimension(480, 150));
        this.jPanel0.setPreferredSize(new Dimension(480, 150));
        this.jPanel0.setLayout(new GridBagLayout());
        this.jPanel0.setBorder(new EtchedBorder());
        this.existingResourceRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.existingResourceRadioButton, (String)this.bundle.getString("ExistingResource" + this.getPanelType()));
        this.existingResourceRadioButton.setToolTipText(this.bundle.getString("ACS_ExistingResourceA11yDesc" + this.getPanelType()));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.jPanel0.add((Component)this.existingResourceRadioButton, gridBagConstraints);
        this.existingResourceComboBox.setToolTipText(this.bundle.getString("ACS_ExistingResourceComboBoxA11yDesc" + this.getPanelType()));
        this.existingResourceComboBox.getAccessibleContext().setAccessibleName(this.bundle.getString("ExistingResource" + this.getPanelType()));
        this.existingResourceComboBox.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_ExistingResourceComboBoxA11yDesc" + this.getPanelType()));
        this.existingResourceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommonAttributeVisualPanel.this.existingResourceComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 24, 5, 11);
        this.jPanel0.add((Component)this.existingResourceComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.newResourceRadioButton, (String)this.bundle.getString("NewResource" + this.getPanelType()));
        this.newResourceRadioButton.setToolTipText(this.bundle.getString("ACS_NewResourceA11yDesc" + this.getPanelType()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.jPanel0.add((Component)this.newResourceRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.y++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 40, 0);
        this.add((Component)this.jPanel0, gridBagConstraints);
        bg.add(this.existingResourceRadioButton);
        bg.add(this.newResourceRadioButton);
        bg.getSelection().addChangeListener(this);
        List list = null;
        if (this.getPanelType().equals(TYPE_JDBC_RESOURCE)) {
            list = ResourceUtils.getRegisteredConnectionPools(this.helper.getData());
        } else if (this.getPanelType().equals(TYPE_PERSISTENCE_MANAGER)) {
            list = ResourceUtils.getRegisteredJdbcResources(this.helper.getData());
        }
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                this.existingResourceComboBox.addItem(list.get(i));
            }
        }
        if (this.existingResourceComboBox.getItemCount() == 0) {
            this.existingResourceComboBox.insertItemAt(this.bundle.getString("NoResource" + this.getPanelType()), 0);
            this.existingResourceRadioButton.setEnabled(true);
            this.existingResourceComboBox.setEnabled(true);
        } else {
            this.existingResourceComboBox.insertItemAt(this.bundle.getString("SelectFromTheList"), 0);
            this.existingResourceRadioButton.setSelected(true);
            this.newResourceRadioButton.setSelected(false);
        }
        this.existingResourceComboBox.setSelectedIndex(0);
    }

    @Override
    public void stateChanged(ChangeEvent p1) {
        if (p1.getSource().getClass() == JToggleButton.ToggleButtonModel.class) {
            if (this.existingResourceRadioButton.isSelected()) {
                this.existingResourceComboBox.setEnabled(true);
                this.setExistingResourceData();
            } else {
                this.existingResourceComboBox.setEnabled(false);
                this.setNewResourceData();
            }
            if (!this.firstTime) {
                this.panel.fireChange(this);
            }
        }
    }

    private void existingResourceComboBoxActionPerformed(ActionEvent evt) {
        this.setExistingResourceData();
    }

    public boolean isNewResourceSelected() {
        return this.createNewResource;
    }

    public void setExistingResourceData() {
        ResourceConfigData data = this.helper.getData();
        if (this.existingResourceComboBox.getSelectedIndex() > 0) {
            String name = this.existingResourceComboBox.getSelectedItem().toString();
            if (this.getPanelType().equals(TYPE_JDBC_RESOURCE)) {
                data.setString("pool-name", name);
            } else if (this.getPanelType().equals(TYPE_PERSISTENCE_MANAGER)) {
                data.setString("jdbc-resource-jndi-name", name);
            }
        } else if (!this.firstTime) {
            if (this.getPanelType().equals(TYPE_JDBC_RESOURCE)) {
                data.setString("pool-name", "");
            } else if (this.getPanelType().equals(TYPE_PERSISTENCE_MANAGER)) {
                data.setString("jdbc-resource-jndi-name", "");
            }
        }
        if (!this.firstTime) {
            this.panel.fireChange(this);
        }
        this.createNewResource = false;
    }

    public void setNewResourceData() {
        this.createNewResource = true;
    }

    public void refreshFields() {
        ResourceConfigData data = this.helper.getData();
        for (int i = 0; i < this.jFields.length; ++i) {
            String val;
            String item = FieldHelper.isList(this.fields[i]) ? (String)((JComboBox)this.jFields[i]).getSelectedItem() : ((JTextField)this.jFields[i]).getText();
            String fieldName = this.fields[i].getName();
            Object value = data.get(fieldName);
            if (value == null) {
                String helperJndiName;
                value = FieldHelper.getDefaultValue(this.fields[i]);
                if (fieldName.equals("jndi-name") && (helperJndiName = data.getTargetFile()) != null && (this.getPanelType().equals(TYPE_JDBC_RESOURCE) || this.getPanelType().equals(TYPE_PERSISTENCE_MANAGER))) {
                    value = value + helperJndiName;
                }
                data.set(fieldName, value);
            }
            if (item.equals(val = (String)value)) continue;
            if (FieldHelper.isList(this.fields[i])) {
                ((JComboBox)this.jFields[i]).setSelectedItem(val);
                continue;
            }
            ((JTextField)this.jFields[i]).setText(val);
        }
        if (this.getPanelType().equals(TYPE_JDBC_RESOURCE)) {
            String selPool = data.getString("pool-name");
            this.existingResourceComboBox.setSelectedItem(selPool);
        } else if (this.getPanelType().equals(TYPE_PERSISTENCE_MANAGER)) {
            String selJDBC = data.getString("jdbc-resource-jndi-name");
            this.existingResourceComboBox.setSelectedItem(selJDBC);
        }
    }

    public CommonAttributeVisualPanel setFirstTime(boolean first) {
        this.firstTime = first;
        return this;
    }

    public void initData() {
        this.refreshFields();
    }

    protected String getPanelType() {
        return this.panelType;
    }

    protected void setPanelType(String type) {
        this.panelType = type;
    }

    public void setInitialFocus() {
        new setFocus(this.existingResourceRadioButton);
    }

    public void setPropInitialFocus() {
        new setFocus(this.jFields[0]);
    }

    public void setHelper(ResourceConfigHelper helper) {
        this.helper = helper;
        this.helper.getData().setString("jndi-name", helper.getData().getTargetFile());
        this.refreshFields();
    }
}

