/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContext;

public class InjectionApplicationFactory
extends ApplicationFactory {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private Application defaultApplication;
    private Field defaultApplicationField;
    private volatile Application application;

    public InjectionApplicationFactory(ApplicationFactory delegate) {
        super(delegate);
        Util.notNull("applicationFactory", delegate);
    }

    @Override
    public Application getApplication() {
        if (this.application == null) {
            this.application = this.getWrapped().getApplication();
            if (this.application == null) {
                String message = MessageFormat.format("Delegate ApplicationContextFactory, {0}, returned null when calling getApplication().", this.getWrapped().getClass().getName());
                throw new IllegalStateException(message);
            }
            this.injectDefaultApplication();
        }
        return this.application;
    }

    @Override
    public synchronized void setApplication(Application application) {
        this.application = application;
        this.getWrapped().setApplication(application);
        this.injectDefaultApplication();
    }

    private void injectDefaultApplication() {
        block7: {
            if (this.defaultApplication == null) {
                FacesContext ctx = FacesContext.getCurrentInstance();
                this.defaultApplication = InjectionApplicationFactory.removeApplicationInstance(ctx.getExternalContext().getApplicationMap());
            }
            if (this.defaultApplication != null) {
                try {
                    if (this.defaultApplicationField == null) {
                        this.defaultApplicationField = Application.class.getDeclaredField("defaultApplication");
                        this.defaultApplicationField.setAccessible(true);
                    }
                    this.defaultApplicationField.set(this.application, this.defaultApplication);
                }
                catch (NoSuchFieldException nsfe) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Unable to find private field named 'defaultApplication' in javax.faces.application.Application.");
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block7;
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
            }
        }
    }

    static void setApplicationInstance(Application app) {
        Map<String, Object> appMap = FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
        appMap.put(InjectionApplicationFactory.class.getName(), app);
    }

    static Application removeApplicationInstance(Map<String, Object> appMap) {
        return (Application)appMap.remove(InjectionApplicationFactory.class.getName());
    }
}

