/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.polyglot.HostClassCache;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotTargetMapping;
import com.oracle.truffle.polyglot.TargetMappingNodeGen;
import com.oracle.truffle.polyglot.ToHostNode;
import java.util.function.Function;
import java.util.function.Predicate;

@GenerateUncached
abstract class TargetMappingNode
extends Node {
    public static final Object NO_RESULT = new Object();

    TargetMappingNode() {
    }

    abstract Object execute(Object var1, Class<?> var2, PolyglotLanguageContext var3, InteropLibrary var4, boolean var5, int var6, int var7);

    @Specialization(guards={"targetType != null"})
    @ExplodeLoop
    protected Object doCached(Object operand, Class<?> targetType, PolyglotLanguageContext context, InteropLibrary interop, boolean checkOnly, int startPriority, int endPriority, @Cached(value="getMappings(context, targetType)", dimensions=1) PolyglotTargetMapping[] mappings, @Cached(value="createMappingNodes(mappings)") SingleMappingNode[] mappingNodes) {
        assert (startPriority <= endPriority);
        Object result = NO_RESULT;
        if (mappingNodes != null) {
            for (int i = 0; i < mappingNodes.length; ++i) {
                PolyglotTargetMapping mapping = mappings[i];
                if (mapping.hostPriority >= startPriority && (mapping.hostPriority > endPriority || (result = mappingNodes[i].execute(operand, mappings[i], context, interop, checkOnly)) != NO_RESULT)) break;
            }
        }
        return result;
    }

    @Specialization(replaces={"doCached"})
    @CompilerDirectives.TruffleBoundary
    protected Object doUncached(Object operand, Class<?> targetType, PolyglotLanguageContext context, InteropLibrary interop, boolean checkOnly, int startPriority, int endPriority) {
        assert (startPriority <= endPriority);
        Object result = NO_RESULT;
        PolyglotTargetMapping[] mappings = TargetMappingNode.getMappings(context, targetType);
        if (mappings != null) {
            SingleMappingNode uncachedNode = TargetMappingNodeGen.SingleMappingNodeGen.getUncached();
            for (int i = 0; i < mappings.length; ++i) {
                PolyglotTargetMapping mapping = mappings[i];
                if (mapping.hostPriority >= startPriority && (mapping.hostPriority > endPriority || (result = uncachedNode.execute(operand, mappings[i], context, interop, checkOnly)) != NO_RESULT)) break;
            }
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    static PolyglotTargetMapping[] getMappings(PolyglotLanguageContext context, Class<?> targetType) {
        if (context == null) {
            return HostClassCache.EMPTY_MAPPINGS;
        }
        return context.getEngine().getHostClassCache().getMappings(targetType);
    }

    @CompilerDirectives.TruffleBoundary
    static SingleMappingNode[] createMappingNodes(PolyglotTargetMapping[] mappings) {
        if (mappings == null) {
            return null;
        }
        SingleMappingNode[] nodes = new SingleMappingNode[mappings.length];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = TargetMappingNodeGen.SingleMappingNodeGen.create();
        }
        return nodes;
    }

    static TargetMappingNode create() {
        return TargetMappingNodeGen.create();
    }

    static TargetMappingNode getUncached() {
        return TargetMappingNodeGen.getUncached();
    }

    @GenerateUncached
    static abstract class SingleMappingNode
    extends Node {
        SingleMappingNode() {
        }

        abstract Object execute(Object var1, PolyglotTargetMapping var2, PolyglotLanguageContext var3, InteropLibrary var4, boolean var5);

        @Specialization
        protected Object doDefault(Object receiver, PolyglotTargetMapping cachedMapping, PolyglotLanguageContext context, InteropLibrary interop, boolean checkOnly, @Cached ConditionProfile acceptsProfile, @Cached(value="allowsImplementation(context, cachedMapping.sourceType)", allowUncached=true) boolean allowsImplementation, @Cached ToHostNode toHostRecursive) {
            CompilerAsserts.partialEvaluationConstant(checkOnly);
            Object convertedValue = NO_RESULT;
            if (acceptsProfile.profile(ToHostNode.canConvert(receiver, cachedMapping.sourceType, cachedMapping.sourceType, allowsImplementation, context, 7, interop, null))) {
                if (!checkOnly || cachedMapping.accepts != null) {
                    convertedValue = toHostRecursive.execute(receiver, cachedMapping.sourceType, cachedMapping.sourceType, context, false);
                }
            } else {
                return NO_RESULT;
            }
            if (cachedMapping.accepts != null && !SingleMappingNode.checkPredicate(context, convertedValue, cachedMapping.accepts)) {
                return NO_RESULT;
            }
            if (checkOnly) {
                return Boolean.TRUE;
            }
            return SingleMappingNode.convert(context, cachedMapping.converter, convertedValue);
        }

        static boolean allowsImplementation(PolyglotLanguageContext context, Class<?> type) {
            return ToHostNode.allowsImplementation(context, type);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object convert(PolyglotLanguageContext languageContext, Function<Object, Object> converter, Object value) {
            try {
                return converter.apply(value);
            }
            catch (ClassCastException t) {
                throw PolyglotEngineException.classCast(t.getMessage());
            }
            catch (Throwable t) {
                throw PolyglotImpl.hostToGuestException(languageContext, t);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean checkPredicate(PolyglotLanguageContext languageContext, Object convertedValue, Predicate<Object> predicate) {
            try {
                return predicate.test(convertedValue);
            }
            catch (Throwable t) {
                throw PolyglotImpl.hostToGuestException(languageContext, t);
            }
        }
    }
}

