/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts.axis;

import java.util.Iterator;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.Timeline;
import org.netbeans.lib.profiler.charts.axis.AxisMark;
import org.netbeans.lib.profiler.charts.axis.AxisMarksComputer;
import org.netbeans.lib.profiler.charts.axis.TimeAxisUtils;
import org.netbeans.lib.profiler.charts.axis.TimeMark;
import org.netbeans.lib.profiler.charts.swing.Utils;

public class TimelineMarksComputer
extends AxisMarksComputer.Abstract {
    private final Timeline timeline;
    private double scale;
    private long step;
    private long firstTimestamp;
    private long lastTimestamp;

    public TimelineMarksComputer(Timeline timeline, ChartContext context, int orientation) {
        super(context, orientation);
        this.timeline = timeline;
        this.scale = -1.0;
        this.step = -1L;
    }

    @Override
    protected int getMinMarksDistance() {
        return 120;
    }

    @Override
    protected boolean refreshConfiguration() {
        double oldScale = this.scale;
        long oldFirstTimestamp = this.firstTimestamp;
        long oldLastTimestamp = this.lastTimestamp;
        this.scale = this.horizontal && this.context.getViewWidth() == 0L || !this.horizontal && this.context.getViewHeight() == 0L ? -1.0 : (this.horizontal ? this.context.getViewWidth(1.0) : this.context.getViewHeight(1.0));
        int timestampsCount = this.timeline.getTimestampsCount();
        if (this.horizontal) {
            this.firstTimestamp = timestampsCount == 0 ? (long)this.context.getDataX(0.0) : this.timeline.getTimestamp(0);
            this.lastTimestamp = timestampsCount == 0 ? (long)this.context.getDataX(this.context.getViewportWidth()) : Math.max(this.timeline.getTimestamp(timestampsCount - 1), (long)this.context.getDataX(this.context.getViewportWidth()));
        } else {
            this.firstTimestamp = timestampsCount == 0 ? (long)this.context.getDataY(0.0) : this.timeline.getTimestamp(0);
            long l = this.lastTimestamp = timestampsCount == 0 ? (long)this.context.getDataY(this.context.getViewportWidth()) : Math.max(this.timeline.getTimestamp(timestampsCount - 1), (long)this.context.getDataY(this.context.getViewportWidth()));
        }
        if (oldScale != this.scale) {
            this.step = this.scale == -1.0 ? -1L : TimeAxisUtils.getTimeUnits(this.scale, this.getMinMarksDistance());
            oldScale = this.scale;
            return true;
        }
        return oldFirstTimestamp != this.firstTimestamp || oldLastTimestamp != this.lastTimestamp;
    }

    @Override
    public Iterator<AxisMark> marksIterator(int start, int end) {
        if (this.step == -1L) {
            return EMPTY_ITERATOR;
        }
        final long dataStart = this.horizontal ? (long)this.context.getDataX(start) / this.step * this.step : (long)this.context.getDataY(start) / this.step * this.step;
        long dataEnd = this.horizontal ? (long)this.context.getDataX(end) / this.step * this.step : (long)this.context.getDataY(end) / this.step * this.step;
        final long iterCount = Math.abs(dataEnd - dataStart) / this.step + 2L;
        final long[] iterIndex = new long[]{0L};
        final String format = TimeAxisUtils.getFormatString(this.step, this.firstTimestamp, this.lastTimestamp);
        return new AxisMarksComputer.AbstractIterator(){

            @Override
            public boolean hasNext() {
                return iterIndex[0] < iterCount;
            }

            @Override
            public AxisMark next() {
                long value = TimelineMarksComputer.this.reverse ? dataStart - iterIndex[0] * TimelineMarksComputer.this.step : dataStart + iterIndex[0] * TimelineMarksComputer.this.step;
                iterIndex[0] = iterIndex[0] + 1L;
                int position = TimelineMarksComputer.this.horizontal ? Utils.checkedInt(Math.ceil(TimelineMarksComputer.this.context.getViewX(value))) : Utils.checkedInt(Math.ceil(TimelineMarksComputer.this.context.getViewY(value)));
                return new TimeMark(value, position, format);
            }
        };
    }
}

